<?xml version="1.0" encoding="ISO-8859-1"?>
  <xsl:stylesheet version="1.0" 
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:saxon="http://icl.com/saxon" extension-element-prefixes="saxon" xmlns="http://www.w3.org/1999/xhtml">

<xsl:output encoding="iso-8859-1" indent="yes" method="html" omit-xml-declaration="no" doctype-public="-//W3C//DTD HTML 4.01//EN"/>

<xsl:template match="matrix">

<html><xsl:attribute name="lang"><xsl:value-of select="@xml:lang"/></xsl:attribute>
  
<head>
    <meta http-equiv="Content-Language"><xsl:attribute name="content"><xsl:value-of select="@xml:lang"/></xsl:attribute></meta>
    
    <title><xsl:value-of select="@name"/></title>
</head>

<style type="text/css">
<![CDATA[
body {
color: black;
background: white;
font-family: "Myriad Web", "Arial Unicode MS", Helvetica, Arial, Geneva, sans-serif;
padding: 5%;
margin: 0;
}

table  { margin: 0 auto 2em auto; }
th     { padding: .5em 1em; }
td     { padding: 0.1em .2em; margin: 0; }
td, th { text-align: center; }

td.yes { background: #73ab73; color: white; border-color: #73ab73; }
td.no  { background: #9a6262; color: white; border-color: #9a6262; }
td.partially { background: #d8d89c; color: black; border-color: #d8d89c; }
td.unknown { background: #b38fbf; color: black; border-color: #b38fbf; }

td :link, td :visited                     { color: white !important; background: transparent; }
td.partially :link, td.partially :visited { color: black !important; background: transparent; }

td[class] { border-style: outset; border-width: 1px; /* border-left: none; border-right: none; */ }
]]>
</style>

<body>

    <table cellspacing="0">
        <xsl:apply-templates/>
    </table>

    <xsl:for-each select="//matrix/body/row">
      <xsl:if test="count(cell/text()) != 0">
        <hr/>
      </xsl:if>
      <xsl:variable name="rowNumber" select="position()"/>
      <xsl:for-each select="cell">
      <xsl:if test="text()">
      <xsl:variable name="columnNumber" select="position()"/>
      <p>
      <a><xsl:attribute name="name"><xsl:value-of select="$rowNumber"/>-<xsl:value-of select="$columnNumber"/></xsl:attribute><xsl:value-of select="$rowNumber"/>-<xsl:value-of select="$columnNumber"/></a>
      <xsl:text> </xsl:text><xsl:apply-templates/></p>
      </xsl:if>
      </xsl:for-each>
    </xsl:for-each>

</body>

</html>

</xsl:template>

<xsl:template match="header">
    <thead>
    <xsl:for-each select="row">
        <tr><xsl:apply-templates/></tr>
    </xsl:for-each>
    </thead>
</xsl:template>

<xsl:template match="body">
    <tbody>
    <xsl:for-each select="row">
	<xsl:variable name="rowNumber" select="position()"/>
        <tr>
	<xsl:for-each select="cell">
	    <td>
	    <xsl:if test="@value='yes' or @value='no' or @value='partially' or @value='unknown'">
	    <xsl:attribute name="class">
	        <xsl:value-of select="@value"/>        
	    </xsl:attribute>
	    </xsl:if>
	    <xsl:value-of select="@value"/>
	<xsl:if test="text()">
	<sup><a><xsl:attribute name="href">#<xsl:value-of select="$rowNumber"/>-<xsl:value-of select="position()"/></xsl:attribute><xsl:value-of select="$rowNumber"/>-<xsl:value-of select="position()"/></a></sup>
	</xsl:if>
	    </td>
	</xsl:for-each>
	</tr>
    </xsl:for-each>
    </tbody>
</xsl:template>

<xsl:template match="cell">
<xsl:apply-templates/>
</xsl:template>

<xsl:template match="header/row/cell">
    <th><xsl:value-of select="@value"/></th>
</xsl:template>

<xsl:template match="emph">
    <em><xsl:apply-templates/></em>
</xsl:template>

<xsl:template match="bug">
    <a><xsl:attribute name="href">http://www.abisource.com/bugzilla/show_bug.cgi?id=<xsl:value-of select="@id"/></xsl:attribute>bug&#xa0;<xsl:value-of select="@id"/></a>
</xsl:template>

<xsl:template match="abbr">
    <abbr>
      <xsl:if test="@title">
        <xsl:attribute name="title"><xsl:value-of select="@title"/></xsl:attribute>
      </xsl:if>
      <xsl:apply-templates/></abbr>
</xsl:template>


</xsl:stylesheet>
