/* AbiWord
 * Copyright (C) 2001 Dom Lachowicz <doml@appligent.com>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */

#ifndef BZ2ABIWORD_H
#define BZ2ABIWORD_H

#include <stdio.h>
#include <bzlib.h>

#include "ie_imp_AbiWord_1.h"
#include "ie_exp_AbiWord_1.h"

class IE_Imp_BZ2AbiWord_Sniffer : public IE_ImpSniffer
{
  friend class IE_Imp;
  
 public:
  
 public:
  IE_Imp_BZ2AbiWord_Sniffer() {}
  virtual ~IE_Imp_BZ2AbiWord_Sniffer() {}
  
  virtual bool recognizeContents (const char * szBuf, 
				  UT_uint32 iNumbytes);
  virtual bool recognizeSuffix (const char * szSuffix);
  virtual bool getDlgLabels (const char ** szDesc,
			     const char ** szSuffixList,
			     IEFileType * ft);
  virtual UT_Error constructImporter (PD_Document * pDocument,
				      IE_Imp ** ppie);	
};

class IE_Imp_BZ2AbiWord : public IE_Imp_AbiWord_1
{
 public:
  IE_Imp_BZ2AbiWord(PD_Document * pDocument);
  ~IE_Imp_BZ2AbiWord();

 protected:
  virtual bool			_openFile(const char * szFilename);
  virtual UT_uint32		_readBytes(char * buf, UT_uint32 length);
  virtual void			_closeFile(void);
  
 private:
  FILE   *m_fp;
  BZFILE *m_bzin;
};

class IE_Exp_BZ2AbiWord_Sniffer : public IE_ExpSniffer
{
	friend class IE_Exp;

public:
	IE_Exp_BZ2AbiWord_Sniffer () {}
	virtual ~IE_Exp_BZ2AbiWord_Sniffer () {}

	virtual bool recognizeSuffix (const char * szSuffix);
	virtual bool getDlgLabels (const char ** szDesc,
				   const char ** szSuffixList,
				   IEFileType * ft);
	virtual UT_Error constructExporter (PD_Document * pDocument,
					    IE_Exp ** ppie);
};


class IE_Exp_BZ2AbiWord : public IE_Exp_AbiWord_1
{
public:
	IE_Exp_BZ2AbiWord(PD_Document * pDocument);
	virtual ~IE_Exp_BZ2AbiWord();

protected:
	bool				_openFile(const char * szFilename);
	UT_uint32			_writeBytes(const UT_Byte * pBytes, UT_uint32 length);
	bool				_closeFile(void);

private:
	FILE   *m_fp;
	BZFILE *m_bzout;
};

#endif
