/*
 *   A simple ADEOS domain module.
 *
 *   Copyright (C) 2002 Philippe Gerum.
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, Inc., 675 Mass Ave, Cambridge MA 02139,
 *   USA; either version 2 of the License, or (at your option) any later
 *   version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *   This module implements a trivial ADEOS client domain. Basically,
 *   it creates an ADEOS domain which has a higher priority in the
 *   pipeline than the root (i.e. Linux) domain, then virtualizes the
 *   timer interrupt for it. As a result of this, each timer tick is
 *   first processed by this domain's timer_tick() routine, then by
 *   the Linux domain handler.
 */

#include <linux/version.h>
#include <linux/module.h>
#include <linux/wrapper.h>
#include <linux/config.h>
#include <linux/kernel.h>
#include <linux/slab.h>
#include <linux/init.h>
#include <asm/system.h>

MODULE_LICENSE("GPL");

static adomain_t this_domain;

void timer_tick (void)

{
    static int i;

    if ((++i % 100) == 0)
	 printk("TIMER TICKED %d TIMES\n",i);

    __asm("iret");
}

void domain_entry (void)

{
    printk("Domain %s started.\n",adp_current->name);

    adeos_virtualize_irq(0,&timer_tick,NULL);

    for (;;)
	/* This is this domain's idle loop. */
	adeos_suspend_domain();	/* Yield control back to ADEOS. */
}

static int __init __adtest_init (void)

{
    adattr_t attr;

    attr.name = "TestDomain";
    attr.entry = &domain_entry;
    attr.estacksz = 0;	/* Let ADEOS choose a reasonable stack size */
    attr.priority = ADEOS_ROOT_PRI + 1;

    return adeos_register_domain(&this_domain,&attr);
}

static void __exit __adtest_exit (void)

{
    adeos_unregister_domain(&this_domain);
}

module_init(__adtest_init);
module_exit(__adtest_exit);
