/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.runtime.reflect;

import java.lang.reflect.Modifier;

class StringMaker {
    boolean shortTypeNames = true;
    boolean includeArgs = true;
    boolean includeThrows = false;
    boolean includeModifiers = false;
    boolean shortPrimaryTypeNames = false;
    boolean includeJoinPointTypeName = true;
    boolean includeEnclosingPoint = true;
    boolean shortKindName = true;
    static StringMaker shortStringMaker = new StringMaker();
    static StringMaker middleStringMaker;
    static StringMaker longStringMaker;

    StringMaker() {
    }

    String makeKindName(String string) {
        int n = string.lastIndexOf(45);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    String makeModifiersString(int n) {
        if (!this.includeModifiers) {
            return "";
        }
        String string = Modifier.toString(n);
        if (string.length() == 0) {
            return "";
        }
        return string + " ";
    }

    String stripPackageName(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    String makeTypeName(Class clazz, boolean bl) {
        if (clazz == null) {
            return "ANONYMOUS";
        }
        if (clazz.isArray()) {
            return this.makeTypeName(clazz.getComponentType(), bl) + "[]";
        }
        if (bl) {
            return this.stripPackageName(clazz.getName()).replace('$', '.');
        }
        return clazz.getName().replace('$', '.');
    }

    public String makeTypeName(Class clazz) {
        return this.makeTypeName(clazz, this.shortTypeNames);
    }

    public String makePrimaryTypeName(Class clazz) {
        return this.makeTypeName(clazz, this.shortPrimaryTypeNames);
    }

    public void addTypeNames(StringBuffer stringBuffer, Class[] classArray) {
        int n = 0;
        while (n < classArray.length) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.makeTypeName(classArray[n]));
            ++n;
        }
    }

    public void addSignature(StringBuffer stringBuffer, Class[] classArray) {
        if (classArray == null) {
            return;
        }
        if (!this.includeArgs) {
            if (classArray.length == 0) {
                stringBuffer.append("()");
                return;
            }
            stringBuffer.append("(..)");
            return;
        }
        stringBuffer.append("(");
        this.addTypeNames(stringBuffer, classArray);
        stringBuffer.append(")");
    }

    public void addThrows(StringBuffer stringBuffer, Class[] classArray) {
        if (!this.includeThrows || classArray == null || classArray.length == 0) {
            return;
        }
        stringBuffer.append(" throws ");
        this.addTypeNames(stringBuffer, classArray);
    }

    static {
        StringMaker.shortStringMaker.shortTypeNames = true;
        StringMaker.shortStringMaker.includeArgs = false;
        StringMaker.shortStringMaker.includeThrows = false;
        StringMaker.shortStringMaker.includeModifiers = false;
        StringMaker.shortStringMaker.shortPrimaryTypeNames = true;
        StringMaker.shortStringMaker.includeJoinPointTypeName = false;
        StringMaker.shortStringMaker.includeEnclosingPoint = false;
        middleStringMaker = new StringMaker();
        StringMaker.middleStringMaker.shortTypeNames = true;
        StringMaker.middleStringMaker.includeArgs = true;
        StringMaker.middleStringMaker.includeThrows = false;
        StringMaker.middleStringMaker.includeModifiers = false;
        StringMaker.middleStringMaker.shortPrimaryTypeNames = false;
        longStringMaker = new StringMaker();
        StringMaker.longStringMaker.shortTypeNames = false;
        StringMaker.longStringMaker.includeArgs = true;
        StringMaker.longStringMaker.includeThrows = false;
        StringMaker.longStringMaker.includeModifiers = true;
        StringMaker.longStringMaker.shortPrimaryTypeNames = false;
        StringMaker.longStringMaker.shortKindName = false;
    }
}

