/***************************************************************************
                          msnd_pinnacle_mixer.c  -  description
                             -------------------
    begin                : Fre Jun 7 2002
    copyright            : (C) 2002 by karsten wiese
    email                : annabellesgarden@yahoo.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <sound/driver.h>
#include <sound/core.h>
#include <sound/control.h>
#include "msnd.h"
#include "msnd_pinnacle.h"


static int snd_msndmix_volume_info(snd_kcontrol_t * kcontrol, snd_ctl_elem_info_t * uinfo);
static int snd_msndmix_volume_get(snd_kcontrol_t * kcontrol, snd_ctl_elem_value_t * ucontrol);
static int snd_msndmix_volume_put(snd_kcontrol_t * kcontrol, snd_ctl_elem_value_t * ucontrol);


//extern multisound_dev_t		dev;
#define SOUND_MIXER_VOLUME	0
#define SOUND_MIXER_BASS	1
#define SOUND_MIXER_TREBLE	2
#define SOUND_MIXER_SYNTH	3
#define SOUND_MIXER_PCM		4
#define SOUND_MIXER_SPEAKER	5
#define SOUND_MIXER_LINE	6
#define SOUND_MIXER_MIC		7
#define SOUND_MIXER_CD		8
#define SOUND_MIXER_IMIX	9	/*  Recording monitor  */
#define SOUND_MIXER_ALTPCM	10
#define SOUND_MIXER_RECLEV	11	/* Recording level */
#define SOUND_MIXER_IGAIN	12	/* Input gain */
#define SOUND_MIXER_OGAIN	13	/* Output gain */
#define SOUND_MIXER_LINE1	14	/* Input source 1  (aux1) */
#define SOUND_MIXER_LINE2	15	/* Input source 2  (aux2) */
#define SOUND_MIXER_DIGITAL1	17	/* Digital (input) 1 */

/*	Device mask bits	*/

#define SOUND_MASK_VOLUME	(1 << SOUND_MIXER_VOLUME)
#define SOUND_MASK_BASS		(1 << SOUND_MIXER_BASS)
#define SOUND_MASK_TREBLE	(1 << SOUND_MIXER_TREBLE)
#define SOUND_MASK_SYNTH	(1 << SOUND_MIXER_SYNTH)
#define SOUND_MASK_PCM		(1 << SOUND_MIXER_PCM)
#define SOUND_MASK_SPEAKER	(1 << SOUND_MIXER_SPEAKER)
#define SOUND_MASK_LINE		(1 << SOUND_MIXER_LINE)
#define SOUND_MASK_MIC		(1 << SOUND_MIXER_MIC)
#define SOUND_MASK_CD		(1 << SOUND_MIXER_CD)
#define SOUND_MASK_IMIX		(1 << SOUND_MIXER_IMIX)
#define SOUND_MASK_ALTPCM	(1 << SOUND_MIXER_ALTPCM)
#define SOUND_MASK_RECLEV	(1 << SOUND_MIXER_RECLEV)
#define SOUND_MASK_IGAIN	(1 << SOUND_MIXER_IGAIN)
#define SOUND_MASK_OGAIN	(1 << SOUND_MIXER_OGAIN)
#define SOUND_MASK_LINE1	(1 << SOUND_MIXER_LINE1)
#define SOUND_MASK_LINE2	(1 << SOUND_MIXER_LINE2)
#define SOUND_MASK_LINE3	(1 << SOUND_MIXER_LINE3)
#define SOUND_MASK_DIGITAL1	(1 << SOUND_MIXER_DIGITAL1)
#define SOUND_MASK_DIGITAL2	(1 << SOUND_MIXER_DIGITAL2)
#define SOUND_MASK_DIGITAL3	(1 << SOUND_MIXER_DIGITAL3)
#define SOUND_MASK_PHONEIN	(1 << SOUND_MIXER_PHONEIN)
#define SOUND_MASK_PHONEOUT	(1 << SOUND_MIXER_PHONEOUT)
#define SOUND_MASK_RADIO	(1 << SOUND_MIXER_RADIO)
#define SOUND_MASK_VIDEO	(1 << SOUND_MIXER_VIDEO)
#define SOUND_MASK_MONITOR	(1 << SOUND_MIXER_MONITOR)



#define DUMMY_CAPSRC(xname, xindex, addr) \
{ iface: SNDRV_CTL_ELEM_IFACE_MIXER, name: xname, index: xindex, \
  info: snd_msndmix_capsrc_info, \
  get: snd_msndmix_capsrc_get, put: snd_msndmix_capsrc_put, \
  private_value: addr }

static int snd_msndmix_capsrc_info(snd_kcontrol_t * kcontrol, snd_ctl_elem_info_t * uinfo)
{
	uinfo->type = SNDRV_CTL_ELEM_TYPE_BOOLEAN;
	uinfo->count = 1;
	uinfo->value.integer.min = 0;
	uinfo->value.integer.max = 1;
	return 0;
}

static int snd_msndmix_capsrc_get(snd_kcontrol_t * kcontrol, snd_ctl_elem_value_t * ucontrol)
{
multisound_dev_t *dummy = _snd_kcontrol_chip(kcontrol);
// unsigned long flags;

// spin_lock_irqsave(&dummy->mixer_lock, flags);
unsigned mask = 0;

	switch( kcontrol->private_value){
	case SOUND_MIXER_IMIX:
		mask = SOUND_MASK_IMIX;
	break;
	case SOUND_MIXER_SYNTH:
		mask = SOUND_MASK_SYNTH;
	break;
	case SOUND_MIXER_DIGITAL1:
		mask = SOUND_MASK_DIGITAL1;
	break;
	}
	ucontrol->value.integer.value[0] = dummy->recsrc & mask  ?  1  :  0;
// spin_unlock__irqrestore(&dummy->mixer_lock, flags);
return 0;
}

static int snd_msndmix_capsrc_put(snd_kcontrol_t * kcontrol, snd_ctl_elem_value_t * ucontrol)
{
multisound_dev_t *dummy = _snd_kcontrol_chip(kcontrol);
// unsigned long flags;
int change;
unsigned mask = 0;

#ifdef CONFIG_SND_DEBUG0
	printk( "snd_msndmix_capsrc_put( , 0x%X)\n", (unsigned)ucontrol->value.integer.value[0]);
#endif
	
	if( ucontrol->value.integer.value[0])
		switch( kcontrol->private_value){
		default:
  		case SOUND_MIXER_IMIX:
  			mask = SOUND_MASK_IMIX;
		break;
  		case SOUND_MIXER_SYNTH:
  			mask = SOUND_MASK_SYNTH;
	  	break;
  		case SOUND_MIXER_DIGITAL1:
  			mask = SOUND_MASK_DIGITAL1;
		break;
  		}
  	
	change =  mask != dummy->recsrc;

// spin_lock_irqsave(&dummy->mixer_lock, flags);
	if( change){
#ifdef CONFIG_SND_DEBUG0
	printk( "dummy->recsrc = 0x%X; mask=%i\n", (unsigned)dummy->recsrc, mask);
#endif
		if (mask & SOUND_MASK_IMIX) {
			if (snd_msnd_send_word( dummy, 0, 0, HDEXAR_SET_ANA_IN) == 0)
				chk_send_dsp_cmd( dummy, HDEX_AUX_REQ);
		}
		else if (mask & SOUND_MASK_SYNTH) {
			if (snd_msnd_send_word( dummy, 0, 0, HDEXAR_SET_SYNTH_IN) == 0)
				chk_send_dsp_cmd( dummy, HDEX_AUX_REQ);
		}
		else if ((mask & SOUND_MASK_DIGITAL1) && test_bit(F_HAVEDIGITAL, &dummy->flags)) {
			if (snd_msnd_send_word( dummy, 0, 0, HDEXAR_SET_DAT_IN) == 0)
				chk_send_dsp_cmd( dummy, HDEX_AUX_REQ);
		}

		dummy->recsrc = mask;
	}
// spin_unlock__irqrestore(&dummy->mixer_lock, flags);
return change;
}



#define DUMMY_VOLUME(xname, xindex, addr) \
{ iface: SNDRV_CTL_ELEM_IFACE_MIXER, name: xname, index: xindex, \
  info: snd_msndmix_volume_info, \
  get: snd_msndmix_volume_get, put: snd_msndmix_volume_put, \
  private_value: addr }


#define DUMMY_CONTROLS (sizeof(snd_msnd_controls)/sizeof(snd_kcontrol_new_t))

static snd_kcontrol_new_t snd_msnd_controls[] = {
DUMMY_VOLUME(	"Master Volume",0, SOUND_MIXER_VOLUME),
//DUMMY_CAPSRC("Master Capture Switch", 0, MIXER_ADDR_MASTER),
DUMMY_VOLUME(	"PCM Volume",	0, SOUND_MIXER_PCM),
DUMMY_VOLUME(	"Analog Volume",	0, SOUND_MIXER_IMIX),
DUMMY_CAPSRC(	"Analog Capture Switch", 0, SOUND_MIXER_IMIX),
DUMMY_VOLUME(	"Line0 Volume",	0, SOUND_MIXER_LINE),
DUMMY_VOLUME(	"Line1 Volume",	0, SOUND_MIXER_LINE1),
//DUMMY_CAPSRC("Line Capture Switch", 0, MIXER_ADDR_MASTER),
DUMMY_VOLUME(	"Mic Volume",	0, SOUND_MIXER_MIC),
//DUMMY_VOLUME("CD Volume", 0, MIXER_ADDR_CD),
DUMMY_VOLUME(	"Kurzweil",		0, SOUND_MIXER_SYNTH),
DUMMY_CAPSRC(	"Kurzweil Capture Switch", 0, SOUND_MIXER_SYNTH),
DUMMY_CAPSRC(	"SPDIF Capture Switch", 0, SOUND_MIXER_DIGITAL1)
};


static int snd_msndmix_volume_info(snd_kcontrol_t * kcontrol, snd_ctl_elem_info_t * uinfo)
{
	uinfo->type = SNDRV_CTL_ELEM_TYPE_INTEGER;
	uinfo->count = 2;
	uinfo->value.integer.min = 0;
	uinfo->value.integer.max = 100;
	return 0;
}

static int snd_msndmix_volume_get(snd_kcontrol_t * kcontrol, snd_ctl_elem_value_t * ucontrol)
{
multisound_dev_t *dummy = _snd_kcontrol_chip(kcontrol);
//	unsigned long flags;
int addr = kcontrol->private_value;

//	spin_lock_irqsave(&dummy->mixer_lock, flags);
	ucontrol->value.integer.value[0] = ( dummy->left_levels[ addr] * 100) / 0xFFFF;
	ucontrol->value.integer.value[1] = ( dummy->right_levels[ addr] * 100) / 0xFFFF;
//	spin_unlock_irqrestore(&dummy->mixer_lock, flags);
return 0;
}


#define update_volm(a,b)						\
	isa_writew((dev->left_levels[a] >> 1) *				\
	       isa_readw(dev->SMA + SMA_wCurrMastVolLeft) / 0xffff,	\
	       dev->SMA + SMA_##b##Left);				\
	isa_writew((dev->right_levels[a] >> 1)  *			\
	       isa_readw(dev->SMA + SMA_wCurrMastVolRight) / 0xffff,	\
	       dev->SMA + SMA_##b##Right);

#define update_potm(d,s,ar)						\
	isa_writeb((dev->left_levels[d] >> 8) *				\
	       isa_readw(dev->SMA + SMA_wCurrMastVolLeft) / 0xffff,	\
	       dev->SMA + SMA_##s##Left);				\
	isa_writeb((dev->right_levels[d] >> 8) *				\
	       isa_readw(dev->SMA + SMA_wCurrMastVolRight) / 0xffff,	\
	       dev->SMA + SMA_##s##Right);				\
	if (snd_msnd_send_word( dev, 0, 0, ar) == 0)			\
		chk_send_dsp_cmd( dev, HDEX_AUX_REQ);

#define update_pot(d,s,ar)				\
	isa_writeb(dev->left_levels[d] >> 8,		\
	       dev->SMA + SMA_##s##Left);		\
	isa_writeb(dev->right_levels[d] >> 8,		\
	       dev->SMA + SMA_##s##Right);		\
	if (snd_msnd_send_word( dev, 0, 0, ar) == 0)	\
		chk_send_dsp_cmd( dev, HDEX_AUX_REQ);


static int snd_msndmix_set( multisound_dev_t * dev, int d, int left, int right)
{
int bLeft, bRight;
int wLeft, wRight;
int updatemaster = 0;

#ifdef CONFIG_SND_DEBUG0
	printk( "mixer_set( multisound_dev_t * %X, d=%i, left=%i, right=%i\n",
		(unsigned)dev, d, left, right);
#endif

	if( d >= LEVEL_ENTRIES)
return -EINVAL;

	bLeft = left * 0xff / 100;
	wLeft = left * 0xffff / 100;

	bRight = right * 0xff / 100;
	wRight = right * 0xffff / 100;

	dev->left_levels[d] = wLeft;
	dev->right_levels[d] = wRight;

	switch (d) {
		/* master volume unscaled controls */
	case SOUND_MIXER_LINE:			/* line pot control */
		/* scaled by IMIX in digital mix */
		isa_writeb(bLeft, dev->SMA + SMA_bInPotPosLeft);
		isa_writeb(bRight, dev->SMA + SMA_bInPotPosRight);
		if (snd_msnd_send_word( dev, 0, 0, HDEXAR_IN_SET_POTS) == 0)
			chk_send_dsp_cmd( dev, HDEX_AUX_REQ);
		break;
#ifndef MSND_CLASSIC
	case SOUND_MIXER_MIC:			/* mic pot control */
		/* scaled by IMIX in digital mix */
		isa_writeb(bLeft, dev->SMA + SMA_bMicPotPosLeft);
		isa_writeb(bRight, dev->SMA + SMA_bMicPotPosRight);
		if (snd_msnd_send_word( dev, 0, 0, HDEXAR_MIC_SET_POTS) == 0)
			chk_send_dsp_cmd( dev, HDEX_AUX_REQ);
		break;
#endif
	case SOUND_MIXER_VOLUME:		/* master volume */
		isa_writew(wLeft, dev->SMA + SMA_wCurrMastVolLeft);
		isa_writew(wRight, dev->SMA + SMA_wCurrMastVolRight);
		/* fall through */

	case SOUND_MIXER_LINE1:			/* aux pot control */
		/* scaled by master volume */
		/* fall through */

		/* digital controls */
	case SOUND_MIXER_SYNTH:			/* synth vol (dsp mix) */
	case SOUND_MIXER_PCM:			/* pcm vol (dsp mix) */
	case SOUND_MIXER_IMIX:			/* input monitor (dsp mix) */
		/* scaled by master volume */
		updatemaster = 1;
		break;

	default:
		return 0;
	}

	if (updatemaster) {
		/* update master volume scaled controls */
		update_volm(SOUND_MIXER_PCM, wCurrPlayVol);
		update_volm(SOUND_MIXER_IMIX, wCurrInVol);
#ifndef MSND_CLASSIC
		update_volm(SOUND_MIXER_SYNTH, wCurrMHdrVol);
#endif
		update_potm(SOUND_MIXER_LINE1, bAuxPotPos, HDEXAR_AUX_SET_POTS);
	}

return 0;//snd_msndmix_get( dev, d);
}


static int snd_msndmix_volume_put(snd_kcontrol_t * kcontrol, snd_ctl_elem_value_t * ucontrol)
{
	multisound_dev_t *dummy = _snd_kcontrol_chip(kcontrol);
// unsigned long flags;
	int change, addr = kcontrol->private_value;
	int left, right;

#ifdef CONFIG_SND_DEBUG0
	printk( "snd_msndmix_volume_put( addr=%i, l=%i, r=%i)\n", addr, (int)ucontrol->value.integer.value[0], (int)ucontrol->value.integer.value[1]);
#endif

	left = ucontrol->value.integer.value[0] % 101;
	right = ucontrol->value.integer.value[1] % 101;
// spin_lock_irqsave(&dummy->mixer_lock, flags);
	change = dummy->left_levels[ addr] != left &&
	         dummy->right_levels[ addr] != right;
	
	snd_msndmix_set( dummy, addr, left, right);

	//dummy->left_levels[ addr] = left;
	//dummy->right_levels[ addr] = right;
// spin_unlock__irqrestore(&dummy->mixer_lock, flags);
	return change;
}



int __init snd_msndmix_new( multisound_dev_t * dummy)
{
snd_card_t *card = dummy->card;
int idx, err;

	snd_assert(dummy != NULL, return -EINVAL);
// spin_lock_init(&dummy->mixer_lock);
	strcpy(card->mixername, "MSND Pinnacle Mixer");

	for (idx = 0; idx < DUMMY_CONTROLS; idx++) {
		if ((err = snd_ctl_add(card, snd_ctl_new1(&snd_msnd_controls[idx], dummy))) < 0)
			return err;
	}

#ifndef MSND_CLASSIC
//	snd_msndmix_force_recsrc( dummy, SOUND_MASK_IMIX);
#endif

return 0;
}


/* unused static int snd_msndmix_get( multisound_dev_t * dev, int d)
{
	if( d >= LEVEL_ENTRIES)
return -EINVAL;

	switch (d) {
	case SOUND_MIXER_VOLUME:
	case SOUND_MIXER_PCM:
	case SOUND_MIXER_LINE:
	case SOUND_MIXER_IMIX:
	case SOUND_MIXER_LINE1:
#ifndef MSND_CLASSIC
	case SOUND_MIXER_MIC:
	case SOUND_MIXER_SYNTH:
#endif
return ( dev->left_levels[d] >> 8) * 100 / 0xff |
			(((dev->right_levels[d] >> 8) * 100 / 0xff) << 8);
	default:
return 0;
	}
}         */



void snd_msndmix_setup( multisound_dev_t * dev)
{
	update_pot(SOUND_MIXER_LINE, bInPotPos, HDEXAR_IN_SET_POTS);
	update_potm(SOUND_MIXER_LINE1, bAuxPotPos, HDEXAR_AUX_SET_POTS);
	update_volm(SOUND_MIXER_PCM, wCurrPlayVol);
	update_volm(SOUND_MIXER_IMIX, wCurrInVol);
#ifndef MSND_CLASSIC
	update_pot(SOUND_MIXER_MIC, bMicPotPos, HDEXAR_MIC_SET_POTS);
	update_volm(SOUND_MIXER_SYNTH, wCurrMHdrVol);
#endif

}

static unsigned long snd_msndmix_set_recsrc( multisound_dev_t * dev, unsigned long recsrc)
{
#ifdef CONFIG_SND_DEBUG0
	printk( "snd_msndmix_set_recsrc( , 0x%X)\n", (unsigned)recsrc);
#endif
	if (dev->recsrc == recsrc)
		return dev->recsrc;
#ifdef HAVE_NORECSRC
	else if (recsrc == 0)
		dev->recsrc = 0;
#endif
	else
		dev->recsrc ^= recsrc;

#ifndef MSND_CLASSIC
#ifdef CONFIG_SND_DEBUG0
	printk( "dev->recsrc 0x%X\n", (unsigned)dev->recsrc);
#endif
	if (dev->recsrc & SOUND_MASK_IMIX) {
		if (snd_msnd_send_word( dev, 0, 0, HDEXAR_SET_ANA_IN) == 0)
			chk_send_dsp_cmd( dev, HDEX_AUX_REQ);
	}
	else if (dev->recsrc & SOUND_MASK_SYNTH) {
		if (snd_msnd_send_word( dev, 0, 0, HDEXAR_SET_SYNTH_IN) == 0)
			chk_send_dsp_cmd( dev, HDEX_AUX_REQ);
	}
	else if ((dev->recsrc & SOUND_MASK_DIGITAL1) && test_bit(F_HAVEDIGITAL, &dev->flags)) {
		if (snd_msnd_send_word( dev, 0, 0, HDEXAR_SET_DAT_IN) == 0)
      			chk_send_dsp_cmd( dev, HDEX_AUX_REQ);
	}
	else {
#ifdef HAVE_NORECSRC
		/ * Select no input (?) * /
		dev->recsrc = 0;
#else
		dev->recsrc = SOUND_MASK_IMIX;
		if (snd_msnd_send_word(dev, 0, 0, HDEXAR_SET_ANA_IN) == 0)
			chk_send_dsp_cmd(dev, HDEX_AUX_REQ);
#endif
	}
#endif / * MSND_CLASSIC * /

return dev->recsrc;
}

unsigned long snd_msndmix_force_recsrc( multisound_dev_t * dev, unsigned long recsrc)
{
//	snd_msndmix_set( dev, SOUND_MIXER_VOLUME, 100, 100);
//	snd_msndmix_set( dev, SOUND_MIXER_LINE, 70, 70);
//	snd_msndmix_set( dev, SOUND_MIXER_IMIX, 100, 100);
	if( 0 == recsrc)
		recsrc = SOUND_MASK_IMIX;
	dev->recsrc = 0;
	return snd_msndmix_set_recsrc( dev, recsrc);
}


#ifdef notficxd0

#define set_mixer_info()							\
		strncpy(info.id, "MSNDMIXER", sizeof(info.id));			\
		strncpy(info.name, "MultiSound Mixer", sizeof(info.name));
static int mixer_ioctl(unsigned int cmd, unsigned long arg)
{
	if (cmd == SOUND_MIXER_INFO) {
		mixer_info info;
		set_mixer_info();
		info.modify_counter = dev.mixer_mod_count;
		return copy_to_user((void *)arg, &info, sizeof(info));
	} else if (cmd == SOUND_OLD_MIXER_INFO) {
		_old_mixer_info info;
		set_mixer_info();
		return copy_to_user((void *)arg, &info, sizeof(info));
	} else if (cmd == SOUND_MIXER_PRIVATE1) {
		dev.nresets = 0;
		dsp_full_reset();
		return 0;
	} else if (((cmd >> 8) & 0xff) == 'M') {
		int val = 0;

		if (_SIOC_DIR(cmd) & _SIOC_WRITE) {
			switch (cmd & 0xff) {
			case SOUND_MIXER_RECSRC:
				if (get_user(val, (int *)arg))
					return -EFAULT;
				val = snd_msndmix_set_recsrc(val);
				break;

			default:
				if (get_user(val, (int *)arg))
					return -EFAULT;
				val = mixer_set(cmd & 0xff, val);
				break;
			}
			++dev.mixer_mod_count;
			return put_user(val, (int *)arg);
		} else {
			switch (cmd & 0xff) {
			case SOUND_MIXER_RECSRC:
				val = dev.recsrc;
				break;

			case SOUND_MIXER_DEVMASK:
			case SOUND_MIXER_STEREODEVS:
				val =   SOUND_MASK_PCM |
					SOUND_MASK_LINE |
					SOUND_MASK_IMIX |
					SOUND_MASK_LINE1 |
#ifndef MSND_CLASSIC
					SOUND_MASK_MIC |
					SOUND_MASK_SYNTH |
#endif
					SOUND_MASK_VOLUME;
				break;
				
			case SOUND_MIXER_RECMASK:
#ifdef MSND_CLASSIC
				val =   0;
#else
				val =   SOUND_MASK_IMIX |
					SOUND_MASK_SYNTH;
				if (test_bit(F_HAVEDIGITAL, &dev.flags))
					val |= SOUND_MASK_DIGITAL1;
#endif
				break;
				
			case SOUND_MIXER_CAPS:
				val =   SOUND_CAP_EXCL_INPUT;
				break;

			default:
				if ((val = mixer_get(cmd & 0xff)) < 0)
					return -EINVAL;
				break;
			}
		}

		return put_user(val, (int *)arg);
	}

	return -EINVAL;
}
#endif
