/*
 *  Copyright (c) 2002 Martin Soto
 *
 *  Use and distribute under the terms of the GNU GPL Version 2
 */


/* Be careful before changing the includes.  The order is very
   important. */

/* Standard C library */
#include <stdio.h>
#include <stdlib.h>

/* The local definitions for libasound, taken from the source tarball.
   They are necessary if we want to include emu10k1.h (see below).  */
#include <local.h>

/* Standard libasound header file. */
#include <alsa/asoundlib.h>

/* Emu10k1 definitions from ALSA. */
#include <sound/emu10k1.h>


int main( int argc, char *argv[] )
{
    char *dev_name;
    snd_hwdep_t *hwdep;
    int ret;
    unsigned i, j;

    emu10k1_fx8010_code_t code;
    emu10k1_fx8010_control_gpr_t controls[256], *control;

    if ( argc < 2 ) {
        fprintf( stderr, "Insufficient arguments\n" );
        return -1;
    }
    dev_name = argv[1];

    ret = snd_hwdep_open( &hwdep, dev_name, 0 );
    if ( ret < 0 ) {
        fprintf( stderr, "%s: %s\n", dev_name, snd_strerror( ret ) );
        return -1;
    }

    code.gpr_list_controls = controls;
    code.gpr_list_control_count = 256;
    ret = snd_hwdep_ioctl( hwdep, SNDRV_EMU10K1_IOCTL_CODE_PEEK, &code );
    if ( ret < 0 ) {
        fprintf( stderr, "SNDRV_EMU10K1_IOCTL_CODE_PEEK: %s\n",
                 snd_strerror( ret ) );
        return -1;
    }

    printf( "%s\n\n", code.name );

    printf( "GPR controls: %d\n", code.gpr_list_control_total );
    for ( i = 0; i < code.gpr_list_control_total; i++ ) {
        control = code.gpr_list_controls + i;
        printf( "%d: %s\n ", i, control->id.name );
        for ( j = 0; j < control->count; j++ ) {
            printf( " %d", control->gpr[j] );
        }
        printf( "\n" );
    }

    return 0;
}
