/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.analyzer;

import org.apache.tools.analyzer.Decompiler;
import org.apache.tools.analyzer.DecompilerException;
import org.apache.tools.analyzer.OpcData;

public class Type
implements OpcData {
    private boolean exact;
    private boolean invalid;
    private String type = null;

    private Type() {
    }

    public Type(int n, String string) throws DecompilerException {
        if (n == 2) {
            this.jvmInfo(string);
        } else if (n == 3) {
            this.extendedInfo(string);
        } else if (n == 11) {
            this.undeterminedInfo(string);
        } else {
            throw new DecompilerException(3831);
        }
    }

    public Type(String string) throws DecompilerException {
        this.type = string;
        this.exact = true;
    }

    public Type arrayElementType() {
        if (!this.exact) {
            return null;
        }
        String string = this.type.substring(this.type.length() - 2, this.type.length());
        if (string.equals("[]")) {
            Type type = this.copy();
            type.type = type.type.substring(0, type.type.length() - 2);
            return type;
        }
        return null;
    }

    public Type copy() {
        Type type = new Type();
        type.type = this.type;
        type.exact = this.exact;
        type.invalid = this.invalid;
        return type;
    }

    private void extendedInfo(String string) throws DecompilerException {
        this.exact = true;
        if (string == "java/lang/String") {
            this.type = "java/lang/String";
        } else if (string == "float" || string == "double" || string == "long" || string == "subroutineReturnAddress" || string == "byte" || string == "char" || string == "short" || string == "boolean") {
            this.type = string;
        } else if (string == "Object") {
            this.type = "UnknownObject";
            this.exact = false;
        } else if (string == "int") {
            this.type = "UnknownInt";
            this.exact = false;
        } else {
            throw new DecompilerException(23301);
        }
    }

    public boolean fullyResolved() {
        return this.exact;
    }

    public String getBaseType() throws DecompilerException {
        if (this.type == "UnknownNumber" || this.type == "UnknownInt") {
            return "int";
        }
        if (this.type == "UnknownObject") {
            return "Object";
        }
        return Type.getBaseType(this.type);
    }

    private static String getBaseType(String string) throws DecompilerException {
        if (string.equals("int")) {
            return "int";
        }
        if (string.equals("boolean")) {
            return "int";
        }
        if (string.equals("char")) {
            return "int";
        }
        if (string.equals("byte")) {
            return "int";
        }
        if (string.equals("short")) {
            return "int";
        }
        if (string.equals("float")) {
            return "float";
        }
        if (string.equals("double")) {
            return "double";
        }
        if (string.equals("long")) {
            return "long";
        }
        if (string.equals("subroutineReturnAddress")) {
            return "subroutineReturnAddress";
        }
        if (string.equals("undeterminedZeroType")) {
            return "undeterminedZeroType";
        }
        return "Object";
    }

    public String getResolvedType() throws DecompilerException {
        if (!this.exact || this.invalid) {
            Decompiler.report("Invalid type used");
            return "invalid";
        }
        return this.type;
    }

    public String getResolvedTypeConstant() {
        if (this.invalid || this.type == "UnknownObject") {
            Decompiler.report("Invalid type used");
            return "invalid";
        }
        if (this.type == "UnknownInt" || this.type == "UnknownNumber") {
            return "int";
        }
        return this.type;
    }

    public String getType() {
        return this.type;
    }

    public boolean isArrayType() {
        if (!this.exact) {
            return false;
        }
        String string = this.type.substring(this.type.length() - 2, this.type.length());
        return string.equals("[]");
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    private void jvmInfo(String string) throws DecompilerException {
        if (string == "int") {
            this.type = "UnknownInt";
            this.exact = false;
        } else if (string == "float" || string == "double" || string == "long" || string == "subroutineReturnAddress") {
            this.type = string;
            this.exact = true;
        } else if (string == "Object") {
            this.type = "UnknownObject";
            this.exact = false;
        } else if (string == "Number") {
            this.type = "UnknownNumber";
            this.exact = false;
        } else {
            throw new DecompilerException(3835);
        }
    }

    public void resolveAsLocal() throws DecompilerException {
        this.exact = true;
        if (this.type == "UnknownObject") {
            this.type = "java/lang/Object";
        } else if (this.type == "UnknownNumber" || this.type.equals("byte") || this.type.equals("char") || this.type.equals("short")) {
            this.type = "int";
        } else if (this.type == "UnknownInt") {
            this.type = "boolean";
        }
    }

    public void setInvalid() {
        this.invalid = true;
    }

    public void setType(String string, boolean bl) {
        this.type = string;
        this.exact = bl;
    }

    public boolean type2() {
        return this.type == "long" || this.type == "double";
    }

    private void undeterminedInfo(String string) {
        this.type = "undeterminedZeroType";
    }
}

