/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.analyzer;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import org.apache.tools.analyzer.ExpandableArray;
import org.apache.tools.analyzer.HashedVector;
import org.apache.tools.analyzer.Sym;
import org.apache.tools.analyzer.UniqueVector;
import org.apache.tools.analyzer.info.ClassInfo;

public class AnalyzerUtilities {
    public static final String[] basicTypes = new String[]{"byte", "boolean", "float", "double", "int", "char", "long", "short", "void"};
    private static String dotString = "...";
    public static char systemFileSeparator = System.getProperty("file.separator").charAt(0);
    public static char javaSeparator = (char)47;
    public static char nameAndExtensionSeparator = (char)46;
    public static String unitTab = "     ";
    public static int BITS16 = 65535;
    private static int END = 3;
    private static int BEGINNING = 5;
    public static int initialBlockLimitx = 30;
    public static boolean debug = false;
    private static final int bufferSize = 5000;
    private static byte[] outputBuffer = new byte[5000];
    private static int outputCount;
    private static boolean special;
    private static Hashtable allNames;
    private static HashedVector units;

    static {
        special = false;
        allNames = null;
        units = null;
    }

    public static void alert(String string) {
        System.out.println("Alert: " + string);
    }

    private static String append(String string, char c) {
        char[] cArray = new char[]{c};
        return String.valueOf(string) + new String(cArray);
    }

    public static String classOnlyName(String string) {
        int n = string.lastIndexOf(javaSeparator);
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1, string.length());
    }

    private static int compare(char[] cArray, char[] cArray2, boolean bl) {
        int n = bl ? 32 : 0;
        int n2 = cArray.length < cArray2.length ? cArray.length : cArray2.length;
        int n3 = 0;
        while (n3 < n2) {
            if ((cArray[n3] | n) < (cArray2[n3] | n)) {
                return -1;
            }
            if ((cArray[n3] | n) > (cArray2[n3] | n)) {
                return 1;
            }
            ++n3;
        }
        if (cArray.length == cArray2.length) {
            if (!bl) {
                return 0;
            }
            return AnalyzerUtilities.compare(cArray, cArray2, false);
        }
        return cArray.length < cArray2.length ? -1 : 1;
    }

    private static String expandSymbol(Sym sym) {
        int n = sym.nBrackets;
        String string = sym.string;
        int n2 = 0;
        while (n2 < n) {
            string = String.valueOf(string) + "[]";
            ++n2;
        }
        return string;
    }

    public static UniqueVector extractTypes(String string) {
        String string2;
        String string3;
        UniqueVector uniqueVector = new UniqueVector();
        if (string.indexOf(40) < 0 && (string3 = AnalyzerUtilities.getFieldClassType(string2 = string.substring(string.indexOf(":") + 1, string.length()))) != null) {
            uniqueVector.addElement(string3);
        }
        return uniqueVector;
    }

    public static String fileExtension(String string) {
        return AnalyzerUtilities.part(string, END, nameAndExtensionSeparator, END);
    }

    private static char findSeparator(String string) {
        if (string == null) {
            return systemFileSeparator;
        }
        if (string.indexOf(javaSeparator) >= 0) {
            return javaSeparator;
        }
        return systemFileSeparator;
    }

    private static boolean flush(FileOutputStream fileOutputStream) {
        try {
            fileOutputStream.write(outputBuffer, 0, outputCount);
            outputCount = 0;
            return true;
        }
        catch (IOException iOException) {
            AnalyzerUtilities.alert("Error writing to save file");
            return false;
        }
    }

    public static String getBaseDirectory() {
        String string = System.getProperty("user.dir");
        return string;
    }

    public static String getFieldClassType(String string) {
        return AnalyzerUtilities.getFieldTypes(string, true);
    }

    public static String getFieldType(String string) {
        return AnalyzerUtilities.getFieldTypes(string, false);
    }

    private static String getFieldTypes(String string, boolean bl) {
        UniqueVector uniqueVector = new UniqueVector();
        boolean bl2 = AnalyzerUtilities.getUnencoded(string, uniqueVector);
        if (bl2) {
            AnalyzerUtilities.p("AnalyzerUtilities.getFieldClassType: invalid");
            return null;
        }
        Sym sym = (Sym)uniqueVector.elementAt(0);
        if (bl && !sym.isObject) {
            return null;
        }
        if (bl) {
            sym.nBrackets = 0;
        }
        String string2 = AnalyzerUtilities.expandSymbol(sym);
        return string2;
    }

    public static String getMethodParameterString(String string) {
        UniqueVector uniqueVector = new UniqueVector();
        boolean bl = AnalyzerUtilities.getUnencoded(string, uniqueVector);
        if (!bl) {
            AnalyzerUtilities.p("AnalyzerUtilities.getMethodParamString: invalid");
            return null;
        }
        String string2 = "(";
        int n = 0;
        while (n < uniqueVector.size() - 1) {
            if (n != 0) {
                string2 = String.valueOf(string2) + ", ";
            }
            string2 = String.valueOf(string2) + AnalyzerUtilities.expandSymbol((Sym)uniqueVector.elementAt(n));
            ++n;
        }
        string2 = String.valueOf(string2) + ")";
        return string2;
    }

    public static UniqueVector getMethodParameters(String string, UniqueVector uniqueVector) {
        UniqueVector uniqueVector2 = new UniqueVector();
        boolean bl = AnalyzerUtilities.getUnencoded(string, uniqueVector2);
        if (!bl) {
            AnalyzerUtilities.p("AnalyzerUtilities.getMethodParams: invalid");
            return null;
        }
        int n = 0;
        while (n < uniqueVector2.size() - 1) {
            uniqueVector.addElement(AnalyzerUtilities.expandSymbol((Sym)uniqueVector2.elementAt(n)));
            ++n;
        }
        return uniqueVector;
    }

    public static String getMethodType(String string) {
        return AnalyzerUtilities.getMethodTypes(string, false);
    }

    public static String getMethodTypes(String string, boolean bl) {
        UniqueVector uniqueVector = new UniqueVector();
        boolean bl2 = AnalyzerUtilities.getUnencoded(string, uniqueVector);
        if (!bl2) {
            AnalyzerUtilities.p("AnalyzerUtilities.getMethodClassType: invalid");
            return null;
        }
        Sym sym = (Sym)uniqueVector.elementAt(uniqueVector.size() - 1);
        if (bl) {
            if (!sym.isObject) {
                return null;
            }
            sym.nBrackets = 0;
        }
        String string2 = AnalyzerUtilities.expandSymbol(sym);
        return string2;
    }

    public static String getPackageName(String string) {
        int n = string.lastIndexOf("/");
        if (n < 0) {
            return null;
        }
        return string.substring(0, n + 1);
    }

    public static String getReferredClassType(String string) {
        UniqueVector uniqueVector = new UniqueVector();
        boolean bl = AnalyzerUtilities.getUnencoded(string, uniqueVector);
        if (uniqueVector.size() != 1 || bl) {
            AnalyzerUtilities.p("AnalyzerUtilities.getReferredClassType: invalid");
        }
        Sym sym = (Sym)uniqueVector.elementAt(0);
        if (!sym.isObject) {
            return null;
        }
        sym.nBrackets = 0;
        return AnalyzerUtilities.expandSymbol(sym);
    }

    public static String getSampleDirectory() {
        return String.valueOf(AnalyzerUtilities.getBaseDirectory()) + systemFileSeparator + "sample";
    }

    public static String getTab(String string) {
        String string2 = "";
        int n = 0;
        while (string.charAt(n++) == ' ') {
            string2 = String.valueOf(string2) + ' ';
        }
        return string2;
    }

    public static String getTempDirectory() {
        return String.valueOf(AnalyzerUtilities.getBaseDirectory()) + systemFileSeparator + "temp";
    }

    public static UniqueVector getTypeAndParamterReferencedClasses(String string) {
        UniqueVector uniqueVector = new UniqueVector();
        boolean bl = AnalyzerUtilities.getUnencoded(string, uniqueVector);
        if (!bl) {
            AnalyzerUtilities.p("AnalyzerUtilities.getTypeAndParameterRef...: invalid");
            return null;
        }
        UniqueVector uniqueVector2 = new UniqueVector();
        int n = 0;
        while (n < uniqueVector.size()) {
            Sym sym = (Sym)uniqueVector.elementAt(n);
            if (sym.isObject) {
                sym.nBrackets = 0;
                uniqueVector2.addElement(AnalyzerUtilities.expandSymbol(sym));
            }
            ++n;
        }
        return uniqueVector2;
    }

    private static boolean getUnencoded(String string, UniqueVector uniqueVector) {
        String string2 = "";
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (c == '(' || c == ')') {
                bl2 = true;
            } else if (c == ';') {
                bl = false;
                uniqueVector.addElement(new Sym(string2, n, true));
                string2 = "";
                n = 0;
            } else if (c == '[') {
                ++n;
            } else if (c == 'L' && !bl) {
                bl = true;
            } else if (bl) {
                string2 = AnalyzerUtilities.append(string2, c);
            } else {
                String string3;
                switch (c) {
                    case 'B': {
                        string3 = basicTypes[0];
                        break;
                    }
                    case 'Z': {
                        string3 = basicTypes[1];
                        break;
                    }
                    case 'F': {
                        string3 = basicTypes[2];
                        break;
                    }
                    case 'D': {
                        string3 = basicTypes[3];
                        break;
                    }
                    case 'I': {
                        string3 = basicTypes[4];
                        break;
                    }
                    case 'C': {
                        string3 = basicTypes[5];
                        break;
                    }
                    case 'J': {
                        string3 = basicTypes[6];
                        break;
                    }
                    case 'S': {
                        string3 = basicTypes[7];
                        break;
                    }
                    case 'V': {
                        string3 = basicTypes[8];
                        break;
                    }
                    default: {
                        string3 = "unknown_type";
                    }
                }
                uniqueVector.addElement(new Sym(string3, n, false));
                n = 0;
            }
            ++n2;
        }
        return bl2;
    }

    public static boolean isBasicType(String string) {
        int n = 0;
        while (n < basicTypes.length) {
            if (basicTypes[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean isClassName(String string) {
        if (allNames == null) {
            allNames = new Hashtable();
            int n = 0;
            while (n < units.size()) {
                String string2 = ((ClassInfo)units.get(n)).getClassOnlyDisplayName();
                allNames.put(string2, string2);
                ++n;
            }
        }
        return allNames.get(string) != null;
    }

    public static String makeFileNameFromJavaName(String string) {
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length(), cArray, 0);
        int n = 0;
        while (n < string.length()) {
            if (cArray[n] == javaSeparator) {
                cArray[n] = systemFileSeparator;
            }
            ++n;
        }
        return new String(cArray);
    }

    public static String makeFullName(String string, String string2) {
        if (string.charAt(string.length() - 1) == systemFileSeparator) {
            return String.valueOf(string) + string2;
        }
        return String.valueOf(string) + systemFileSeparator + string2;
    }

    public static String makeSourceNameFromJavaName(String string) {
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length(), cArray, 0);
        int n = 0;
        while (n < string.length()) {
            if (cArray[n] == javaSeparator) {
                cArray[n] = nameAndExtensionSeparator;
            }
            ++n;
        }
        return new String(cArray);
    }

    public static void mergeVectors(UniqueVector uniqueVector, UniqueVector uniqueVector2, UniqueVector uniqueVector3) {
        int n = 0;
        while (n < uniqueVector2.size()) {
            uniqueVector.addElement(uniqueVector2.elementAt(n));
            ++n;
        }
        int n2 = 0;
        while (n2 < uniqueVector3.size()) {
            uniqueVector.addElement(uniqueVector3.elementAt(n2));
            ++n2;
        }
    }

    public static void message(String string) {
        System.out.println("Message: " + string);
    }

    private static void moveLongToByteArray(long l, byte[] byArray, int n) {
        int n2 = 0;
        while (n2 < 4) {
            byArray[n + n2] = (byte)(l & 0xFFL);
            l >>= 8;
            ++n2;
        }
    }

    public static boolean nameCompatible(String string, String string2) {
        String string3;
        if (string == null || string2 == null) {
            return false;
        }
        if (string.length() < 1 || string2.length() < 1) {
            return false;
        }
        char c = AnalyzerUtilities.findSeparator(string);
        UniqueVector uniqueVector = AnalyzerUtilities.toArray(string, c);
        UniqueVector uniqueVector2 = AnalyzerUtilities.toArray(string2, javaSeparator);
        int n = uniqueVector.size();
        int n2 = uniqueVector2.size();
        if (n == 0 || n2 == 0) {
            return false;
        }
        String string4 = AnalyzerUtilities.removeExtension((String)uniqueVector.elementAt(n - 1));
        if (!string4.equals(string3 = (String)uniqueVector2.elementAt(n2 - 1))) {
            return false;
        }
        int n3 = 2;
        while (n2 >= n3) {
            if (n < n3) {
                return false;
            }
            string4 = (String)uniqueVector.elementAt(n - n3);
            if (!string4.equals(string3 = (String)uniqueVector2.elementAt(n2 - n3))) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    private static boolean outputByte(FileOutputStream fileOutputStream, int n) {
        AnalyzerUtilities.outputBuffer[AnalyzerUtilities.outputCount] = (byte)n;
        if (++outputCount == 5000) {
            return AnalyzerUtilities.flush(fileOutputStream);
        }
        return true;
    }

    public static void p(Object object) {
        System.out.println(object);
    }

    private static String part(String string, int n, char c, int n2) {
        if (string == null) {
            return "";
        }
        int n3 = string.lastIndexOf(c);
        if (n3 >= 0) {
            if (n == END) {
                return string.substring(n3 + 1, string.length());
            }
            return string.substring(0, n3);
        }
        if (n == END) {
            if (n2 == END) {
                return "";
            }
            return string;
        }
        if (n2 == END) {
            return string;
        }
        return "";
    }

    public static String removeExtension(String string) {
        return AnalyzerUtilities.part(string, BEGINNING, nameAndExtensionSeparator, END);
    }

    public static boolean serializeBooleanIn(InputStream inputStream) throws IOException {
        char c = (char)inputStream.read();
        return c == 'T';
    }

    public static void serializeBooleanOut(boolean bl, OutputStream outputStream) throws IOException {
        if (bl) {
            outputStream.write(84);
        } else {
            outputStream.write(70);
        }
    }

    public static int serializeIntIn(InputStream inputStream) throws IOException {
        int n = 0;
        int n2 = 0;
        while (n2 < 4) {
            int n3 = inputStream.read();
            n = (n << 8) + n3;
            ++n2;
        }
        return n;
    }

    public static void serializeIntOut(int n, OutputStream outputStream) throws IOException {
        int n2 = 0;
        while (n2 < 4) {
            int n3 = n >> (3 - n2) * 8 & 0xFF;
            outputStream.write(n3);
            ++n2;
        }
    }

    public static String serializeStringIn(InputStream inputStream) throws IOException {
        int n;
        ExpandableArray expandableArray = new ExpandableArray();
        while ((n = inputStream.read()) > 0) {
            expandableArray.add(n);
        }
        char[] cArray = new char[expandableArray.size()];
        int n2 = 0;
        while (n2 < expandableArray.size()) {
            cArray[n2] = (char)expandableArray.get(n2);
            ++n2;
        }
        return new String(cArray);
    }

    public static void serializeStringOut(String string, OutputStream outputStream) throws IOException {
        if (string == null) {
            string = "";
        }
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            outputStream.write(cArray[n]);
            ++n;
        }
        outputStream.write(0);
    }

    public static void setUnits(HashedVector hashedVector) {
        units = hashedVector;
    }

    public static UniqueVector[] sort(UniqueVector uniqueVector, UniqueVector uniqueVector2) {
        return AnalyzerUtilities.sortPlus(uniqueVector, uniqueVector2, false);
    }

    public static UniqueVector[] sortAndUnDup(UniqueVector uniqueVector, UniqueVector uniqueVector2) {
        return AnalyzerUtilities.sortPlus(uniqueVector, uniqueVector2, true);
    }

    private static UniqueVector[] sortPlus(UniqueVector uniqueVector, UniqueVector uniqueVector2, boolean bl) {
        int n;
        int n2;
        Object object;
        int n3 = uniqueVector.size();
        UniqueVector uniqueVector3 = new UniqueVector();
        UniqueVector uniqueVector4 = new UniqueVector();
        UniqueVector uniqueVector5 = new UniqueVector();
        int[] nArray = new int[n3];
        int n4 = 0;
        while (n4 < n3) {
            object = (String)uniqueVector.elementAt(n4);
            char[] cArray = new char[((String)object).length()];
            int n5 = 0;
            while (n5 < ((String)object).length()) {
                cArray[n5] = ((String)object).charAt(n5);
                ++n5;
            }
            n2 = 1;
            if (bl) {
                n = 0;
                while (n < uniqueVector3.size()) {
                    if (AnalyzerUtilities.compare(cArray, (char[])uniqueVector3.elementAt(n), true) == 0) {
                        n2 = 0;
                        break;
                    }
                    ++n;
                }
            }
            if (n2 != 0) {
                nArray[uniqueVector3.size()] = n4;
                uniqueVector3.addElement(cArray);
            }
            ++n4;
        }
        n3 = uniqueVector3.size();
        object = new boolean[n3];
        int n6 = 0;
        while (n6 < n3) {
            object[n6] = true;
            ++n6;
        }
        char[] cArray = null;
        n2 = -1;
        int n7 = 0;
        while (n7 < n3) {
            n = 1;
            int n8 = 0;
            while (n8 < n3) {
                if (object[n8] != false) {
                    char[] cArray2 = (char[])uniqueVector3.elementAt(n8);
                    if (n != 0) {
                        cArray = cArray2;
                        n2 = n8;
                        n = 0;
                    }
                    if (AnalyzerUtilities.compare(cArray2, cArray, true) < 0) {
                        n2 = n8;
                        cArray = cArray2;
                    }
                }
                ++n8;
            }
            if (n2 < 0) {
                System.out.println("Sort error");
            }
            uniqueVector4.addElement(uniqueVector.elementAt(nArray[n2]));
            if (uniqueVector2 != null) {
                uniqueVector5.addElement(uniqueVector2.elementAt(nArray[n2]));
            }
            object[n2] = false;
            ++n7;
        }
        UniqueVector[] uniqueVectorArray = new UniqueVector[]{uniqueVector4, uniqueVector5};
        return uniqueVectorArray;
    }

    public static UniqueVector toArray(String string, char c) {
        UniqueVector uniqueVector = new UniqueVector();
        while (true) {
            int n;
            if ((n = string.indexOf(c)) < 0) {
                if (!string.equals("")) {
                    uniqueVector.addElement(string);
                }
                return uniqueVector;
            }
            uniqueVector.addElement(string.substring(0, n));
            string = string.substring(n + 1, string.length());
        }
    }

    public static boolean twoChoiceBox(String string) {
        if (special) {
            return true;
        }
        AnalyzerUtilities.alert(string);
        return true;
    }
}

