/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.analyzer;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ClassFileInputStream {
    private DataInputStream stream;

    public boolean close() {
        try {
            this.stream.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public Double getDouble() throws IOException {
        return new Double(this.stream.readDouble());
    }

    public Float getFloat() throws IOException {
        return new Float(this.stream.readFloat());
    }

    public int getInt(int n) throws IOException {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 = (n2 << 8) + this.next();
            ++n3;
        }
        return n2;
    }

    public int getInt2() throws IOException {
        return this.getInt(2);
    }

    public Long getLong(int n) throws IOException {
        return new Long(this.stream.readLong());
    }

    public static ClassFileInputStream getMyDataInputStream(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        ClassFileInputStream classFileInputStream = new ClassFileInputStream();
        classFileInputStream.stream = new DataInputStream(inputStream);
        return classFileInputStream;
    }

    public int next() throws IOException {
        int n = this.readByte();
        if (n < 0) {
            n += 256;
        }
        return n;
    }

    public byte readByte() throws IOException {
        return this.stream.readByte();
    }

    public int readBytesx(byte[] byArray) throws IOException {
        return this.stream.read(byArray);
    }

    public String readUTF() throws IOException {
        String string = this.stream.readUTF();
        return string;
    }
}

