/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.analyzer;

import org.apache.tools.analyzer.DecompilerLibrary;
import org.apache.tools.analyzer.ExpandableArray;
import org.apache.tools.analyzer.OpcData;
import org.apache.tools.analyzer.info.MethodInfo;

public class Decoder {
    private ExpandableArray interactions;

    public ExpandableArray decode(byte[] byArray, int n, boolean bl) {
        this.interactions = new ExpandableArray();
        int n2 = 0;
        int n3 = -1;
        while (n2 < n) {
            int n4 = byArray[n2];
            if (n4 < 0) {
                n4 += 256;
            }
            if (n4 >= OpcData.opcLengths.length) {
                DecompilerLibrary.handleBadInstruction(byArray, n, n2, n4);
                return null;
            }
            switch (n4) {
                case 171: {
                    n2 = DecompilerLibrary.handle171(byArray, n2, null);
                    break;
                }
                case 170: {
                    n2 = DecompilerLibrary.handle170(byArray, n2, null);
                    break;
                }
                case 178: 
                case 180: {
                    n2 = this.handleFieldRead(byArray, n2, n4, true);
                    break;
                }
                case 179: 
                case 181: {
                    n2 = this.handleFieldWrite(byArray, n2, n4, true);
                    break;
                }
                case 182: 
                case 183: 
                case 184: 
                case 185: {
                    n2 = this.handleMethodCall(byArray, n2, n4, true);
                    break;
                }
                case 187: {
                    n2 = this.handleClassCreate(byArray, n2, n4, true);
                    break;
                }
                default: {
                    if (n3 == 196) {
                        n2 = n4 == 132 ? (n2 += 2) : ++n2;
                    }
                    n2 += OpcData.opcLengths[n4];
                }
            }
            n3 = n4;
        }
        return this.interactions;
    }

    private int handleClassCreate(byte[] byArray, int n, int n2, boolean bl) {
        ++n;
        if (bl) {
            this.interactions.add((MethodInfo.CREATE << 16) + DecompilerLibrary.getTwoByte(byArray, n));
        }
        return n += 2;
    }

    private int handleFieldRead(byte[] byArray, int n, int n2, boolean bl) {
        ++n;
        if (bl) {
            this.interactions.add((MethodInfo.READ << 16) + DecompilerLibrary.getTwoByte(byArray, n));
        }
        return n += 2;
    }

    private int handleFieldWrite(byte[] byArray, int n, int n2, boolean bl) {
        ++n;
        if (bl) {
            this.interactions.add((MethodInfo.WRITE << 16) + DecompilerLibrary.getTwoByte(byArray, n));
        }
        return n += 2;
    }

    private int handleMethodCall(byte[] byArray, int n, int n2, boolean bl) {
        int n3 = DecompilerLibrary.getTwoByte(byArray, ++n);
        if (bl) {
            if (n2 == 182) {
                this.interactions.add((MethodInfo.VIRTUAL << 16) + n3);
            } else if (n2 == 185) {
                this.interactions.add((MethodInfo.INTERFACE << 16) + n3);
            } else {
                this.interactions.add((MethodInfo.DIRECT << 16) + n3);
            }
        }
        n += 2;
        if (n2 == 185) {
            n += 2;
        }
        return n;
    }
}

