/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.analyzer;

import java.util.Stack;
import org.apache.tools.analyzer.AnalyzerUtilities;
import org.apache.tools.analyzer.CatchInfo;
import org.apache.tools.analyzer.CodeBlock;
import org.apache.tools.analyzer.CodeBlockAnalyzer;
import org.apache.tools.analyzer.DecompilerException;
import org.apache.tools.analyzer.DecompilerLibrary;
import org.apache.tools.analyzer.ExpandableArray;
import org.apache.tools.analyzer.IStatusListener;
import org.apache.tools.analyzer.Instruction;
import org.apache.tools.analyzer.LocalDescriptor;
import org.apache.tools.analyzer.LocalVariableTable;
import org.apache.tools.analyzer.NameMgr;
import org.apache.tools.analyzer.OpcData;
import org.apache.tools.analyzer.Operand;
import org.apache.tools.analyzer.ProgramElement;
import org.apache.tools.analyzer.StackEvaluator;
import org.apache.tools.analyzer.Type;
import org.apache.tools.analyzer.UniqueVector;
import org.apache.tools.analyzer.info.ClassInfo;
import org.apache.tools.analyzer.info.FieldInfo;
import org.apache.tools.analyzer.info.LocalVariableInfo;
import org.apache.tools.analyzer.info.MethodInfo;
import org.apache.tools.analyzer.structures.MACodeEntry;
import org.apache.tools.analyzer.structures.MACodeHandlerEntry;
import org.apache.tools.analyzer.structures.MAExceptionEntry;
import org.apache.tools.analyzer.structures.Pair;
import org.apache.tools.analyzer.structures.Parameter;
import org.apache.tools.analyzer.structures.SymbolInit;
import org.apache.tools.analyzer.structures.TryEntry;

public class Decompiler {
    private static boolean showName = false;
    public static boolean listDebug = false;
    private static boolean debugTime = false;
    private static boolean alertMsg = false;
    private static UniqueVector instructionList;
    private static Instruction startInstruction;
    private static UniqueVector codeIslandStartInstructions;
    private static ExpandableArray finallyTargets;
    private static UniqueVector tryEntrys;
    private static CodeBlock methodBlock;
    private static ClassInfo info;
    private static MethodInfo methodInformation;
    private static MACodeHandlerEntry[] handlers;
    private static byte[] code;
    private static int length;
    private static int[] lookup;
    private static Parameter[] parLocalArray;
    public static final boolean debug = false;
    public static final boolean testing = false;
    private static long startTime;
    private static long currTime;
    private static String methodType;
    private static boolean p4;
    private static UniqueVector catchInfoVector;
    public static int labelNumber;
    private static boolean branchValue;
    public static UniqueVector messages;
    private static int catchNumber;
    public static boolean someSynchs;
    private static UniqueVector initSymbols;
    private static boolean showBytes;
    private static IStatusListener statusListener;

    static {
        p4 = false;
        showBytes = false;
        startTime = 0L;
    }

    private static CodeBlock addSegment(Instruction instruction, Instruction instruction2, CodeBlock codeBlock) {
        CodeBlock codeBlock2 = null;
        Instruction instruction3 = instruction;
        while (true) {
            Instruction instruction4;
            if ((instruction4 = instruction3.theNextInstruction()) == null || instruction4.targetCount > 1 || Decompiler.handlerBreak(instruction3, instruction4)) {
                CodeBlock codeBlock3 = new CodeBlock(instruction, instruction3, "SIMPLEOTHER", codeBlock);
                codeBlock.addSubBlock(codeBlock3);
                if (codeBlock2 == null) {
                    codeBlock2 = codeBlock3;
                }
                int n = 0;
                while (n < instruction3.nextInstructionList.size()) {
                    Instruction instruction5 = (Instruction)instruction3.nextInstructionList.elementAt(n);
                    if (!codeBlock.containsDirectly(instruction5.enclosingCodeBlock)) {
                        Decompiler.addSegment(instruction5, instruction2, codeBlock);
                    }
                    ++n;
                }
                return codeBlock2;
            }
            instruction3 = instruction4;
        }
    }

    private static void buildCodeIslands() throws DecompilerException {
        codeIslandStartInstructions = new UniqueVector();
        int n = 0;
        while (n < instructionList.size()) {
            Instruction instruction = (Instruction)instructionList.elementAt(n);
            if (!instruction.equals(startInstruction) && instruction.targetCount == 0 && instruction.type != "UNCONDBRANCH") {
                instruction = Decompiler.findFinalTarget(instruction);
                codeIslandStartInstructions.addElement(instruction);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < finallyTargets.size()) {
            boolean bl = false;
            int n3 = finallyTargets.get(n2);
            int n4 = 0;
            while (n4 < codeIslandStartInstructions.size()) {
                if (n3 == ((Instruction)Decompiler.codeIslandStartInstructions.elementAt((int)n4)).location) {
                    bl = true;
                    break;
                }
                ++n4;
            }
            if (!bl) {
                Decompiler.report("Finally target not found in code");
            }
            ++n2;
        }
    }

    private static UniqueVector buildInstructionList(byte[] byArray, int n) {
        int n2 = 0;
        int n3 = -1;
        instructionList = new UniqueVector();
        while (n2 < n) {
            int n4 = byArray[n2];
            if (n4 < 0) {
                n4 += 256;
            }
            if (n4 >= OpcData.opcLengths.length) {
                DecompilerLibrary.handleBadInstruction(byArray, n, n2, n4);
                return null;
            }
            switch (n4) {
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 198: 
                case 199: {
                    int n5 = n2++;
                    int n6 = DecompilerLibrary.getTwoByteSigned(byArray, n2);
                    instructionList.addElement(new Instruction(n5, n4, "CONDBRANCH", n6 + n2 - 1, false));
                    n2 += 2;
                    break;
                }
                case 167: 
                case 200: {
                    int n5 = n2++;
                    int n6 = n4 == 167 ? DecompilerLibrary.getTwoByteSigned(byArray, n2) : DecompilerLibrary.getFourByteSigned(byArray, n2);
                    instructionList.addElement(new Instruction(n5, n4, "UNCONDBRANCH", n6 + n2 - 1, false));
                    if (n4 == 167) {
                        n2 += 2;
                        break;
                    }
                    n2 += 4;
                    break;
                }
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: {
                    instructionList.addElement(new Instruction(n2, n4, "RETURNORTHROW", -1, n3 == 196));
                    n2 += OpcData.opcLengths[n4];
                    break;
                }
                case 169: 
                case 191: {
                    instructionList.addElement(new Instruction(n2, n4, "RETURNORTHROW", -1, n3 == 196));
                    n2 += OpcData.opcLengths[n4];
                    break;
                }
                case 171: {
                    int n7 = n2;
                    UniqueVector uniqueVector = new UniqueVector();
                    n2 = DecompilerLibrary.handle171(byArray, n2, uniqueVector);
                    int n8 = 0;
                    while (n8 < uniqueVector.size()) {
                        Pair pair = (Pair)uniqueVector.elementAt(n8);
                        pair.y += n7;
                        ++n8;
                    }
                    instructionList.addElement(new Instruction(n7, n4, "MULTIBRANCH", uniqueVector, n3 == 196));
                    break;
                }
                case 170: {
                    Object object;
                    int n7 = n2;
                    UniqueVector uniqueVector = new UniqueVector();
                    n2 = DecompilerLibrary.handle170(byArray, n2, uniqueVector);
                    int n8 = 0;
                    int n9 = 0;
                    while (n9 < uniqueVector.size()) {
                        object = (Pair)uniqueVector.elementAt(n9);
                        if (((Pair)object).y <= 0) {
                            n8 = 1;
                        }
                        ((Pair)object).y += n7;
                        ++n9;
                    }
                    if (p4 && n8 != 0) {
                        instructionList.addElement(new Instruction(n7, n4, "UNCONDBRANCH", ((Pair)uniqueVector.elementAt((int)(uniqueVector.size() - 1))).y, n3 == 196));
                        AnalyzerUtilities.p(" *** replacing faked multibranch");
                        break;
                    }
                    instructionList.addElement(new Instruction(n7, n4, "MULTIBRANCH", uniqueVector, n3 == 196));
                    break;
                }
                case 178: 
                case 180: {
                    instructionList.addElement(new Instruction(n2, n4, "NONBRANCH", -1, n3 == 196));
                    n2 += 3;
                    break;
                }
                case 179: 
                case 181: {
                    instructionList.addElement(new Instruction(n2, n4, "NONBRANCH", -1, n3 == 196));
                    n2 += 3;
                    break;
                }
                case 182: 
                case 183: 
                case 184: 
                case 185: {
                    instructionList.addElement(new Instruction(n2, n4, "NONBRANCH", -1, n3 == 196));
                    n2 += 3;
                    if (n4 != 185) break;
                    n2 += 2;
                    break;
                }
                case 187: {
                    instructionList.addElement(new Instruction(n2, n4, "NONBRANCH", -1, n3 == 196));
                    n2 += 3;
                    break;
                }
                case 168: 
                case 201: {
                    int n5 = n2++;
                    int n6 = n4 == 168 ? DecompilerLibrary.getTwoByteSigned(byArray, n2) : DecompilerLibrary.getFourByteSigned(byArray, n2);
                    int n10 = n6 + n2 - 1;
                    if (!finallyTargets.contains(n10)) {
                        finallyTargets.add(n10);
                    }
                    Object object = new Instruction(n5, n4, "JSR", n10, n3 == 196);
                    instructionList.addElement(object);
                    if (n4 == 168) {
                        n2 += 2;
                        break;
                    }
                    n2 += 4;
                    break;
                }
                default: {
                    if (n4 != 196) {
                        instructionList.addElement(new Instruction(n2, n4, "NONBRANCH", -1, n3 == 196));
                    }
                    if (n3 == 196) {
                        n2 = n4 == 132 ? (n2 += 2) : ++n2;
                    }
                    n2 += OpcData.opcLengths[n4];
                }
            }
            n3 = n4;
        }
        return instructionList;
    }

    private static void buildInstructionNetwork() throws DecompilerException {
        if (Decompiler.buildInstructionList(code, length) == null) {
            return;
        }
        Decompiler.buildLookupList(instructionList, length);
        startInstruction = Decompiler.findFinalTarget((Instruction)instructionList.elementAt(0));
        if (Decompiler.startInstruction.type == "INFINITELOOP") {
            throw new DecompilerException("Start instruction loops indefinitely");
        }
        Decompiler.connectInstructions();
        int n = 0;
        while (n < instructionList.size()) {
            Instruction instruction = (Instruction)instructionList.elementAt(n);
            int n2 = instruction.nextInstructionList.size();
            int n3 = 0;
            while (n3 < n2) {
                ++((Instruction)instruction.nextInstructionList.elementAt((int)n3)).targetCount;
                ++n3;
            }
            ++n;
        }
        Decompiler.buildCodeIslands();
        ++Decompiler.startInstruction.targetCount;
        int n4 = 0;
        while (n4 < codeIslandStartInstructions.size()) {
            ++((Instruction)Decompiler.codeIslandStartInstructions.elementAt((int)n4)).targetCount;
            ++n4;
        }
    }

    private static void buildLookupList(UniqueVector uniqueVector, int n) {
        lookup = new int[n];
        int n2 = 0;
        while (n2 < uniqueVector.size()) {
            Instruction instruction = (Instruction)uniqueVector.elementAt(n2);
            Decompiler.lookup[instruction.location] = n2++;
        }
    }

    private static void buildPass(boolean bl) throws DecompilerException {
        LocalVariableInfo.initialize(methodInformation, parLocalArray);
        LocalDescriptor.initialize();
        Decompiler.setInstructionsUnProcessed();
        Decompiler.makeOperandsAndLocals(startInstruction, new Stack(), new LocalVariableTable(), bl);
        UniqueVector uniqueVector = new UniqueVector();
        int n = 0;
        while (n < codeIslandStartInstructions.size()) {
            Instruction instruction = (Instruction)codeIslandStartInstructions.elementAt(n);
            uniqueVector.addElement(instruction);
            ++n;
        }
        boolean bl2 = false;
        int n2 = 0;
        int n3 = 0;
        while (n3 < catchInfoVector.size()) {
            CatchInfo catchInfo = (CatchInfo)catchInfoVector.elementAt(n3);
            catchInfo.processed = false;
            ++n3;
        }
        int n4 = 0;
        while (n4 < tryEntrys.size()) {
            TryEntry tryEntry = (TryEntry)tryEntrys.elementAt(n4);
            tryEntry.finallyProcessed = false;
            ++n4;
        }
        while (!bl2) {
            bl2 = true;
            if (!Decompiler.makePossibleCatches(uniqueVector, bl)) {
                bl2 = false;
            }
            if (!Decompiler.makePossibleFinallys(uniqueVector, bl)) {
                bl2 = false;
            }
            if (n2++ <= 100) continue;
            throw new DecompilerException(1203);
        }
    }

    private static void buildStackAndLocalInfo() throws DecompilerException {
        Decompiler.buildPass(true);
        Decompiler.markUnusedStatementsNever();
        Decompiler.checkAllForVariantStack();
        Decompiler.markAllMultiplyAccessedOps();
        Decompiler.buildPass(false);
        Decompiler.markUnusedStatementsNever();
        Decompiler.debugCheckAllForVariantStack();
        Decompiler.integrateAllLocals();
        Decompiler.debugMarkAllMultiplyAccessedOps();
        LocalDescriptor.resolveAllLocals();
    }

    private static void buildTryBlocks(MACodeHandlerEntry[] mACodeHandlerEntryArray) throws DecompilerException {
        int n;
        int n2;
        int n3;
        tryEntrys = new UniqueVector();
        int n4 = 0;
        while (n4 < mACodeHandlerEntryArray.length) {
            MACodeHandlerEntry mACodeHandlerEntry = mACodeHandlerEntryArray[n4];
            int n5 = ((Instruction)Decompiler.instructionList.elementAt((int)(Decompiler.instructionList.size() - 1))).location;
            if (mACodeHandlerEntry.startPC >= 0 && mACodeHandlerEntry.startPC <= n5 && mACodeHandlerEntry.inactivePC >= 0 && mACodeHandlerEntry.inactivePC <= n5 && mACodeHandlerEntry.handlerPC >= 0 && mACodeHandlerEntry.handlerPC < n5) {
                Object object;
                n3 = 0;
                n2 = 0;
                while (n2 < tryEntrys.size()) {
                    object = (TryEntry)tryEntrys.elementAt(n2);
                    n = Decompiler.overlap(mACodeHandlerEntry.startPC, mACodeHandlerEntry.inactivePC, ((TryEntry)object).startPC, ((TryEntry)object).inactivePC);
                    if (n == 1) {
                        Decompiler.report("Overlapping try blocks");
                        n3 = 1;
                        break;
                    }
                    if (n == 2) {
                        ((TryEntry)object).addCatchType(info.getConstantName(mACodeHandlerEntry.catchTypeIndex));
                        ((TryEntry)object).handlerInstructions.add(mACodeHandlerEntry.handlerPC);
                        n3 = 1;
                    }
                    ++n2;
                }
                if (n3 == 0) {
                    object = mACodeHandlerEntry.catchTypeIndex == 0 ? "nullCatchType" : info.getConstantName(mACodeHandlerEntry.catchTypeIndex);
                    TryEntry tryEntry = new TryEntry(mACodeHandlerEntry.startPC, mACodeHandlerEntry.inactivePC, mACodeHandlerEntry.handlerPC, (String)object);
                    tryEntry.firstInstruction = Decompiler.findFinalTarget(Decompiler.findInstructionByLocation(mACodeHandlerEntry.startPC, instructionList));
                    tryEntry.firstHandlerFirstInstruction = Decompiler.findFinalTarget(Decompiler.findInstructionByLocation(mACodeHandlerEntry.handlerPC, instructionList));
                    tryEntrys.addElement(tryEntry);
                }
            }
            ++n4;
        }
        int n6 = 0;
        while (n6 < tryEntrys.size()) {
            TryEntry tryEntry = (TryEntry)tryEntrys.elementAt(n6);
            if (tryEntry.catchTypes.size() == 1 && tryEntry.catchTypes.elementAt(0) == "nullCatchType") {
                tryEntry.mayBeWrapper = true;
            }
            ++n6;
        }
        UniqueVector uniqueVector = new UniqueVector();
        while (true) {
            n3 = 9999999;
            n2 = -1;
            if (tryEntrys.size() < 1) break;
            int n7 = 0;
            while (n7 < tryEntrys.size()) {
                TryEntry tryEntry = (TryEntry)tryEntrys.elementAt(n7);
                if (tryEntry.size < n3) {
                    n2 = n7;
                    n3 = tryEntry.size;
                }
                ++n7;
            }
            if (n2 < 0) {
                throw new DecompilerException(8283);
            }
            uniqueVector.addElement(tryEntrys.elementAt(n2));
            tryEntrys.removeElementAt(n2);
        }
        tryEntrys = uniqueVector;
        n3 = 0;
        while (n3 < tryEntrys.size()) {
            TryEntry tryEntry = (TryEntry)tryEntrys.elementAt(n3);
            if (tryEntry.mayBeWrapper) {
                int n8 = Decompiler.jsrInSecond(tryEntry.firstHandlerFirstInstruction);
                if (n8 > 0) {
                    tryEntry.finallyStart = n8;
                }
                if (Decompiler.monitorExitInSecond(tryEntry.firstHandlerFirstInstruction)) {
                    tryEntry.synch = true;
                    someSynchs = true;
                }
            }
            ++n3;
        }
        catchInfoVector = new UniqueVector();
        int n9 = 0;
        while (n9 < tryEntrys.size()) {
            TryEntry tryEntry = (TryEntry)tryEntrys.elementAt(n9);
            n = 0;
            while (n < tryEntry.handlerInstructions.size()) {
                Instruction instruction = Decompiler.findFinalTarget(Decompiler.findInstructionByLocation(tryEntry.handlerInstructions.get(n), instructionList));
                String string = (String)tryEntry.catchTypes.elementAt(n);
                Instruction instruction2 = Decompiler.findFinalTarget(Decompiler.findInstructionByLocation(tryEntry.startPC, instructionList));
                Instruction instruction3 = Decompiler.findFinalTarget(Decompiler.findInstructionByLocation(instruction.location, instructionList));
                CatchInfo catchInfo = new CatchInfo(instruction.location, instruction3, string, instruction2, catchNumber++);
                catchInfoVector.addElement(catchInfo);
                ++n;
            }
            ++n9;
        }
    }

    private static Stack catchStack(String string, int n) throws DecompilerException {
        Operand operand = new Operand("CATCHPARAMETER", new Integer(n), null, null, new Type(string), null, null);
        Stack<Operand> stack = new Stack<Operand>();
        stack.push(operand);
        return stack;
    }

    private static void checkAllForVariantStack() throws DecompilerException {
        int n = 0;
        while (n < instructionList.size()) {
            Instruction instruction = (Instruction)instructionList.elementAt(n);
            if (instruction.processed && instruction.referringInstructionList.size() > 1) {
                Decompiler.checkVariantStack(instruction);
            }
            ++n;
        }
    }

    private static void checkVariantStack(Instruction instruction) throws DecompilerException {
        int n = 0;
        while (n < instruction.referringInstructionList.size()) {
            Instruction instruction2 = (Instruction)instruction.referringInstructionList.elementAt(n);
            if (instruction2.outStack != null && instruction.inStack.size() != instruction2.outStack.size()) {
                Decompiler.report("Invalid stack sizes");
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < instruction.inStack.size()) {
            UniqueVector uniqueVector = instruction.referringInstructionList;
            int n3 = 0;
            while (n3 < uniqueVector.size()) {
                Operand operand;
                Operand operand2;
                Instruction instruction3 = (Instruction)uniqueVector.elementAt(n3);
                if (instruction3.outStack != null && !(operand2 = (Operand)instruction.inStack.get(n2)).equals(operand = (Operand)instruction3.outStack.get(n2))) {
                    int n4 = 0;
                    while (n4 < uniqueVector.size()) {
                        Instruction instruction4 = (Instruction)uniqueVector.elementAt(n4);
                        Stack stack = instruction4.outStack;
                        Operand operand3 = (Operand)stack.get(n2);
                        if (operand3.genInstruction.saveLabel >= 0) {
                            AnalyzerUtilities.p("marking twice at " + operand3.genInstruction.location);
                        }
                        operand3.genInstruction.saveLabel = 3000000 + instruction.location;
                        ++n4;
                    }
                    break;
                }
                ++n3;
            }
            ++n2;
        }
    }

    public static boolean classHasMethod(String string) {
        return info.haveMethodOfName(string);
    }

    private static void connectInstructions() throws DecompilerException {
        int n = 0;
        while (n < instructionList.size()) {
            Instruction instruction = (Instruction)instructionList.elementAt(n);
            Instruction instruction2 = n < instructionList.size() - 1 ? (Instruction)instructionList.elementAt(n + 1) : null;
            if (instruction.type != "UNCONDBRANCH" && instruction.type != "RETURNORTHROW" && instruction.type != "INFINITELOOP") {
                Instruction instruction3;
                if (instruction.type == "NONBRANCH" || instruction.type == "JSR") {
                    if (instruction2 != null) {
                        instruction3 = Decompiler.findFinalTarget(instruction2);
                        instruction.addNextInstruction(instruction3, 101);
                        instruction3.addReferringInstruction(instruction);
                    }
                } else if (instruction.type == "CONDBRANCH") {
                    if (instruction2 != null) {
                        instruction3 = Decompiler.findFinalTarget(instruction2);
                        instruction.addNextInstruction(instruction3, 102);
                        instruction3.addReferringInstruction(instruction);
                    } else {
                        Decompiler.report("Branch points to non-existent instruction");
                    }
                    instruction3 = Decompiler.findFinalTarget(Decompiler.findInstructionByLocation(instruction.getTarget(), instructionList));
                    instruction.addNextInstruction(instruction3, 101);
                    instruction3.addReferringInstruction(instruction);
                    if (instruction.nextInstructionList.size() == 1) {
                        instruction.type = "NONBRANCH";
                    }
                } else if (instruction.type == "MULTIBRANCH") {
                    UniqueVector uniqueVector = instruction.multiTargets;
                    int n2 = 0;
                    while (n2 < uniqueVector.size()) {
                        Pair pair = (Pair)uniqueVector.elementAt(n2);
                        instruction3 = Decompiler.findFinalTarget(Decompiler.findInstructionByLocation(pair.y, instructionList));
                        instruction.addNextInstruction(instruction3, pair.x);
                        instruction3.addReferringInstruction(instruction);
                        ++n2;
                    }
                } else {
                    throw new DecompilerException(8285);
                }
            }
            ++n;
        }
    }

    private static void convertStaticInit(UniqueVector uniqueVector) {
        int n = 0;
        while (n < uniqueVector.size()) {
            int n2;
            int n3;
            String string = (String)uniqueVector.elementAt(n);
            if (string.indexOf("{") < 0 && string.indexOf("}") < 0 && (n3 = (string = string.substring(n2 = AnalyzerUtilities.getTab(string).length(), string.length())).indexOf("=")) >= 0) {
                int n4 = string.indexOf("[");
                int n5 = string.indexOf("]");
                String string2 = string.substring(0, n3 - 1);
                String string3 = null;
                if (n4 >= 0) {
                    string2 = string.substring(0, n4);
                    string3 = string.substring(n4 + 1, n5);
                }
                int n6 = string.indexOf(";");
                String string4 = string.substring(n3 + 2, string.length() - 1);
                initSymbols.addElement(new SymbolInit(string2, string3, string4));
            }
            ++n;
        }
    }

    private static void debug() throws DecompilerException {
        UniqueVector uniqueVector = new UniqueVector();
        Decompiler.dumpTrys(Decompiler.methodInformation.getCodeEntry().handlers, uniqueVector);
        int n = 0;
        while (n < uniqueVector.size()) {
            AnalyzerUtilities.p(uniqueVector.elementAt(n));
            ++n;
        }
        Decompiler.printInstructions(instructionList, "");
        methodBlock.print(true);
    }

    private static void debugCheckAllForVariantStack() throws DecompilerException {
    }

    private static void debugCheckVariantStack(Instruction instruction) throws DecompilerException {
    }

    private static void debugMarkAllMultiplyAccessedOps() throws DecompilerException {
    }

    private static String defaultForType(String string) {
        if ((string = ProgramElement.removeBrackets(string)).equals("float")) {
            return "0.0f";
        }
        if (string.equals("long")) {
            return "0L";
        }
        if (string.equals("double")) {
            return "0.0";
        }
        if (string.equals("boolean")) {
            return "false";
        }
        if (string.equals("int")) {
            return "0";
        }
        if (string.equals("short")) {
            return "0";
        }
        if (string.equals("byte")) {
            return "0";
        }
        if (string.equals("char")) {
            return "'\\000'";
        }
        return "null";
    }

    private static void dumpTrys(MACodeHandlerEntry[] mACodeHandlerEntryArray, UniqueVector uniqueVector) throws DecompilerException {
        int n = 0;
        while (n < mACodeHandlerEntryArray.length) {
            MACodeHandlerEntry mACodeHandlerEntry = mACodeHandlerEntryArray[n];
            uniqueVector.addElement("// Try: start: " + mACodeHandlerEntry.startPC + " stop: " + mACodeHandlerEntry.inactivePC + " handler start: " + mACodeHandlerEntry.handlerPC + " type: " + info.getConstantName(mACodeHandlerEntry.catchTypeIndex));
            ++n;
        }
    }

    private static Stack finallyStack() throws DecompilerException {
        Operand operand = new Operand("subroutineReturnAddress", null, null, null, new Type(2, "Object"), null, null);
        Stack<Operand> stack = new Stack<Operand>();
        stack.push(operand);
        return stack;
    }

    private static String findArraySymbol(String string, String string2) {
        int n;
        Object object;
        int n2;
        String[] stringArray;
        int n3 = 0;
        int n4 = 0;
        while (n4 < initSymbols.size()) {
            stringArray = (String[])initSymbols.elementAt(n4);
            if (stringArray.symbol.equals(string) && stringArray.index != null) {
                try {
                    n2 = new Integer(stringArray.index);
                    if (n2 > n3) {
                        n3 = n2;
                    }
                }
                catch (Exception exception) {
                    return "";
                }
            }
            ++n4;
        }
        if (n3 == 0) {
            return "";
        }
        stringArray = new String[n3 + 1];
        n2 = 0;
        while (n2 < n3 + 1) {
            stringArray[n2] = string2;
            ++n2;
        }
        int n5 = 0;
        while (n5 < initSymbols.size()) {
            object = (SymbolInit)initSymbols.elementAt(n5);
            if (((SymbolInit)object).symbol.equals(string) && ((SymbolInit)object).index != null) {
                try {
                    n = new Integer(((SymbolInit)object).index);
                    stringArray[n] = ((SymbolInit)object).value;
                }
                catch (Exception exception) {
                    return "";
                }
            }
            ++n5;
        }
        object = "{ ";
        n = 0;
        while (n < n3 + 1) {
            object = n == n3 ? String.valueOf(object) + stringArray[n] + " }" : String.valueOf(object) + stringArray[n] + ", ";
            ++n;
        }
        return object;
    }

    private static Instruction findFinalTarget(Instruction instruction) throws DecompilerException {
        ExpandableArray expandableArray = new ExpandableArray();
        while (instruction.type == "UNCONDBRANCH") {
            if (expandableArray.contains(instruction.location) || expandableArray.size() > 100) {
                int n = expandableArray.get(0);
                return new Instruction(n, 999, "INFINITELOOP", -1, false);
            }
            expandableArray.add(instruction.location);
            instruction = Decompiler.findInstructionByLocation(instruction.getTarget(), instructionList);
        }
        return instruction;
    }

    public static String findInitSymbol(FieldInfo fieldInfo) {
        String string = fieldInfo.getFieldOnlyName();
        String string2 = Decompiler.defaultForType(NameMgr.useConvert(fieldInfo.myTypeName(), 1));
        int n = 0;
        while (n < initSymbols.size()) {
            SymbolInit symbolInit = (SymbolInit)initSymbols.elementAt(n);
            if (symbolInit.symbol.equals(string)) {
                String string3 = Decompiler.findArraySymbol(symbolInit.value, string2);
                if (!string3.equals("")) {
                    return string3;
                }
                return symbolInit.value;
            }
            ++n;
        }
        return null;
    }

    public static Instruction findInstruction(int n, UniqueVector uniqueVector) throws DecompilerException {
        return Decompiler.findInstructionByLocation(n, uniqueVector);
    }

    private static Instruction findInstructionByLocation(int n, UniqueVector uniqueVector) throws DecompilerException {
        try {
            return (Instruction)uniqueVector.elementAt(lookup[n]);
        }
        catch (Exception exception) {
            throw new DecompilerException(8301);
        }
    }

    public static int findNumberForCatch(int n) throws DecompilerException {
        int n2 = 0;
        while (n2 < catchInfoVector.size()) {
            CatchInfo catchInfo = (CatchInfo)catchInfoVector.elementAt(n2);
            if (catchInfo.startLocation == n) {
                return catchInfo.number;
            }
            ++n2;
        }
        Decompiler.report("Catch block not found");
        return 99;
    }

    public static String findTypeForCatch(int n) throws DecompilerException {
        int n2 = 0;
        while (n2 < catchInfoVector.size()) {
            CatchInfo catchInfo = (CatchInfo)catchInfoVector.elementAt(n2);
            if (catchInfo.startLocation == n) {
                if (catchInfo.exceptionType == "nullCatchType") {
                    return "java/lang/Exception";
                }
                return catchInfo.exceptionType;
            }
            ++n2;
        }
        Decompiler.report("Catch block not found");
        return "UnknownType";
    }

    public static String getClassName() {
        return Decompiler.methodInformation.myClassName;
    }

    public static CodeBlock getMethodBlock() throws DecompilerException {
        if (methodBlock == null) {
            throw new DecompilerException(1801);
        }
        return methodBlock;
    }

    public static String getPackageName() {
        return Decompiler.methodInformation.myClass.getRawPackageName();
    }

    private static Parameter[] getParArray(UniqueVector uniqueVector, boolean bl) {
        int n;
        int n2;
        int n3 = uniqueVector.size();
        if (!bl) {
            ++n3;
        }
        Parameter[] parameterArray = new Parameter[n3];
        int n4 = 0;
        while (n4 < n3) {
            parameterArray[n4] = new Parameter();
            ++n4;
        }
        if (!bl) {
            parameterArray[0].slot = 0;
            parameterArray[0].type = Decompiler.getClassName();
            n2 = 1;
            n = 1;
        } else {
            n2 = 0;
            n = 0;
        }
        int n5 = 0;
        while (n5 < uniqueVector.size()) {
            String string;
            parameterArray[n2].type = string = (String)uniqueVector.elementAt(n5);
            parameterArray[n2].slot = n++;
            ++n2;
            if (string.equals("long") || string.equals("double")) {
                ++n;
            }
            ++n5;
        }
        return parameterArray;
    }

    public static String getParameterType(int n) throws DecompilerException {
        UniqueVector uniqueVector = methodInformation.parameterList();
        int n2 = -1;
        int n3 = 0;
        while (n3 < parLocalArray.length) {
            if (Decompiler.parLocalArray[n3].slot == n) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        if (n2 < 0) {
            throw new DecompilerException(10112);
        }
        String string = !methodInformation.isStatic() ? (n2 == 0 ? Decompiler.getClassName() : (String)uniqueVector.elementAt(n2 - 1)) : (String)uniqueVector.elementAt(n2);
        return string;
    }

    public static String getSuperName() {
        return Decompiler.methodInformation.myClass.getSuperClassName();
    }

    private static boolean handlerBreak(Instruction instruction, Instruction instruction2) {
        int n = 0;
        while (n < tryEntrys.size()) {
            TryEntry tryEntry = (TryEntry)tryEntrys.elementAt(n);
            if (tryEntry.startPC == instruction2.location) {
                return true;
            }
            if (instruction.location >= tryEntry.startPC && instruction.location < tryEntry.inactivePC && instruction2.location >= tryEntry.inactivePC) {
                return true;
            }
            if (tryEntry.handlerInstructions.contains(instruction2.location)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static void initSymbols() {
        initSymbols = new UniqueVector();
    }

    private static void integrateAllLocals() throws DecompilerException {
        int n = 0;
        while (n < instructionList.size()) {
            Instruction instruction = (Instruction)instructionList.elementAt(n);
            if (instruction.processed && instruction.referringInstructionList.size() > 1) {
                Decompiler.integrateLocals(instruction);
            }
            ++n;
        }
    }

    private static void integrateLocals(Instruction instruction) throws DecompilerException {
        int n = 0;
        while (n < instruction.referringInstructionList.size()) {
            Instruction instruction2 = (Instruction)instruction.referringInstructionList.elementAt(n);
            if (instruction2.processed) {
                instruction.integrateLocals(instruction2.localTable);
            }
            ++n;
        }
    }

    public static boolean isFieldName(String string) {
        return info.containFieldNamed(string);
    }

    private static boolean isInterfaceStaticInit() {
        return info.isInterface() && methodInformation.getMethodOnlyName().equals("<clinit>");
    }

    public static boolean isLocal(int n) {
        int n2 = 0;
        while (n2 < parLocalArray.length) {
            if (Decompiler.parLocalArray[n2].slot == n) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isStaticInit() {
        return methodInformation.getMethodOnlyName().equals("<clinit>");
    }

    public static boolean isVirtualMethod() {
        return methodInformation.isStatic() ^ true;
    }

    private static int jsrInSecond(Instruction instruction) {
        if (instruction.nextInstructionList.size() == 1) {
            Instruction instruction2 = (Instruction)instruction.nextInstructionList.elementAt(0);
            if (instruction2.type == "JSR") {
                return instruction2.target;
            }
        }
        return -1;
    }

    private static UniqueVector list(byte[] byArray, int n, MethodInfo methodInfo, MACodeHandlerEntry[] mACodeHandlerEntryArray) throws DecompilerException {
        labelNumber = 0;
        startTime = System.currentTimeMillis();
        code = byArray;
        length = n;
        handlers = mACodeHandlerEntryArray;
        someSynchs = false;
        finallyTargets = new ExpandableArray();
        UniqueVector uniqueVector = new UniqueVector();
        Decompiler.buildInstructionNetwork();
        Decompiler.buildTryBlocks(handlers);
        if (debugTime) {
            Decompiler.time(0);
        }
        methodBlock = Decompiler.makeSegments(codeIslandStartInstructions);
        if (debugTime) {
            Decompiler.time(1);
        }
        if (instructionList.size() > 1000 && statusListener != null) {
            statusListener.status("Very large method - please wait");
        }
        Decompiler.buildStackAndLocalInfo();
        if (debugTime) {
            Decompiler.time(2);
        }
        Decompiler.logicalAnds();
        if (debugTime) {
            Decompiler.time(3);
        }
        CodeBlockAnalyzer.analyze(methodBlock, instructionList, tryEntrys, finallyTargets, codeIslandStartInstructions);
        if (debugTime) {
            Decompiler.time(4);
        }
        LocalVariableInfo.locateInitializers();
        if (debugTime) {
            Decompiler.time(5);
        }
        methodBlock.source(uniqueVector, "");
        if (debugTime) {
            Decompiler.time(6);
        }
        if (Decompiler.isInterfaceStaticInit()) {
            Decompiler.convertStaticInit(uniqueVector);
        }
        return uniqueVector;
    }

    public static UniqueVector listMethod(MethodInfo methodInfo, IStatusListener iStatusListener, boolean bl) {
        int n;
        UniqueVector uniqueVector;
        UniqueVector uniqueVector2;
        block18: {
            UniqueVector uniqueVector3;
            int n2;
            if (showName) {
                AnalyzerUtilities.p("* * * * * * * BEGIN METHOD " + methodInfo.getCompleteDisplayName());
            }
            showBytes = bl;
            statusListener = iStatusListener;
            if (statusListener != null) {
                statusListener.status("Decompiling " + methodInfo.getBlockDisplayName());
            }
            MACodeEntry mACodeEntry = methodInfo.getCodeEntry();
            methodInformation = methodInfo;
            info = methodInfo.myClass;
            methodType = methodInformation.myType();
            parLocalArray = Decompiler.getParArray(methodInfo.parameterList(), methodInfo.isStatic());
            messages = new UniqueVector();
            catchNumber = 1;
            uniqueVector2 = new UniqueVector();
            uniqueVector2.addElement("");
            try {
                if (mACodeEntry == null) {
                    LocalVariableInfo.initialize(methodInfo, parLocalArray);
                    LocalDescriptor.initialize();
                    LocalVariableInfo.locateInitializers();
                    uniqueVector2.addElement(String.valueOf(Decompiler.methodDeclarator(methodInfo)) + ";");
                } else {
                    uniqueVector = Decompiler.list(mACodeEntry.codeBuffer, mACodeEntry.codeCount, methodInfo, mACodeEntry.handlers);
                    uniqueVector2.addElement(Decompiler.methodDeclarator(methodInfo));
                    n = 0;
                    while (n < messages.size()) {
                        uniqueVector2.addElement("// WARNING: " + messages.elementAt(n));
                        if (alertMsg) {
                            AnalyzerUtilities.alert(String.valueOf(Decompiler.methodDeclarator(methodInfo)) + ":" + messages.elementAt(n));
                        }
                        ++n;
                    }
                    if (messages.size() > 0 || listDebug || showBytes) {
                        UniqueVector uniqueVector4 = new UniqueVector();
                        Decompiler.dumpTrys(mACodeEntry.handlers, uniqueVector4);
                        DecompilerLibrary.showInstructionList(uniqueVector4, instructionList);
                        int n3 = 0;
                        while (n3 < uniqueVector4.size()) {
                            uniqueVector2.addElement(uniqueVector4.elementAt(n3));
                            ++n3;
                        }
                    }
                    n2 = 0;
                    while (n2 < uniqueVector.size()) {
                        uniqueVector2.addElement(uniqueVector.elementAt(n2));
                        ++n2;
                    }
                }
                break block18;
            }
            catch (DecompilerException decompilerException) {
                uniqueVector3 = new UniqueVector();
                try {
                    Decompiler.debug();
                    messages.addElement("// " + methodInfo.getMethodSourceName() + ":" + decompilerException.toString());
                    n2 = 0;
                    while (n2 < messages.size()) {
                        if (alertMsg) {
                            AnalyzerUtilities.alert(String.valueOf(Decompiler.methodDeclarator(methodInfo)) + ":" + messages.elementAt(n2));
                        }
                        AnalyzerUtilities.p(messages.elementAt(n2));
                        uniqueVector2.addElement("// WARNING: " + messages.elementAt(n2));
                        ++n2;
                    }
                    Decompiler.dumpTrys(mACodeEntry.handlers, uniqueVector3);
                    DecompilerLibrary.showInstructionList(uniqueVector3, instructionList);
                }
                catch (DecompilerException decompilerException2) {}
            }
            uniqueVector2.addElement("// Report to MK Software at www.classmapper.com.");
            n2 = 0;
            while (n2 < uniqueVector3.size()) {
                uniqueVector2.addElement(uniqueVector3.elementAt(n2));
                ++n2;
            }
        }
        uniqueVector2.addElement("");
        if (Decompiler.isInterfaceStaticInit()) {
            uniqueVector = new UniqueVector();
            n = 0;
            while (n < uniqueVector2.size()) {
                uniqueVector.addElement("// " + uniqueVector2.elementAt(n));
                ++n;
            }
            uniqueVector2 = uniqueVector;
        }
        return uniqueVector2;
    }

    private static void logicalAnds() throws DecompilerException {
        while (Decompiler.logicalAndsOnePass()) {
        }
    }

    private static boolean logicalAndsOnePass() throws DecompilerException {
        boolean bl = false;
        int n = 0;
        while (n < Decompiler.methodBlock.subBlocks.size()) {
            int n2 = 0;
            while (n2 < Decompiler.methodBlock.subBlocks.size()) {
                CodeBlock codeBlock;
                CodeBlock codeBlock2 = (CodeBlock)Decompiler.methodBlock.subBlocks.elementAt(n);
                if (!codeBlock2.equals(codeBlock = (CodeBlock)Decompiler.methodBlock.subBlocks.elementAt(n2)) && codeBlock2.type == "SIMPLECONDBRANCH" && codeBlock.type == "SIMPLECONDBRANCH") {
                    CodeBlock codeBlock3 = (CodeBlock)codeBlock2.nextBlockList.elementAt(1);
                    CodeBlock codeBlock4 = (CodeBlock)codeBlock2.nextBlockList.elementAt(0);
                    CodeBlock codeBlock5 = (CodeBlock)codeBlock.nextBlockList.elementAt(1);
                    CodeBlock codeBlock6 = (CodeBlock)codeBlock.nextBlockList.elementAt(0);
                    CodeBlock codeBlock7 = null;
                    CodeBlock codeBlock8 = null;
                    if (codeBlock4.equals(codeBlock5) || codeBlock4.equals(codeBlock6)) {
                        codeBlock7 = codeBlock3;
                        codeBlock8 = codeBlock4;
                    }
                    if (codeBlock3.equals(codeBlock5) || codeBlock3.equals(codeBlock6)) {
                        codeBlock7 = codeBlock4;
                        codeBlock8 = codeBlock3;
                    }
                    if (codeBlock7 != null && codeBlock2.last.statement != null && codeBlock.last.statement != null && codeBlock7.reachesDirectlyNoAction(codeBlock)) {
                        boolean bl2;
                        String string;
                        if (codeBlock6.equals(codeBlock8)) {
                            string = "LAND";
                            bl2 = codeBlock7 == codeBlock4;
                        } else {
                            string = "LOR";
                            bl2 = codeBlock8 == codeBlock4;
                        }
                        codeBlock2.type = "SIMPLEOTHER";
                        codeBlock2.nextBlockList.removeElement(codeBlock8);
                        Operand operand = codeBlock2.last.statement.get(0);
                        Operand operand2 = codeBlock.last.statement.get(0);
                        if (bl2) {
                            operand = new Operand("NOT", null, operand, null, new Type("boolean"), null, null);
                        }
                        Operand operand3 = new Operand(string, null, operand2, operand, new Type("boolean"), null, null);
                        codeBlock.last.statement.replaceOperand(operand3);
                        codeBlock2.last.statement = null;
                        codeBlock2.last.type = "NONBRANCH";
                        codeBlock8.first.referringInstructionList.removeElement(codeBlock2.last);
                        bl = true;
                    }
                }
                ++n2;
            }
            ++n;
        }
        return bl;
    }

    private static void makeOperandsAndLocals(Instruction instruction, Stack stack, LocalVariableTable localVariableTable, boolean bl) throws DecompilerException {
        block6: {
            Instruction instruction2;
            Instruction instruction3 = instruction;
            while (true) {
                if (stack == null || localVariableTable == null) {
                    throw new DecompilerException(1583);
                }
                instruction3.inStack = stack;
                if (instruction3.referringInstructionList.size() > 1) {
                    instruction3.integrateLocals(localVariableTable);
                    localVariableTable = instruction3.localTable;
                }
                UniqueVector uniqueVector = StackEvaluator.updateStack(code, length, (Stack)stack.clone(), instruction3, info, methodType, localVariableTable.copy(), parLocalArray, bl);
                stack = (Stack)uniqueVector.elementAt(0);
                localVariableTable = (LocalVariableTable)uniqueVector.elementAt(1);
                instruction3.outStack = stack;
                instruction3.localTable = localVariableTable;
                instruction3.processed = true;
                if (instruction3.nextInstructionList.size() != 1) break;
                instruction2 = (Instruction)instruction3.nextInstructionList.elementAt(0);
                if (!instruction2.processed) {
                    instruction3 = instruction2;
                    continue;
                }
                break block6;
                break;
            }
            int n = 0;
            while (n < instruction3.nextInstructionList.size()) {
                instruction2 = (Instruction)instruction3.nextInstructionList.elementAt(n);
                if (!instruction2.processed) {
                    Decompiler.makeOperandsAndLocals(instruction2, stack, localVariableTable, bl);
                }
                ++n;
            }
        }
    }

    private static boolean makePossibleCatches(UniqueVector uniqueVector, boolean bl) throws DecompilerException {
        boolean bl2 = true;
        int n = 0;
        while (n < catchInfoVector.size()) {
            CatchInfo catchInfo = (CatchInfo)catchInfoVector.elementAt(n);
            if (!catchInfo.processed) {
                Instruction instruction = catchInfo.firstHandlerInstruction;
                Instruction instruction2 = catchInfo.firstTryInstruction;
                if (instruction2 == null) {
                    throw new DecompilerException(1581);
                }
                if (!instruction2.processed) {
                    bl2 = false;
                } else {
                    String string = catchInfo.exceptionType == "nullCatchType" ? "java/lang/Exception" : catchInfo.exceptionType;
                    Decompiler.makeOperandsAndLocals(instruction, Decompiler.catchStack(string, catchInfo.number), instruction2.localTable.copy(), bl);
                    if (uniqueVector.contains(instruction)) {
                        uniqueVector.removeElement(instruction);
                    }
                    catchInfo.processed = true;
                }
            }
            ++n;
        }
        return bl2;
    }

    private static boolean makePossibleFinallys(UniqueVector uniqueVector, boolean bl) throws DecompilerException {
        boolean bl2 = true;
        int n = 0;
        while (n < tryEntrys.size()) {
            TryEntry tryEntry = (TryEntry)tryEntrys.elementAt(n);
            if (!tryEntry.finallyProcessed && tryEntry.finallyStart >= 0) {
                Instruction instruction = Decompiler.findFinalTarget(Decompiler.findInstructionByLocation(tryEntry.finallyStart, instructionList));
                if (tryEntry.firstInstruction == null) {
                    throw new DecompilerException(15811);
                }
                if (!tryEntry.firstInstruction.processed) {
                    bl2 = false;
                } else {
                    Decompiler.makeOperandsAndLocals(instruction, Decompiler.finallyStack(), tryEntry.firstInstruction.localTable.copy(), bl);
                    if (uniqueVector.contains(instruction)) {
                        uniqueVector.addElement(instruction);
                    }
                    tryEntry.finallyProcessed = true;
                }
            }
            ++n;
        }
        return bl2;
    }

    private static CodeBlock makeSegments(UniqueVector uniqueVector) throws DecompilerException {
        CodeBlock codeBlock = new CodeBlock("MAIN");
        codeBlock.entry = Decompiler.addSegment(startInstruction, startInstruction, codeBlock);
        int n = 0;
        while (n < uniqueVector.size()) {
            Instruction instruction = (Instruction)uniqueVector.elementAt(n);
            Decompiler.addSegment(instruction, instruction, codeBlock);
            ++n;
        }
        int n2 = 0;
        while (n2 < instructionList.size()) {
            Instruction instruction = (Instruction)instructionList.elementAt(n2);
            if (instruction.type != "UNCONDBRANCH" && !codeBlock.containsInstruction(instruction)) {
                throw new DecompilerException(1403);
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < codeBlock.subBlocks.size()) {
            CodeBlock codeBlock2 = (CodeBlock)codeBlock.subBlocks.elementAt(n3);
            int n4 = codeBlock2.last.nextInstructionList.size();
            if (n4 > 1) {
                if (codeBlock2.last.type == "CONDBRANCH") {
                    codeBlock2.type = "SIMPLECONDBRANCH";
                } else if (codeBlock2.last.type == "MULTIBRANCH") {
                    codeBlock2.type = "SIMPLEMULTIBRANCH";
                } else {
                    throw new DecompilerException(1405);
                }
            }
            int n5 = 0;
            while (n5 < n4) {
                Instruction instruction = (Instruction)codeBlock2.last.nextInstructionList.elementAt(n5);
                codeBlock2.addNextBlockList(instruction.enclosingCodeBlock);
                ++n5;
            }
            ++n3;
        }
        return codeBlock;
    }

    private static void markAllMultiplyAccessedOps() throws DecompilerException {
        int n = 0;
        while (n < instructionList.size()) {
            Instruction instruction = (Instruction)instructionList.elementAt(n);
            if (instruction.statement != null && instruction.statement.action != "NEVER") {
                instruction.statement.touch(false);
            }
            ++n;
        }
    }

    private static void markUnusedStatementsNever() throws DecompilerException {
        int n = 0;
        while (n < instructionList.size()) {
            Instruction instruction = (Instruction)instructionList.elementAt(n);
            if (instruction.statement != null && instruction.statement.action != "NEVER") {
                instruction.statement.markOperandsNever();
            }
            if (instruction.saveLabel >= 0) {
                instruction.operandIPush.markNever();
            }
            ++n;
        }
    }

    private static String methodDeclarator(MethodInfo methodInfo) throws DecompilerException {
        Object object;
        if (methodInfo.getSourceMethodName().equals("<clinit>")) {
            return "static";
        }
        String string = "";
        if (!methodInfo.getMethodOnlyName().equals("<init>")) {
            string = String.valueOf(NameMgr.useConvert(methodInfo.myType(), 1)) + " ";
        }
        String string2 = info.isInterface() ? methodInfo.getStatusesExcAbstract() : methodInfo.getStatuses();
        string2 = String.valueOf(string2) + string + methodInfo.getSourceMethodName() + "(";
        int n = 0;
        if (!methodInformation.isStatic()) {
            n = 1;
        }
        int n2 = 0;
        while (n < parLocalArray.length) {
            if (n2 > 0) {
                string2 = String.valueOf(string2) + ", ";
            }
            object = NameMgr.useConvert(Decompiler.parLocalArray[n].type, 1);
            string2 = String.valueOf(string2) + (String)object + " " + LocalVariableInfo.getLocalName(Decompiler.parLocalArray[n].slot, null);
            ++n;
            ++n2;
        }
        string2 = String.valueOf(string2) + ")";
        object = methodInformation.getExceptionEntry();
        if (object != null && ((MAExceptionEntry)object).throwCount > 0) {
            string2 = String.valueOf(string2) + " throws ";
            int n3 = 0;
            while (n3 < ((MAExceptionEntry)object).throwCount) {
                if (n3 > 0) {
                    string2 = String.valueOf(string2) + " ,";
                }
                string2 = String.valueOf(string2) + NameMgr.useConvert(((MAExceptionEntry)object).throwArray[n3], 1);
                ++n3;
            }
        }
        return string2;
    }

    private static boolean monitorExitInSecond(Instruction instruction) {
        if (instruction.nextInstructionList.size() == 1) {
            Instruction instruction2 = (Instruction)instruction.nextInstructionList.elementAt(0);
            if (instruction2.opcode == 195) {
                return true;
            }
        }
        return false;
    }

    private static int overlap(int n, int n2, int n3, int n4) throws DecompilerException {
        if (n > n2 || n3 > n4) {
            return 1;
        }
        if (n == n3) {
            if (n2 == n4) {
                return 2;
            }
            if (n2 < n4) {
                return 5;
            }
            return 3;
        }
        if (n2 == n4) {
            if (n > n3) {
                return 5;
            }
            return 3;
        }
        if (n3 < n && n4 >= n) {
            if (n3 <= n2 && n4 > n2) {
                return 5;
            }
            return 1;
        }
        if (n3 <= n2 && n4 > n2) {
            return 1;
        }
        if (n > n4 || n2 < n3) {
            return 7;
        }
        return 3;
    }

    private static void printInstructions(UniqueVector uniqueVector, String string) {
        AnalyzerUtilities.p("METHOD " + string);
        UniqueVector uniqueVector2 = new UniqueVector();
        DecompilerLibrary.showInstructionList(uniqueVector2, uniqueVector);
        int n = 0;
        while (n < uniqueVector2.size()) {
            AnalyzerUtilities.p(uniqueVector2.elementAt(n));
            ++n;
        }
    }

    public static void report(String string) {
        messages.addElement(string);
        AnalyzerUtilities.p(string);
    }

    private static void setInstructionsUnProcessed() {
        int n = 0;
        while (n < instructionList.size()) {
            ((Instruction)instructionList.elementAt(n)).init();
            ++n;
        }
    }

    private static void time(int n) {
        currTime = System.currentTimeMillis();
        AnalyzerUtilities.p("Point " + n + " " + (currTime - startTime));
        startTime = currTime;
    }
}

