/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.analyzer;

import org.apache.tools.analyzer.AnalyzerUtilities;
import org.apache.tools.analyzer.DecompilerException;
import org.apache.tools.analyzer.Instruction;
import org.apache.tools.analyzer.Operand;
import org.apache.tools.analyzer.UniqueVector;
import org.apache.tools.analyzer.structures.Pair;
import org.apache.tools.analyzer.structures.TryEntry;

public class DecompilerLibrary {
    public static String asChar(char c) {
        if (c < ' ' || c == '\\' || c == '\"' || c >= '\u007f' || c == '\'') {
            return String.valueOf('\'') + DecompilerLibrary.toOctal(c) + '\'';
        }
        char[] cArray = new char[]{'\'', c, '\''};
        return new String(cArray);
    }

    public static void dumpTryEntrys(UniqueVector uniqueVector) {
        int n = 0;
        while (n < uniqueVector.size()) {
            TryEntry tryEntry = (TryEntry)uniqueVector.elementAt(n);
            AnalyzerUtilities.p("try entry: " + tryEntry.startPC + " " + tryEntry.inactivePC);
            ++n;
        }
    }

    public static final int getFourByte(byte[] byArray, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < 4) {
            int n4;
            if ((n4 = byArray[n++]) < 0) {
                n4 += 256;
            }
            n2 = (n2 << 8) + n4;
            ++n3;
        }
        return n2;
    }

    public static final int getFourByteSigned(byte[] byArray, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < 4) {
            int n4 = byArray[n + n3] & 0xFF;
            n2 = n2 << 8 | n4;
            ++n3;
        }
        return n2;
    }

    public static UniqueVector getMethodParameterVector(String string) {
        int n = string.indexOf(":");
        if (n >= 0) {
            String string2 = string.substring(n + 1, string.length());
            return AnalyzerUtilities.getMethodParameters(string2, new UniqueVector());
        }
        return null;
    }

    public static final int getOneByte(byte[] byArray, int n) {
        int n2 = 0;
        int n3 = byArray[n];
        if (n3 < 0) {
            n3 += 256;
        }
        n2 = n3;
        return n2;
    }

    public static final int getOneByteSigned(byte[] byArray, int n) {
        int n2 = 0;
        int n3 = byArray[n] & 0xFF;
        n2 = n3;
        if ((n2 & 0x80) != 0) {
            n2 |= 0xFFFFFF00;
        }
        return n2;
    }

    public static final int getTwoByte(byte[] byArray, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < 2) {
            int n4;
            if ((n4 = byArray[n++]) < 0) {
                n4 += 256;
            }
            n2 = (n2 << 8) + n4;
            ++n3;
        }
        return n2;
    }

    public static final int getTwoByteSigned(byte[] byArray, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < 2) {
            int n4 = byArray[n + n3] & 0xFF;
            n2 = n2 << 8 | n4;
            ++n3;
        }
        if ((n2 & 0x8000) != 0) {
            n2 |= 0xFFFF0000;
        }
        return n2;
    }

    public static String getType(Object object) throws DecompilerException {
        if (object instanceof Long) {
            return "long";
        }
        if (object instanceof Double) {
            return "double";
        }
        if (object instanceof Float) {
            return "float";
        }
        if (object instanceof Integer) {
            return "int";
        }
        if (object instanceof String) {
            return "java/lang/String";
        }
        throw new DecompilerException(1810);
    }

    public static final int handle170(byte[] byArray, int n, UniqueVector uniqueVector) {
        int n2 = DecompilerLibrary.getFourByte(byArray, n += ++n % 4 == 0 ? 0 : 4 - n % 4);
        int n3 = DecompilerLibrary.getFourByte(byArray, n += 4);
        int n4 = DecompilerLibrary.getFourByte(byArray, n += 4);
        n += 4;
        int n5 = n3;
        while (n5 <= n4) {
            int n6 = n5;
            int n7 = DecompilerLibrary.getFourByte(byArray, n);
            if (uniqueVector != null) {
                uniqueVector.addElement(new Pair(n6, n7));
            }
            n += 4;
            ++n5;
        }
        if (uniqueVector != null) {
            uniqueVector.addElement(new Pair(0, n2));
        }
        return n;
    }

    public static final int handle171(byte[] byArray, int n, UniqueVector uniqueVector) {
        int n2 = DecompilerLibrary.getFourByte(byArray, n += ++n % 4 == 0 ? 0 : 4 - n % 4);
        int n3 = DecompilerLibrary.getFourByte(byArray, n += 4);
        n += 4;
        int n4 = 0;
        while (n4 < n3) {
            int n5 = DecompilerLibrary.getFourByte(byArray, n);
            int n6 = DecompilerLibrary.getFourByte(byArray, n + 4);
            if (uniqueVector != null) {
                uniqueVector.addElement(new Pair(n5, n6));
            }
            n += 8;
            ++n4;
        }
        if (uniqueVector != null) {
            uniqueVector.addElement(new Pair(0, n2));
        }
        return n;
    }

    public static void handleBadInstruction(byte[] byArray, int n, int n2, int n3) {
        AnalyzerUtilities.alert("Invalid instruction at " + n2 + ":" + n3);
        int n4 = -10;
        while (n4 < 10) {
            int n5 = n4 + n2;
            if (n5 >= 0 && n5 < n) {
                int n6 = byArray[n5];
                if (n6 < 0) {
                    n6 += 256;
                }
                AnalyzerUtilities.p(String.valueOf(n5) + ":" + n6 + "  ");
            }
            ++n4;
        }
    }

    public static String makeReadable(String string) {
        char[] cArray = string.toCharArray();
        boolean bl = false;
        int n = 0;
        while (n < cArray.length) {
            char c = cArray[n];
            if (c < ' ' || c == '\\' || c == '\"' || c >= '\u007f') {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < cArray.length) {
            char c = cArray[n2];
            if (c < ' ' || c == '\\' || c == '\"' || c >= '\u007f') {
                stringBuffer.append(DecompilerLibrary.toOctal(c));
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String removeClass(String string) throws DecompilerException {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            throw new DecompilerException(1821);
        }
        return string.substring(n + 1, string.length());
    }

    public static String removeMethodOrField(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return "Invalid Parameter String for Remove Method Or Field";
        }
        return string.substring(0, n);
    }

    public static void showInstructionList(UniqueVector uniqueVector, UniqueVector uniqueVector2) {
        int n = 0;
        while (n < uniqueVector2.size()) {
            Instruction instruction = (Instruction)uniqueVector2.elementAt(n);
            uniqueVector.addElement(instruction.toString());
            ++n;
        }
    }

    public static String toOctal(char c) {
        int n = c / 64;
        c = (char)(c - n * 64);
        int n2 = c / 8;
        c = (char)(c - n2 * 8);
        return "\\" + n + n2 + c;
    }

    public static boolean zeroOrOne(Operand operand) {
        if (operand.oper == "CONSTANT") {
            int n;
            Object object = operand.constantOrName;
            if (object == "Zero") {
                return true;
            }
            if (object instanceof Integer && ((n = ((Integer)object).intValue()) == 0 || n == 1)) {
                return true;
            }
        }
        return false;
    }
}

