/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.analyzer;

import java.util.Stack;
import org.apache.tools.analyzer.AnalyzerUtilities;
import org.apache.tools.analyzer.CodeBlock;
import org.apache.tools.analyzer.Decompiler;
import org.apache.tools.analyzer.DecompilerException;
import org.apache.tools.analyzer.DecompilerLibrary;
import org.apache.tools.analyzer.ExpandableArray;
import org.apache.tools.analyzer.LocalDescriptor;
import org.apache.tools.analyzer.LocalVariableTable;
import org.apache.tools.analyzer.OpcData;
import org.apache.tools.analyzer.Operand;
import org.apache.tools.analyzer.Statement;
import org.apache.tools.analyzer.UniqueVector;
import org.apache.tools.analyzer.structures.Pair;

public class Instruction {
    public int location;
    public int opcode;
    public String type;
    public int target;
    public boolean wide;
    public int targetCount;
    public UniqueVector nextInstructionList;
    public ExpandableArray onValueList;
    public UniqueVector referringInstructionList;
    public UniqueVector multiTargets;
    public CodeBlock enclosingCodeBlock;
    public Stack inStack = null;
    public Stack outStack = null;
    public LocalVariableTable localTable = null;
    public boolean processed = false;
    public Statement statement = null;
    public Operand operandIPush = null;
    public int saveLabel = -1;
    public String saveInit = "";
    public String constant;

    public Instruction() {
        this(-1, -1, "NONBRANCH", -1, false);
    }

    public Instruction(int n, int n2, String string, int n3, boolean bl) {
        this.location = n;
        this.opcode = n2;
        this.type = string;
        this.target = n3;
        this.wide = bl;
        this.targetCount = 0;
        this.enclosingCodeBlock = null;
        this.nextInstructionList = new UniqueVector(1, 1);
        this.referringInstructionList = new UniqueVector(1, 1);
        this.onValueList = new ExpandableArray();
    }

    public Instruction(int n, int n2, String string, UniqueVector uniqueVector, boolean bl) {
        this(n, n2, string, 0, bl);
        this.multiTargets = uniqueVector;
        this.enclosingCodeBlock = null;
    }

    public void addNextInstruction(Instruction instruction, int n) {
        if (this.type != "MULTIBRANCH") {
            int n2 = 0;
            while (n2 < this.nextInstructionList.size()) {
                if (((Instruction)this.nextInstructionList.elementAt(n2)).equals(instruction)) {
                    return;
                }
                ++n2;
            }
        }
        this.nextInstructionList.addElement(instruction);
        this.onValueList.add(n);
    }

    public void addReferringInstruction(Instruction instruction) {
        if (instruction.type == "UNCONDBRANCH") {
            AnalyzerUtilities.p("uncondbranch added");
        }
        int n = 0;
        while (n < this.referringInstructionList.size()) {
            if (((Instruction)this.referringInstructionList.elementAt(n)).equals(instruction)) {
                return;
            }
            ++n;
        }
        this.referringInstructionList.addElement(instruction);
    }

    public boolean allBranchesSame() {
        if (this.nextInstructionList.size() <= 1) {
            return true;
        }
        int n = ((Instruction)this.nextInstructionList.elementAt((int)0)).location;
        int n2 = 0;
        while (n2 < this.nextInstructionList.size()) {
            if (((Instruction)this.nextInstructionList.elementAt((int)n2)).location != n) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean anyFollowingHaveMultipleEntrys() {
        int n = 0;
        while (n < this.nextInstructionList.size()) {
            Instruction instruction = (Instruction)this.nextInstructionList.elementAt(n);
            if (instruction.referringInstructionList.size() > 1) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private String description() {
        if (this.type == "NONBRANCH") {
            return "";
        }
        return this.type;
    }

    public boolean equals(Instruction instruction) {
        return instruction == this;
    }

    public boolean generatesStatement() {
        if (this.statement != null && this.statement.action != "NEVER") {
            return true;
        }
        return this.saveLabel >= 0;
    }

    public Instruction getBranch(boolean bl) throws DecompilerException {
        if (this.type != "CONDBRANCH") {
            throw new DecompilerException(1881);
        }
        if (this.onValueList.size() != 2) {
            throw new DecompilerException(1882);
        }
        if (this.onValueList.get(0) != 102) {
            throw new DecompilerException(1883);
        }
        return (Instruction)this.nextInstructionList.elementAt(bl ? 1 : 0);
    }

    public Instruction getNextInstructionForValue(int n) throws DecompilerException {
        int n2 = 0;
        while (n2 < this.onValueList.size()) {
            if (this.onValueList.get(n2) == n) {
                return (Instruction)this.nextInstructionList.elementAt(n2);
            }
            ++n2;
        }
        throw new DecompilerException(8302);
    }

    public int getTarget() {
        return this.target;
    }

    public void init() {
        this.inStack = null;
        this.outStack = null;
        this.localTable = null;
        this.processed = false;
        this.statement = null;
        this.operandIPush = null;
    }

    private void integrate(LocalDescriptor localDescriptor, LocalDescriptor localDescriptor2, int n) throws DecompilerException {
        if (localDescriptor2 == null) {
            if (localDescriptor != null) {
                this.localTable.setAtSlot(new LocalDescriptor(localDescriptor, n, this), n);
            } else {
                Decompiler.report("Invalid local table state");
            }
        } else if (localDescriptor != null) {
            if (localDescriptor == localDescriptor2) {
                return;
            }
            if (localDescriptor2.contains(localDescriptor)) {
                return;
            }
            localDescriptor2.addElement(localDescriptor);
        }
    }

    public void integrateLocals(LocalVariableTable localVariableTable) throws DecompilerException {
        int n;
        if (this.localTable == null) {
            this.localTable = new LocalVariableTable();
        }
        ExpandableArray expandableArray = new ExpandableArray();
        int n2 = 0;
        while (n2 < localVariableTable.size()) {
            expandableArray.add(localVariableTable.getIndex((int)n2).slot);
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.localTable.size()) {
            n = this.localTable.getIndex((int)n3).slot;
            if (!expandableArray.contains(n)) {
                expandableArray.add(n);
            }
            ++n3;
        }
        n = 0;
        while (n < expandableArray.size()) {
            int n4 = expandableArray.get(n);
            LocalDescriptor localDescriptor = localVariableTable.getSlot(n4);
            LocalDescriptor localDescriptor2 = this.localTable.getSlot(n4);
            int n5 = localDescriptor == null ? localDescriptor2.slot : localDescriptor.slot;
            this.integrate(localDescriptor, localDescriptor2, n5);
            ++n;
        }
    }

    private String justify(String string, int n) {
        int n2 = string.length();
        char[] cArray = new char[n];
        int n3 = 0;
        while (n3 < n) {
            cArray[n3] = 32;
            ++n3;
        }
        char[] cArray2 = new char[n2];
        string.getChars(0, n2, cArray2, 0);
        int n4 = 0;
        while (n4 < n2 && n4 < n) {
            cArray[n4] = cArray2[n4];
            ++n4;
        }
        return new String(cArray);
    }

    public int makeSaveStatement(UniqueVector uniqueVector, String string) throws DecompilerException {
        if (this.saveLabel < 0) {
            return 0;
        }
        if (this.operandIPush == null) {
            throw new DecompilerException(12101);
        }
        Statement.putLocalStatic(uniqueVector, this.saveLabel, this.operandIPush, this, this.saveInit, string);
        return 1;
    }

    public void print() {
        AnalyzerUtilities.p(this.toString());
    }

    public String targets() {
        String string = "";
        int n = 0;
        while (n < this.nextInstructionList.size()) {
            Instruction instruction = (Instruction)this.nextInstructionList.elementAt(n);
            string = String.valueOf(string) + " " + instruction.location + "(" + this.onValueList.get(n) + ")";
            ++n;
        }
        return string;
    }

    public Instruction theNextInstruction() {
        if (this.nextInstructionList.size() == 1) {
            return (Instruction)this.nextInstructionList.elementAt(0);
        }
        return null;
    }

    public String toString() {
        String string;
        String string2 = "   ";
        if (this.opcode >= OpcData.opcNames.length || this.opcode < 0) {
            string = "other";
        } else {
            string = OpcData.opcNames[this.opcode];
            string = string.substring(4, string.length());
        }
        string = DecompilerLibrary.makeReadable(this.justify(string, 20));
        String string3 = "";
        if (this.statement != null) {
            string3 = this.statement.constantOrName == null ? "" : this.statement.constantOrName.toString();
        }
        if (this.constant != null) {
            string3 = this.constant;
        } else if (string3.equals("null")) {
            string3 = "";
        }
        if ((this.type == "CONDBRANCH" || this.type == "UNCONDBRANCH" || this.type == "JSR") && this.target >= 0) {
            string3 = "target: " + this.target;
        }
        if (this.type == "MULTIBRANCH") {
            string3 = "targets: ";
            int n = 0;
            while (n < this.multiTargets.size()) {
                Pair pair = (Pair)this.multiTargets.elementAt(n);
                string3 = String.valueOf(string3) + pair.x + " -> " + pair.y + " ";
                ++n;
            }
        }
        return "// " + this.justify(String.valueOf(this.location), 4) + " " + string + DecompilerLibrary.makeReadable(string3);
    }

    public void whatYouPush(Operand operand) {
        if (this.operandIPush == null) {
            this.operandIPush = operand;
        }
    }
}

