/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.analyzer;

import org.apache.tools.analyzer.AnalyzerUtilities;
import org.apache.tools.analyzer.Decompiler;
import org.apache.tools.analyzer.DecompilerException;
import org.apache.tools.analyzer.Instruction;
import org.apache.tools.analyzer.Type;
import org.apache.tools.analyzer.UniqueVector;

public class LocalDescriptor {
    public UniqueVector usedAs = new UniqueVector(2, 2);
    public UniqueVector localsThatIFill = new UniqueVector(1, 1);
    public int slot;
    public LocalDescriptor lastDescriptor = null;
    public Type setToType = null;
    public LocalDescriptor setToDesc = null;
    public Type partialType;
    private UniqueVector elements = new UniqueVector(2, 2);
    private Instruction instruction;
    private static UniqueVector localDescriptors;

    public LocalDescriptor(LocalDescriptor localDescriptor, int n, Instruction instruction) {
        this.slot = n;
        this.elements.addElement(localDescriptor);
        this.partialType = localDescriptor.partialType.copy();
        localDescriptors.addElement(this);
    }

    public LocalDescriptor(LocalDescriptor localDescriptor, String string, int n, LocalDescriptor localDescriptor2, Instruction instruction) throws DecompilerException {
        this.setToType = new Type(2, string);
        this.partialType = this.setToType.copy();
        this.constrainSet(this.partialType, localDescriptor2.partialType);
        this.setToDesc = localDescriptor2;
        this.lastDescriptor = localDescriptor;
        this.slot = n;
        localDescriptors.addElement(this);
    }

    public LocalDescriptor(LocalDescriptor localDescriptor, String string, int n, Type type, Instruction instruction) throws DecompilerException {
        this.setToType = new Type(2, string);
        this.partialType = this.setToType.copy();
        this.constrainSet(this.partialType, type);
        this.lastDescriptor = localDescriptor;
        this.slot = n;
        localDescriptors.addElement(this);
    }

    public void addElement(LocalDescriptor localDescriptor) {
        this.elements.addElement(localDescriptor);
    }

    private boolean constrain(Type type, Type type2, boolean bl) throws DecompilerException {
        String string;
        if (type.isInvalid()) {
            return false;
        }
        boolean bl2 = false;
        String string2 = type.getBaseType();
        if (string2 != (string = type2.getBaseType())) {
            type.setInvalid();
            bl2 = true;
        } else if (string2 == "int") {
            bl2 = this.processInts(type, type2, bl);
        } else if (string2 == "Object") {
            bl2 = this.processObjects(type, type2, bl);
        } else if (string2 != "long" && string2 != "double" && string2 != "float" && string2 != "subroutineReturnAddress") {
            throw new DecompilerException(3901);
        }
        return bl2;
    }

    private boolean constrainSet(Type type, Type type2) throws DecompilerException {
        return this.constrain(type, type2, true);
    }

    private boolean constrainUsed(Type type, Type type2) throws DecompilerException {
        return this.constrain(type, type2, false);
    }

    public boolean contains(LocalDescriptor localDescriptor) {
        int n = 0;
        while (n < this.elements.size()) {
            if (this.elements.elementAt(n) == localDescriptor) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static void dumpLocals() {
        AnalyzerUtilities.p("local descriptors:");
        int n = 0;
        while (n < localDescriptors.size()) {
            LocalDescriptor localDescriptor = (LocalDescriptor)localDescriptors.elementAt(n);
            if (localDescriptor.slot == 4) {
                AnalyzerUtilities.p(localDescriptor.toString(true));
            }
            ++n;
        }
    }

    public boolean fullyResolved() {
        return this.partialType.fullyResolved();
    }

    public static void initialize() {
        localDescriptors = new UniqueVector();
    }

    private boolean processInts(Type type, Type type2, boolean bl) throws DecompilerException {
        boolean bl2 = false;
        String string = type.getType();
        String string2 = type2.getType();
        if (string2 != string) {
            if (string2 == "boolean") {
                if (string == "UnknownNumber") {
                    type.setInvalid();
                    bl2 = true;
                } else if (string == "UnknownInt") {
                    type.setType(string2, true);
                    bl2 = true;
                } else {
                    type.setInvalid();
                    bl2 = true;
                }
            } else if (string2 != "UnknownInt") {
                if (string2 == "UnknownNumber") {
                    if (string == "boolean") {
                        type.setInvalid();
                        bl2 = true;
                    } else if (string == "UnknownInt") {
                        type.setType("UnknownNumber", false);
                        bl2 = true;
                    }
                } else if (string == "UnknownNumber") {
                    type.setType(string2, true);
                    bl2 = true;
                } else if (string == "UnknownInt") {
                    type.setType(string2, true);
                    bl2 = true;
                } else if (string == "boolean") {
                    type.setInvalid();
                    bl2 = true;
                }
            }
        }
        return bl2;
    }

    private boolean processObjects(Type type, Type type2, boolean bl) throws DecompilerException {
        String string;
        boolean bl2 = false;
        String string2 = type.getType();
        if (string2 == (string = type2.getType()) || !bl) {
            return false;
        }
        if (string2 == "UnknownObject") {
            if (string != "java/lang/Object") {
                type.setType(string, true);
                bl2 = true;
            }
        } else if (string != "UnknownObject" && string2 != "java/lang/Object") {
            bl2 = true;
            type.setType("java/lang/Object", true);
        }
        return bl2;
    }

    public static void resolveAllLocals() throws DecompilerException {
        int n;
        boolean bl = true;
        while (bl) {
            bl = false;
            n = 0;
            while (n < localDescriptors.size()) {
                LocalDescriptor localDescriptor = (LocalDescriptor)localDescriptors.elementAt(n);
                if (localDescriptor.resolveLocal()) {
                    bl = true;
                }
                ++n;
            }
            int n2 = 0;
            while (n2 < localDescriptors.size()) {
                LocalDescriptor localDescriptor = (LocalDescriptor)localDescriptors.elementAt(n2);
                if (!localDescriptor.partialType.isInvalid() && localDescriptor.resolvePredecessor()) {
                    bl = true;
                }
                ++n2;
            }
        }
        n = 0;
        while (n < localDescriptors.size()) {
            LocalDescriptor localDescriptor = (LocalDescriptor)localDescriptors.elementAt(n);
            localDescriptor.resolveTotally();
            ++n;
        }
    }

    private boolean resolveLocal() throws DecompilerException {
        boolean bl = false;
        if (this.partialType.isInvalid()) {
            return false;
        }
        if (this.setToDesc != null) {
            if (this.constrainSet(this.partialType, this.setToDesc.partialType)) {
                bl = true;
            }
            if (this.partialType.isInvalid()) {
                Decompiler.report("Invalid local type set " + this.toString(true));
            }
        }
        int n = 0;
        while (n < this.localsThatIFill.size()) {
            LocalDescriptor localDescriptor = (LocalDescriptor)this.localsThatIFill.elementAt(n);
            if (this.constrainUsed(this.partialType, localDescriptor.partialType)) {
                bl = true;
            }
            if (this.partialType.isInvalid()) {
                Decompiler.report("Invalid local type store " + this.toString(true));
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.elements.size()) {
            LocalDescriptor localDescriptor = (LocalDescriptor)this.elements.elementAt(n2);
            if (this.constrainSet(this.partialType, localDescriptor.partialType)) {
                bl = true;
            }
            if (this.partialType.isInvalid() && this.usedAs.size() > 0) {
                Decompiler.report("Invalid local type tagged " + this.toString(true));
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.usedAs.size()) {
            Type type = (Type)this.usedAs.elementAt(n3);
            if (this.constrainUsed(this.partialType, type)) {
                bl = true;
            }
            if (this.partialType.isInvalid()) {
                Decompiler.report("Invalid local type used " + this.toString(true));
            }
            ++n3;
        }
        return bl;
    }

    public boolean resolvePredecessor() throws DecompilerException {
        boolean bl = false;
        if (this.resolveWith(this.lastDescriptor)) {
            bl = true;
        }
        int n = 0;
        while (n < this.elements.size()) {
            if (this.resolveWith((LocalDescriptor)this.elements.elementAt(n))) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    public void resolveTotally() throws DecompilerException {
        this.partialType.resolveAsLocal();
    }

    private boolean resolveWith(LocalDescriptor localDescriptor) throws DecompilerException {
        boolean bl = false;
        if (localDescriptor != null) {
            Type type;
            Type type2 = localDescriptor.partialType.copy();
            if (this.constrainSet(type2, type = this.partialType.copy()) && !type2.isInvalid()) {
                localDescriptor.partialType = type2;
                bl = true;
            }
            if (this.constrainSet(type, type2) && !type.isInvalid()) {
                this.partialType = type;
                bl = true;
            }
        }
        return bl;
    }

    public String toString(boolean bl) {
        String string = "Local " + this.slot + " " + this.partialType.getType() + " ";
        if (bl) {
            int n = 0;
            while (n < this.elements.size()) {
                string = String.valueOf(string) + " [" + ((LocalDescriptor)this.elements.elementAt(n)).toString(false) + "] ";
                ++n;
            }
        }
        return string;
    }

    public void usedAs(String string, int n) throws DecompilerException {
        Type type = n == 5 ? new Type(string) : new Type(n, string);
        this.usedAs.addElement(type);
    }
}

