/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.analyzer;

import org.apache.tools.analyzer.AnalyzerUtilities;
import org.apache.tools.analyzer.Decompiler;
import org.apache.tools.analyzer.DecompilerLibrary;
import org.apache.tools.analyzer.ExpandableArray;
import org.apache.tools.analyzer.UniqueVector;

public class NameMgr {
    private static UniqueVector fullNames;
    private static ExpandableArray useEasyNameFlags;
    private static UniqueVector packages;
    private static boolean fullname;
    private static boolean convert;

    private static boolean anyConflictWith(String string) {
        int n = 0;
        while (n < fullNames.size()) {
            String string2 = (String)fullNames.elementAt(n);
            if (AnalyzerUtilities.classOnlyName(string2).equals(AnalyzerUtilities.classOnlyName(string))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static boolean collisions(String string) {
        return false;
    }

    private static int contains(String string) {
        int n = 0;
        while (n < fullNames.size()) {
            if (((String)fullNames.elementAt(n)).equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private static boolean containsString(UniqueVector uniqueVector, String string) {
        int n = 0;
        while (n < uniqueVector.size()) {
            if (string.equals((String)uniqueVector.elementAt(n))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static String convert(String string, int n) {
        int n2;
        if (AnalyzerUtilities.isBasicType(string)) {
            return string;
        }
        String string2 = string;
        if (n > 1) {
            string2 = DecompilerLibrary.removeMethodOrField(string);
        }
        boolean bl = (n2 = NameMgr.contains(string2)) < 0 ? true : useEasyNameFlags.get(n2) != 1;
        String string3 = AnalyzerUtilities.classOnlyName(string);
        if (!(bl || fullname || NameMgr.collisions(string3))) {
            return string3;
        }
        return AnalyzerUtilities.makeSourceNameFromJavaName(string);
    }

    public static void dump() {
        int n = 0;
        while (n < fullNames.size()) {
            AnalyzerUtilities.p("NameMgr saw " + fullNames.elementAt(n));
            ++n;
        }
    }

    public static UniqueVector getImports() {
        String string = Decompiler.getPackageName();
        if (string == null) {
            return packages;
        }
        String string2 = AnalyzerUtilities.makeSourceNameFromJavaName(string);
        int n = 0;
        while (n < packages.size()) {
            String string3 = (String)packages.elementAt(n);
            if (string3.equals(string2)) {
                packages.removeElementAt(n);
            }
            ++n;
        }
        return packages;
    }

    public static void initialize(boolean bl, boolean bl2) {
        fullname = bl;
        convert = bl2;
        fullNames = new UniqueVector();
        packages = new UniqueVector();
        useEasyNameFlags = new ExpandableArray();
    }

    public static String useConvert(String string, int n) {
        NameMgr.using(string, n);
        return NameMgr.convert(string, n);
    }

    private static void using(String string, int n) {
        String string2 = string;
        if (n != 1) {
            string2 = DecompilerLibrary.removeMethodOrField(string);
        }
        if (NameMgr.contains(string2) < 0) {
            String string3 = AnalyzerUtilities.getPackageName(string2);
            if (string3 != null && !NameMgr.containsString(packages, string3 = AnalyzerUtilities.makeSourceNameFromJavaName(string3)) && !string3.equals("java.lang.")) {
                packages.addElement(string3);
            }
            if (NameMgr.anyConflictWith(string2)) {
                useEasyNameFlags.add(0);
            } else {
                useEasyNameFlags.add(1);
            }
            fullNames.addElement(string2);
        }
    }

    public static void usingOnly(String string, int n) {
        NameMgr.using(string, n);
    }
}

