/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.analyzer;

import java.util.Stack;
import org.apache.tools.analyzer.AnalyzerUtilities;
import org.apache.tools.analyzer.Decompiler;
import org.apache.tools.analyzer.DecompilerException;
import org.apache.tools.analyzer.DecompilerLibrary;
import org.apache.tools.analyzer.Instruction;
import org.apache.tools.analyzer.LocalDescriptor;
import org.apache.tools.analyzer.LocalVariableTable;
import org.apache.tools.analyzer.NameMgr;
import org.apache.tools.analyzer.OpcData;
import org.apache.tools.analyzer.Operand;
import org.apache.tools.analyzer.ProgramElement;
import org.apache.tools.analyzer.Statement;
import org.apache.tools.analyzer.Type;
import org.apache.tools.analyzer.UniqueVector;
import org.apache.tools.analyzer.info.ClassInfo;
import org.apache.tools.analyzer.info.LocalVariableInfo;
import org.apache.tools.analyzer.structures.Parameter;

public class StackEvaluator
implements OpcData {
    private static ClassInfo info;
    private static int iLoc;
    private static byte[] code;
    private static Stack stack;
    private static Instruction currentInstruction;
    private static String methodReturnType;
    private static final boolean debug = false;
    private static LocalVariableTable locals;
    private static Parameter[] parameterLocalArray;
    private static boolean firstPass;

    private static void __instanceof() throws DecompilerException {
        String string;
        Operand operand = (Operand)stack.pop();
        StackEvaluator.operandUsedAsJVM(operand, "Object");
        StackEvaluator.currentInstruction.constant = string = StackEvaluator.getInternalName(StackEvaluator.getConstName(StackEvaluator.iget2()));
        stack.push(new Operand("INSTANCEOF", string, operand, null, new Type("boolean"), null, currentInstruction));
    }

    private static void __new() throws DecompilerException {
        String string = StackEvaluator.nameMgr(StackEvaluator.getConstName(StackEvaluator.iget2()), 1);
        Statement statement = StackEvaluator.makeStatement("NEW", string, null, null, "MAYBE");
        stack.push(new Operand("NEW", string, null, null, new Type(string), statement, currentInstruction));
    }

    private static void addArgumentsToVector(String string, UniqueVector uniqueVector) throws DecompilerException {
        UniqueVector uniqueVector2 = DecompilerLibrary.getMethodParameterVector(string);
        int n = uniqueVector2.size() - 1;
        while (n >= 0) {
            Operand operand = (Operand)stack.pop();
            uniqueVector.addElement(operand);
            String string2 = (String)uniqueVector2.elementAt(n);
            string2 = StackEvaluator.nameMgr(string2, 1);
            if (string2 == "int") {
                StackEvaluator.operandUsedAsJVM(operand, "Number");
            } else {
                StackEvaluator.operandUsedAsExact(operand, string2);
            }
            --n;
        }
    }

    private static void arithmetic(String string, String string2) throws DecompilerException {
        String string3 = string2;
        String string4 = string2;
        if (Operand.binaryArithmeticOperator(string)) {
            Operand operand = (Operand)stack.pop();
            Operand operand2 = (Operand)stack.pop();
            if (string == "SHR" || string == "SHL" || string == "USR") {
                if (string3 == "int") {
                    string3 = "Number";
                }
                StackEvaluator.operandUsedAsJVM(operand, "Number");
                StackEvaluator.operandUsedAsJVM(operand2, string3);
                if (string4 == "int") {
                    string4 = "Number";
                }
            } else if (string == "AND" || string == "OR" || string == "XOR") {
                StackEvaluator.operandUsedAsJVM(operand, string3);
                StackEvaluator.operandUsedAsJVM(operand2, string3);
            } else {
                if (string3 == "int") {
                    string3 = "Number";
                }
                StackEvaluator.operandUsedAsJVM(operand, string3);
                StackEvaluator.operandUsedAsJVM(operand2, string3);
                if (string4 == "int") {
                    string4 = "Number";
                }
            }
            Operand operand3 = new Operand(string, null, operand, operand2, new Type(2, string4), null, currentInstruction);
            stack.push(operand3);
        } else if (string.equals("NEG")) {
            if (string3 == "int") {
                string3 = "Number";
            }
            Operand operand = (Operand)stack.pop();
            StackEvaluator.operandUsedAsJVM(operand, string3);
            if (string4 == "int") {
                string4 = "Number";
            }
            Operand operand4 = new Operand(string, null, operand, null, new Type(2, string4), null, currentInstruction);
            stack.push(operand4);
        } else {
            Decompiler.report("Arithmetic Operation not found");
        }
    }

    private static void arrayAccess(String string) throws DecompilerException {
        OpcData opcData;
        Operand operand = (Operand)stack.pop();
        StackEvaluator.operandUsedAsJVM(operand, "int");
        Operand operand2 = (Operand)stack.pop();
        StackEvaluator.operandUsedAsJVM(operand2, "Object");
        Type type = string == "byte" ? new Type(2, "int") : new Type(3, string);
        if (operand2.typeDescriptor.fullyResolved() && (opcData = operand2.typeDescriptor.arrayElementType()) != null) {
            type = opcData;
        }
        opcData = new Operand("ARRAYACCESS", null, operand, operand2, type, null, currentInstruction);
        ((ProgramElement)opcData).arrayInstructionType = string;
        stack.push(opcData);
    }

    private static void arrayLength() throws DecompilerException {
        Operand operand = (Operand)stack.pop();
        StackEvaluator.operandUsedAsJVM(operand, "Object");
        stack.push(new Operand("ARRAYLENGTH", null, operand, null, new Type("int"), null, currentInstruction));
    }

    private static void arrayStore(String string) throws DecompilerException {
        UniqueVector uniqueVector = new UniqueVector(3, 3);
        Operand operand = (Operand)stack.pop();
        if (string == "byte") {
            StackEvaluator.operandUsedAsJVM(operand, "int");
        } else {
            StackEvaluator.operandUsedAsExtended(operand, string);
        }
        uniqueVector.addElement(operand);
        Operand operand2 = (Operand)stack.pop();
        StackEvaluator.operandUsedAsJVM(operand2, "Number");
        uniqueVector.addElement(operand2);
        Operand operand3 = (Operand)stack.pop();
        StackEvaluator.operandUsedAsJVM(operand3, "Object");
        uniqueVector.addElement(operand3);
        Statement statement = StackEvaluator.makeStatement("ARRAYSTORE", null, uniqueVector, "ALWAYS");
        statement.arrayInstructionType = string;
    }

    private static void athrow() throws DecompilerException {
        Operand operand = (Operand)stack.pop();
        StackEvaluator.operandUsedAsExact(operand, "Exception");
        StackEvaluator.makeStatement("THROW", null, operand, null, "ALWAYS");
    }

    private static void check(Operand operand) throws DecompilerException {
        if (operand.type2()) {
            Decompiler.report("Invalid use of two word item on stack");
        }
    }

    private static void checkcast() throws DecompilerException {
        String string;
        StackEvaluator.currentInstruction.constant = string = StackEvaluator.getInternalName(StackEvaluator.getConstName(StackEvaluator.iget2()));
        Operand operand = (Operand)stack.pop();
        StackEvaluator.operandUsedAsJVM(operand, "Object");
        stack.push(new Operand("CAST", string, operand, null, new Type(string), null, currentInstruction));
    }

    private static void conversionTo(String string, String string2) throws DecompilerException {
        Operand operand = (Operand)stack.pop();
        StackEvaluator.operandUsedAsJVM(operand, string);
        Operand operand2 = new Operand("CONVERSION", string2, operand, null, new Type(3, string2), null, currentInstruction);
        stack.push(operand2);
    }

    private static void doReturn(String string) throws DecompilerException {
        if (string != "void") {
            Operand operand = (Operand)stack.pop();
            StackEvaluator.operandUsedAsExact(operand, methodReturnType);
            StackEvaluator.makeStatement("RETURN", methodReturnType, operand, null, "ALWAYS");
        } else {
            StackEvaluator.makeStatement("RETURN", null, null, null, "ALWAYS");
        }
    }

    private static Integer get1() {
        return new Integer(DecompilerLibrary.getOneByte(code, iLoc + 1));
    }

    private static Integer get1s() {
        return new Integer(DecompilerLibrary.getOneByteSigned(code, iLoc + 1));
    }

    private static Integer get2() {
        return new Integer(DecompilerLibrary.getTwoByte(code, iLoc + 1));
    }

    private static Integer get2s() {
        return new Integer(DecompilerLibrary.getTwoByteSigned(code, iLoc + 1));
    }

    private static Object getConst(int n) throws DecompilerException {
        Object object = info.getConstant(n);
        if (object == null) {
            Decompiler.report("Invalid constant in constant pool");
            return new Integer(0);
        }
        return object;
    }

    private static String getConstName(int n) throws DecompilerException {
        String string = info.getConstantName(n);
        if (string == null) {
            Decompiler.report("Invalid constant name in constant pool");
            return "unknownName";
        }
        return string;
    }

    private static LocalDescriptor getDescriptorInGenInsSlot(int n, Instruction instruction) {
        LocalVariableTable localVariableTable = instruction == currentInstruction ? locals : instruction.localTable;
        return localVariableTable.getSlot(n);
    }

    private static void getField(boolean bl) throws DecompilerException {
        Operand operand;
        String string = StackEvaluator.getConstName(StackEvaluator.iget2());
        String string2 = StackEvaluator.nameMgr(StackEvaluator.getFieldName(string), 3);
        String string3 = StackEvaluator.nameMgr(StackEvaluator.getFieldType(string), 1);
        StackEvaluator.currentInstruction.constant = string;
        if (bl) {
            operand = (Operand)stack.pop();
            StackEvaluator.operandUsedAsExact(operand, DecompilerLibrary.removeMethodOrField(string2));
        } else {
            operand = null;
        }
        Operand operand2 = new Operand(bl ? "GETVIRTUAL" : "GETSTATIC", string2, operand, null, new Type(string3), null, currentInstruction);
        stack.push(operand2);
    }

    private static String getFieldName(String string) {
        return string.substring(0, string.indexOf(":"));
    }

    private static String getFieldType(String string) {
        int n = string.indexOf(":");
        if (n >= 0) {
            String string2 = string.substring(n + 1, string.length());
            return AnalyzerUtilities.getFieldType(string2);
        }
        return "UnknownFieldType";
    }

    private static String getInternalName(String string) {
        if (string.charAt(0) == '[') {
            return AnalyzerUtilities.getFieldType(string);
        }
        return string;
    }

    private static String getMethodName(String string) {
        return string.substring(0, string.indexOf(":"));
    }

    private static String getMethodType(String string) {
        int n = string.indexOf(":");
        if (n >= 0) {
            String string2 = string.substring(n + 1, string.length());
            return AnalyzerUtilities.getMethodType(string2);
        }
        return "UnknownMethodType";
    }

    public static int getSlotOfLocal(Operand operand) {
        int n;
        if (operand.oper == "GETLOCAL" && Decompiler.isLocal(n = ((Integer)operand.constantOrName).intValue())) {
            return n;
        }
        return -1;
    }

    private static String getStringType(int n) throws DecompilerException {
        String string;
        switch (n) {
            case 4: {
                string = "boolean";
                break;
            }
            case 5: {
                string = "char";
                break;
            }
            case 6: {
                string = "float";
                break;
            }
            case 7: {
                string = "double";
                break;
            }
            case 8: {
                string = "byte";
                break;
            }
            case 9: {
                string = "short";
                break;
            }
            case 10: {
                string = "int";
                break;
            }
            case 11: {
                string = "long";
                break;
            }
            default: {
                Decompiler.report("Invalid type information in class file");
                return "unknownType";
            }
        }
        return string;
    }

    private static void ifBranch(String string) throws DecompilerException {
        Operand operand = (Operand)stack.pop();
        String string2 = "int";
        StackEvaluator.operandUsedAsJVM(operand, string2);
        Operand operand2 = new Operand("CONSTANT", "Zero", null, null, new Type(11, null), null, currentInstruction);
        Operand operand3 = new Operand(string, null, operand2, operand, new Type("boolean"), null, currentInstruction);
        if (StackEvaluator.currentInstruction.type == "CONDBRANCH") {
            StackEvaluator.makeStatement("IF", null, operand3, null, "ALWAYS");
        }
    }

    private static void ifBranchCompareNull(String string) throws DecompilerException {
        Operand operand = (Operand)stack.pop();
        StackEvaluator.operandUsedAsJVM(operand, "Object");
        Operand operand2 = new Operand("null", null, null, null, new Type(2, "Object"), null, currentInstruction);
        Operand operand3 = new Operand(string, null, operand, operand2, new Type("boolean"), null, currentInstruction);
        if (StackEvaluator.currentInstruction.type == "CONDBRANCH") {
            StackEvaluator.makeStatement("IF", null, operand3, null, "ALWAYS");
        }
    }

    private static void ifBranchWithCompare(String string, String string2) throws DecompilerException {
        Operand operand = (Operand)stack.pop();
        Operand operand2 = (Operand)stack.pop();
        if (string == "int") {
            if (operand.oper == "CONSTANT" && !DecompilerLibrary.zeroOrOne(operand)) {
                string = "Number";
            }
            if (operand2.oper == "CONSTANT" && !DecompilerLibrary.zeroOrOne(operand2)) {
                string = "Number";
            }
            if (string2 != "EQ" && string2 != "NE") {
                string = "Number";
            }
        }
        StackEvaluator.operandUsedAsJVM(operand, string);
        StackEvaluator.operandUsedAsJVM(operand2, string);
        Operand operand3 = new Operand(string2, null, operand, operand2, new Type("boolean"), null, currentInstruction);
        if (StackEvaluator.currentInstruction.type == "CONDBRANCH") {
            StackEvaluator.makeStatement("IF", null, operand3, null, "ALWAYS");
        }
    }

    private static int iget1() {
        return DecompilerLibrary.getOneByte(code, iLoc + 1);
    }

    private static int iget1_3() {
        return DecompilerLibrary.getOneByte(code, iLoc + 3);
    }

    private static int iget1s() {
        return DecompilerLibrary.getOneByteSigned(code, iLoc + 1);
    }

    private static int iget1s(int n) {
        return DecompilerLibrary.getOneByteSigned(code, iLoc + n);
    }

    private static int iget2() {
        return DecompilerLibrary.getTwoByte(code, iLoc + 1);
    }

    private static int iget2s() {
        return DecompilerLibrary.getTwoByteSigned(code, iLoc + 1);
    }

    private static int iget2s(int n) {
        return DecompilerLibrary.getTwoByteSigned(code, iLoc + n);
    }

    private static void increment(boolean bl) throws DecompilerException {
        int n;
        int n2;
        if (bl) {
            n2 = StackEvaluator.iget2();
            n = StackEvaluator.iget2s(3);
        } else {
            n2 = StackEvaluator.iget1();
            n = StackEvaluator.iget1s(2);
        }
        if (firstPass) {
            StackEvaluator.saveStaleLocal(n2);
        }
        Operand operand = new Operand("CONSTANT", new Integer(n), null, null, new Type(2, "Number"), null, currentInstruction);
        StackEvaluator.makeStatement("INCREMENT", new Integer(n2), operand, null, "ALWAYS");
        StackEvaluator.use(n2, "Number", 2, currentInstruction);
    }

    private static void infloop() throws DecompilerException {
        StackEvaluator.makeStatement("INFINITELOOP", null, null, null, "ALWAYS");
    }

    private static void invoke(boolean bl) throws DecompilerException {
        Statement statement;
        Object object;
        Object object2;
        String string = StackEvaluator.getConstName(StackEvaluator.iget2());
        String string2 = StackEvaluator.nameMgr(StackEvaluator.getMethodName(string), 2);
        UniqueVector uniqueVector = DecompilerLibrary.getMethodParameterVector(string);
        StackEvaluator.currentInstruction.constant = string;
        UniqueVector uniqueVector2 = new UniqueVector(3, 3);
        StackEvaluator.addArgumentsToVector(string, uniqueVector2);
        if (bl) {
            object2 = (Operand)stack.pop();
            StackEvaluator.operandUsedAsExact((Operand)object2, DecompilerLibrary.removeMethodOrField(string2));
            if (((ProgramElement)object2).oper == "NEW" && !DecompilerLibrary.removeClass(string2).equals("<init>")) {
                Decompiler.report("Invalid method name for init of new object");
            }
            if (((ProgramElement)object2).oper == "NEW") {
                StackEvaluator.verifyNames((Operand)object2, string2);
                ((Operand)object2).setNewInitialize(uniqueVector2, uniqueVector);
                ((Operand)object2).statement.setNewInitialize(uniqueVector2, uniqueVector);
                return;
            }
            if (DecompilerLibrary.removeClass(string2).equals("<init>") && !((Operand)object2).isThis()) {
                object = ((Operand)object2).last;
                if (((ProgramElement)object2).oper == "GETLOCAL" && object != null && ((ProgramElement)object).oper == "NEW") {
                    StackEvaluator.verifyNames((Operand)object, string2);
                    ((Operand)object).setNewInitialize(uniqueVector2, uniqueVector);
                    ((Operand)object).statement.setNewInitialize(uniqueVector2, uniqueVector);
                    return;
                }
                uniqueVector2.addElement(object2);
            } else {
                uniqueVector2.addElement(object2);
            }
        }
        object2 = StackEvaluator.nameMgr(StackEvaluator.getMethodType(string), 1);
        Object object3 = object = bl ? "INVOKEVIRTUAL" : "INVOKESTATIC";
        if (!((String)object2).equals("void")) {
            statement = StackEvaluator.makeStatement((String)object, string2, uniqueVector2, "MAYBE");
            Operand operand = new Operand((String)object, string2, uniqueVector2, new Type((String)object2), statement, currentInstruction);
            operand.argTypeVector = uniqueVector;
            statement.argTypeVector = uniqueVector;
            stack.push(operand);
        } else {
            statement = StackEvaluator.makeStatement((String)object, string2, uniqueVector2, "ALWAYS");
            statement.argTypeVector = uniqueVector;
        }
        statement.fullMethodName = DecompilerLibrary.removeClass(string);
    }

    private static int isConstantPlusMinusOne(Operand operand) {
        int n;
        Object object;
        if (operand.oper == "CONSTANT" && (object = operand.constantOrName) instanceof Number && ((n = ((Number)object).intValue()) == 1 || n == -1)) {
            return n;
        }
        return 0;
    }

    private static Statement makeStatement(String string, Object object, Operand operand, Operand operand2, String string2) throws DecompilerException {
        Statement statement;
        StackEvaluator.currentInstruction.statement = statement = new Statement(string, object, operand, operand2, string2, currentInstruction);
        return statement;
    }

    private static Statement makeStatement(String string, Object object, UniqueVector uniqueVector, String string2) throws DecompilerException {
        Statement statement;
        StackEvaluator.currentInstruction.statement = statement = new Statement(string, object, uniqueVector, string2, currentInstruction);
        return statement;
    }

    private static void monitor(boolean bl) throws DecompilerException {
        Operand operand = (Operand)stack.pop();
        StackEvaluator.operandUsedAsJVM(operand, "Object");
        StackEvaluator.makeStatement("MONITOR", new Boolean(bl), operand, null, "ALWAYS");
    }

    private static void multiBranch() throws DecompilerException {
        Operand operand = (Operand)stack.pop();
        StackEvaluator.operandUsedAsExact(operand, "int");
        StackEvaluator.makeStatement("SWITCH", null, operand, null, "ALWAYS");
    }

    private static String nameMgr(String string, int n) throws DecompilerException {
        NameMgr.usingOnly(string, n);
        return string;
    }

    private static void newArray(String string, int n) throws DecompilerException {
        ProgramElement programElement;
        UniqueVector uniqueVector = new UniqueVector(1, 1);
        int n2 = 0;
        while (n2 < n) {
            programElement = (Operand)stack.pop();
            StackEvaluator.operandUsedAsJVM(programElement, "int");
            StackEvaluator.operandUsedAsJVM(programElement, "Number");
            uniqueVector.addElement(programElement);
            ++n2;
        }
        programElement = StackEvaluator.makeStatement("NEWARRAY", string, uniqueVector, "MAYBE");
        Operand operand = new Operand("NEWARRAY", string, uniqueVector, new Type(string), (Statement)programElement, currentInstruction);
        stack.push(operand);
    }

    private static int operandOneDiffFromOperand(Operand operand, Operand operand2) throws DecompilerException {
        if (operand.oper == "ADD" || operand.oper == "SUB") {
            Operand operand3 = operand.get(0);
            Operand operand4 = operand.get(1);
            Operand operand5 = null;
            int n = 0;
            n = StackEvaluator.isConstantPlusMinusOne(operand3);
            if (n != 0) {
                operand5 = operand4;
            } else {
                n = StackEvaluator.isConstantPlusMinusOne(operand4);
                if (n != 0 && operand.oper == "ADD") {
                    operand5 = operand3;
                }
            }
            if (operand5 != null) {
                if (operand.oper == "SUB") {
                    n *= -1;
                }
                if (StackEvaluator.sameRef(operand5, operand2)) {
                    return n;
                }
            }
        }
        return 0;
    }

    private static void operandUsedAsExact(Operand operand, String string) throws DecompilerException {
        StackEvaluator.usedAs(operand, string, 5);
    }

    private static void operandUsedAsExtended(Operand operand, String string) throws DecompilerException {
        StackEvaluator.usedAs(operand, string, 3);
    }

    private static void operandUsedAsJVM(Operand operand, String string) throws DecompilerException {
        StackEvaluator.usedAs(operand, string, 2);
    }

    private static void pushConstant(Object object, String string) throws DecompilerException {
        Type type;
        StackEvaluator.currentInstruction.constant = object.toString();
        if (string == null) {
            String string2 = DecompilerLibrary.getType(object);
            type = new Type(3, string2);
        } else {
            type = new Type(2, string);
        }
        stack.push(new Operand("CONSTANT", object, null, null, type, null, currentInstruction));
    }

    private static void pushLocal(int n, String string) throws DecompilerException {
        Type type;
        StackEvaluator.currentInstruction.constant = String.valueOf(n);
        if (!Decompiler.isLocal(n)) {
            type = new Type(Decompiler.getParameterType(n));
        } else {
            type = new Type(2, string);
            LocalDescriptor localDescriptor = locals.getSlot(n);
            if (localDescriptor == null) {
                Decompiler.report("Local variable used before being set");
                LocalDescriptor localDescriptor2 = new LocalDescriptor(null, string, n, type, currentInstruction);
                LocalVariableInfo.set(localDescriptor2, currentInstruction, string);
                locals.setAtSlot(localDescriptor2, n);
            }
        }
        stack.push(new Operand("GETLOCAL", new Integer(n), null, null, type, null, currentInstruction));
    }

    private static void pushNull() throws DecompilerException {
        stack.push(new Operand("null", null, null, null, new Type(2, "Object"), null, currentInstruction));
    }

    private static void putField(boolean bl) throws DecompilerException {
        Operand operand;
        String string = StackEvaluator.getConstName(StackEvaluator.iget2());
        String string2 = StackEvaluator.nameMgr(StackEvaluator.getFieldName(string), 3);
        String string3 = StackEvaluator.nameMgr(StackEvaluator.getFieldType(string), 1);
        StackEvaluator.currentInstruction.constant = string;
        Operand operand2 = (Operand)stack.pop();
        StackEvaluator.operandUsedAsExact(operand2, string3);
        if (bl) {
            operand = (Operand)stack.pop();
            StackEvaluator.operandUsedAsExact(operand, DecompilerLibrary.removeMethodOrField(string2));
        } else {
            operand = null;
        }
        if (firstPass) {
            StackEvaluator.saveStaleField(string2);
        }
        Statement statement = StackEvaluator.makeStatement(bl ? "PUTVIRTUAL" : "PUTSTATIC", string2, operand2, operand, "ALWAYS");
        statement.fieldType = string3;
    }

    private static boolean sameRef(Operand operand, Operand operand2) {
        return operand == operand2;
    }

    private static void saveStaleField(String string) throws DecompilerException {
        int n = 0;
        while (n < stack.size()) {
            Operand operand = (Operand)stack.get(n);
            operand.saveStaleField(string);
            ++n;
        }
    }

    private static void saveStaleLocal(int n) throws DecompilerException {
        int n2 = 0;
        while (n2 < stack.size()) {
            Operand operand = (Operand)stack.get(n2);
            operand.saveStaleLocal(n);
            ++n2;
        }
    }

    private static String sourceName(String string) {
        string = string.substring(0, string.indexOf(":"));
        return AnalyzerUtilities.classOnlyName(string);
    }

    private static void storeGeneratedLocalAndPush(int n) throws DecompilerException {
        LocalDescriptor localDescriptor;
        Object object;
        Operand operand = (Operand)stack.pop();
        String string = operand.typeDescriptor.getBaseType();
        if (string == "int" && operand.oper == "CONSTANT" && !DecompilerLibrary.zeroOrOne(operand)) {
            string = "Number";
        }
        StackEvaluator.operandUsedAsJVM(operand, string);
        int n2 = StackEvaluator.getSlotOfLocal(operand);
        if (n2 >= 0) {
            object = StackEvaluator.getDescriptorInGenInsSlot(n2, operand.genInstruction);
            localDescriptor = new LocalDescriptor(null, string, n, (LocalDescriptor)object, currentInstruction);
            if (object == null) {
                throw new DecompilerException(10131);
            }
            ((LocalDescriptor)object).localsThatIFill.addElement(localDescriptor);
        } else {
            localDescriptor = new LocalDescriptor(null, string, n, operand.typeDescriptor, currentInstruction);
        }
        LocalVariableInfo.set(localDescriptor, currentInstruction, operand.oper);
        locals.setAtSlot(localDescriptor, n);
        object = new Type(2, string);
        Operand operand2 = new Operand("GETLOCAL", new Integer(n), null, null, (Type)object, null, currentInstruction);
        operand2.last = operand;
        stack.push(operand2);
    }

    private static void storeLocal(int n, String string) throws DecompilerException {
        Operand operand = (Operand)stack.pop();
        if (string == "int" && operand.oper == "CONSTANT" && !DecompilerLibrary.zeroOrOne(operand)) {
            string = "Number";
        }
        if (firstPass) {
            StackEvaluator.saveStaleLocal(n);
        }
        StackEvaluator.makeStatement("PUTLOCAL", new Integer(n), operand, null, "ALWAYS");
        StackEvaluator.operandUsedAsJVM(operand, string);
        if (Decompiler.isLocal(n)) {
            LocalDescriptor localDescriptor;
            LocalDescriptor localDescriptor2 = locals.getSlot(n);
            int n2 = StackEvaluator.getSlotOfLocal(operand);
            if (n2 >= 0) {
                LocalDescriptor localDescriptor3 = operand.genInstruction.localTable.getSlot(n2);
                localDescriptor = new LocalDescriptor(localDescriptor2, string, n, localDescriptor3, currentInstruction);
                if (localDescriptor3 == null) {
                    throw new DecompilerException(10101);
                }
                localDescriptor3.localsThatIFill.addElement(localDescriptor);
            } else {
                localDescriptor = new LocalDescriptor(localDescriptor2, string, n, operand.typeDescriptor, currentInstruction);
            }
            LocalVariableInfo.set(localDescriptor, currentInstruction, operand.oper);
            locals.setAtSlot(localDescriptor, n);
        } else {
            StackEvaluator.operandUsedAsExact(operand, Decompiler.getParameterType(n));
        }
    }

    public static UniqueVector updateStack(byte[] byArray, int n, Stack stack, Instruction instruction, ClassInfo classInfo, String string, LocalVariableTable localVariableTable, Parameter[] parameterArray, boolean bl) throws DecompilerException {
        currentInstruction = instruction;
        info = classInfo;
        code = byArray;
        methodReturnType = string;
        StackEvaluator.stack = stack;
        iLoc = instruction.location;
        locals = localVariableTable;
        parameterLocalArray = parameterArray;
        firstPass = bl;
        int n2 = instruction.opcode;
        boolean bl2 = instruction.wide;
        switch (instruction.opcode) {
            case 1: {
                StackEvaluator.pushNull();
                break;
            }
            case 2: {
                StackEvaluator.pushConstant(new Integer(-1), "int");
                break;
            }
            case 3: {
                StackEvaluator.pushConstant(new Integer(0), "int");
                break;
            }
            case 4: {
                StackEvaluator.pushConstant(new Integer(1), "int");
                break;
            }
            case 5: {
                StackEvaluator.pushConstant(new Integer(2), "int");
                break;
            }
            case 6: {
                StackEvaluator.pushConstant(new Integer(3), "int");
                break;
            }
            case 7: {
                StackEvaluator.pushConstant(new Integer(4), "int");
                break;
            }
            case 8: {
                StackEvaluator.pushConstant(new Integer(5), "int");
                break;
            }
            case 9: {
                StackEvaluator.pushConstant(new Long(0L), "long");
                break;
            }
            case 10: {
                StackEvaluator.pushConstant(new Long(1L), "long");
                break;
            }
            case 11: {
                StackEvaluator.pushConstant(new Float(0.0f), "float");
                break;
            }
            case 12: {
                StackEvaluator.pushConstant(new Float(1.0f), "float");
                break;
            }
            case 13: {
                StackEvaluator.pushConstant(new Float(2.0f), "float");
                break;
            }
            case 14: {
                StackEvaluator.pushConstant(new Double(0.0), "double");
                break;
            }
            case 15: {
                StackEvaluator.pushConstant(new Double(1.0), "double");
                break;
            }
            case 16: {
                StackEvaluator.pushConstant(StackEvaluator.get1s(), "int");
                break;
            }
            case 17: {
                StackEvaluator.pushConstant(StackEvaluator.get2s(), "int");
                break;
            }
            case 18: {
                StackEvaluator.pushConstant(StackEvaluator.getConst(StackEvaluator.iget1()), null);
                break;
            }
            case 19: {
                StackEvaluator.pushConstant(StackEvaluator.getConst(StackEvaluator.iget2()), null);
                break;
            }
            case 20: {
                StackEvaluator.pushConstant(StackEvaluator.getConst(StackEvaluator.iget2()), null);
                break;
            }
            case 21: {
                StackEvaluator.pushLocal(bl2 ? StackEvaluator.iget2() : StackEvaluator.iget1(), "int");
                break;
            }
            case 22: {
                StackEvaluator.pushLocal(bl2 ? StackEvaluator.iget2() : StackEvaluator.iget1(), "long");
                break;
            }
            case 23: {
                StackEvaluator.pushLocal(bl2 ? StackEvaluator.iget2() : StackEvaluator.iget1(), "float");
                break;
            }
            case 24: {
                StackEvaluator.pushLocal(bl2 ? StackEvaluator.iget2() : StackEvaluator.iget1(), "double");
                break;
            }
            case 25: {
                StackEvaluator.pushLocal(bl2 ? StackEvaluator.iget2() : StackEvaluator.iget1(), "Object");
                break;
            }
            case 26: {
                StackEvaluator.pushLocal(0, "int");
                break;
            }
            case 27: {
                StackEvaluator.pushLocal(1, "int");
                break;
            }
            case 28: {
                StackEvaluator.pushLocal(2, "int");
                break;
            }
            case 29: {
                StackEvaluator.pushLocal(3, "int");
                break;
            }
            case 30: {
                StackEvaluator.pushLocal(0, "long");
                break;
            }
            case 31: {
                StackEvaluator.pushLocal(1, "long");
                break;
            }
            case 32: {
                StackEvaluator.pushLocal(2, "long");
                break;
            }
            case 33: {
                StackEvaluator.pushLocal(3, "long");
                break;
            }
            case 34: {
                StackEvaluator.pushLocal(0, "float");
                break;
            }
            case 35: {
                StackEvaluator.pushLocal(1, "float");
                break;
            }
            case 36: {
                StackEvaluator.pushLocal(2, "float");
                break;
            }
            case 37: {
                StackEvaluator.pushLocal(3, "float");
                break;
            }
            case 38: {
                StackEvaluator.pushLocal(0, "double");
                break;
            }
            case 39: {
                StackEvaluator.pushLocal(1, "double");
                break;
            }
            case 40: {
                StackEvaluator.pushLocal(2, "double");
                break;
            }
            case 41: {
                StackEvaluator.pushLocal(3, "double");
                break;
            }
            case 42: {
                StackEvaluator.pushLocal(0, "Object");
                break;
            }
            case 43: {
                StackEvaluator.pushLocal(1, "Object");
                break;
            }
            case 44: {
                StackEvaluator.pushLocal(2, "Object");
                break;
            }
            case 45: {
                StackEvaluator.pushLocal(3, "Object");
                break;
            }
            case 46: {
                StackEvaluator.arrayAccess("int");
                break;
            }
            case 47: {
                StackEvaluator.arrayAccess("long");
                break;
            }
            case 48: {
                StackEvaluator.arrayAccess("float");
                break;
            }
            case 49: {
                StackEvaluator.arrayAccess("double");
                break;
            }
            case 50: {
                StackEvaluator.arrayAccess("Object");
                break;
            }
            case 51: {
                StackEvaluator.arrayAccess("byte");
                break;
            }
            case 52: {
                StackEvaluator.arrayAccess("char");
                break;
            }
            case 53: {
                StackEvaluator.arrayAccess("short");
                break;
            }
            case 54: {
                StackEvaluator.storeLocal(bl2 ? StackEvaluator.iget2() : StackEvaluator.iget1(), "int");
                break;
            }
            case 55: {
                StackEvaluator.storeLocal(bl2 ? StackEvaluator.iget2() : StackEvaluator.iget1(), "long");
                break;
            }
            case 56: {
                StackEvaluator.storeLocal(bl2 ? StackEvaluator.iget2() : StackEvaluator.iget1(), "float");
                break;
            }
            case 57: {
                StackEvaluator.storeLocal(bl2 ? StackEvaluator.iget2() : StackEvaluator.iget1(), "double");
                break;
            }
            case 58: {
                StackEvaluator.storeLocal(bl2 ? StackEvaluator.iget2() : StackEvaluator.iget1(), "Object");
                break;
            }
            case 59: {
                StackEvaluator.storeLocal(0, "int");
                break;
            }
            case 60: {
                StackEvaluator.storeLocal(1, "int");
                break;
            }
            case 61: {
                StackEvaluator.storeLocal(2, "int");
                break;
            }
            case 62: {
                StackEvaluator.storeLocal(3, "int");
                break;
            }
            case 63: {
                StackEvaluator.storeLocal(0, "long");
                break;
            }
            case 64: {
                StackEvaluator.storeLocal(1, "long");
                break;
            }
            case 65: {
                StackEvaluator.storeLocal(2, "long");
                break;
            }
            case 66: {
                StackEvaluator.storeLocal(3, "long");
                break;
            }
            case 67: {
                StackEvaluator.storeLocal(0, "float");
                break;
            }
            case 68: {
                StackEvaluator.storeLocal(1, "float");
                break;
            }
            case 69: {
                StackEvaluator.storeLocal(2, "float");
                break;
            }
            case 70: {
                StackEvaluator.storeLocal(3, "float");
                break;
            }
            case 71: {
                StackEvaluator.storeLocal(0, "double");
                break;
            }
            case 72: {
                StackEvaluator.storeLocal(1, "double");
                break;
            }
            case 73: {
                StackEvaluator.storeLocal(2, "double");
                break;
            }
            case 74: {
                StackEvaluator.storeLocal(3, "double");
                break;
            }
            case 75: {
                StackEvaluator.storeLocal(0, "Object");
                break;
            }
            case 76: {
                StackEvaluator.storeLocal(1, "Object");
                break;
            }
            case 77: {
                StackEvaluator.storeLocal(2, "Object");
                break;
            }
            case 78: {
                StackEvaluator.storeLocal(3, "Object");
                break;
            }
            case 79: {
                StackEvaluator.arrayStore("int");
                break;
            }
            case 80: {
                StackEvaluator.arrayStore("long");
                break;
            }
            case 81: {
                StackEvaluator.arrayStore("float");
                break;
            }
            case 82: {
                StackEvaluator.arrayStore("double");
                break;
            }
            case 83: {
                StackEvaluator.arrayStore("Object");
                break;
            }
            case 84: {
                StackEvaluator.arrayStore("byte");
                break;
            }
            case 85: {
                StackEvaluator.arrayStore("char");
                break;
            }
            case 86: {
                StackEvaluator.arrayStore("short");
                break;
            }
            case 87: {
                Operand operand = (Operand)StackEvaluator.stack.get(0);
                StackEvaluator.check(operand);
                StackEvaluator.stack.pop();
                break;
            }
            case 88: {
                Operand operand = (Operand)StackEvaluator.stack.get(0);
                if (operand.type2()) {
                    StackEvaluator.stack.pop();
                    break;
                }
                StackEvaluator.stack.pop();
                StackEvaluator.stack.pop();
                break;
            }
            case 89: {
                Operand operand = (Operand)StackEvaluator.stack.get(0);
                StackEvaluator.check(operand);
                Operand operand2 = (Operand)StackEvaluator.stack.pop();
                StackEvaluator.stack.push(operand2);
                StackEvaluator.stack.push(operand2);
                break;
            }
            case 90: {
                Operand operand = (Operand)StackEvaluator.stack.pop();
                StackEvaluator.check(operand);
                Operand operand3 = (Operand)StackEvaluator.stack.pop();
                StackEvaluator.check(operand3);
                StackEvaluator.stack.push(operand);
                StackEvaluator.stack.push(operand3);
                StackEvaluator.stack.push(operand);
                break;
            }
            case 91: {
                Operand operand = (Operand)StackEvaluator.stack.pop();
                StackEvaluator.check(operand);
                Operand operand4 = (Operand)StackEvaluator.stack.pop();
                if (operand4.type2()) {
                    StackEvaluator.stack.push(operand);
                    StackEvaluator.stack.push(operand4);
                    StackEvaluator.stack.push(operand);
                    break;
                }
                Operand operand5 = (Operand)StackEvaluator.stack.pop();
                StackEvaluator.check(operand5);
                StackEvaluator.stack.push(operand);
                StackEvaluator.stack.push(operand5);
                StackEvaluator.stack.push(operand4);
                StackEvaluator.stack.push(operand);
                break;
            }
            case 92: {
                Operand operand = (Operand)StackEvaluator.stack.pop();
                if (operand.type2()) {
                    StackEvaluator.stack.push(operand);
                    StackEvaluator.stack.push(operand);
                    break;
                }
                Operand operand6 = (Operand)StackEvaluator.stack.pop();
                StackEvaluator.check(operand6);
                StackEvaluator.stack.push(operand6);
                StackEvaluator.stack.push(operand);
                StackEvaluator.stack.push(operand6);
                StackEvaluator.stack.push(operand);
                break;
            }
            case 93: {
                Operand operand = (Operand)StackEvaluator.stack.pop();
                if (operand.type2()) {
                    Operand operand7 = (Operand)StackEvaluator.stack.pop();
                    StackEvaluator.check(operand7);
                    StackEvaluator.stack.push(operand);
                    StackEvaluator.stack.push(operand7);
                    StackEvaluator.stack.push(operand);
                    break;
                }
                Operand operand8 = (Operand)StackEvaluator.stack.pop();
                StackEvaluator.check(operand8);
                Operand operand9 = (Operand)StackEvaluator.stack.pop();
                StackEvaluator.check(operand9);
                StackEvaluator.stack.push(operand8);
                StackEvaluator.stack.push(operand);
                StackEvaluator.stack.push(operand9);
                StackEvaluator.stack.push(operand8);
                StackEvaluator.stack.push(operand);
                break;
            }
            case 94: {
                Operand operand = (Operand)StackEvaluator.stack.pop();
                Operand operand10 = (Operand)StackEvaluator.stack.pop();
                if (operand.type2() && operand10.type2()) {
                    StackEvaluator.stack.push(operand);
                    StackEvaluator.stack.push(operand10);
                    StackEvaluator.stack.push(operand);
                    break;
                }
                if (operand.type2() && !operand10.type2()) {
                    Operand operand11 = (Operand)StackEvaluator.stack.pop();
                    StackEvaluator.check(operand11);
                    StackEvaluator.stack.push(operand);
                    StackEvaluator.stack.push(operand11);
                    StackEvaluator.stack.push(operand10);
                    StackEvaluator.stack.push(operand);
                    break;
                }
                if (!operand.type2() && !operand10.type2()) {
                    Operand operand12 = (Operand)StackEvaluator.stack.pop();
                    if (!operand12.type2()) {
                        Operand operand13 = (Operand)StackEvaluator.stack.pop();
                        StackEvaluator.check(operand13);
                        StackEvaluator.stack.push(operand10);
                        StackEvaluator.stack.push(operand);
                        StackEvaluator.stack.push(operand13);
                        StackEvaluator.stack.push(operand12);
                        StackEvaluator.stack.push(operand10);
                        StackEvaluator.stack.push(operand);
                        break;
                    }
                    StackEvaluator.stack.push(operand10);
                    StackEvaluator.stack.push(operand);
                    StackEvaluator.stack.push(operand12);
                    StackEvaluator.stack.push(operand10);
                    StackEvaluator.stack.push(operand);
                    break;
                }
                Operand operand14 = (Operand)StackEvaluator.stack.pop();
                StackEvaluator.check(operand14);
                StackEvaluator.stack.push(operand);
                StackEvaluator.stack.push(operand14);
                StackEvaluator.stack.push(operand10);
                StackEvaluator.stack.push(operand);
                break;
            }
            case 95: {
                Operand operand = (Operand)StackEvaluator.stack.pop();
                StackEvaluator.check(operand);
                Operand operand15 = (Operand)StackEvaluator.stack.pop();
                StackEvaluator.check(operand15);
                StackEvaluator.stack.push(operand);
                StackEvaluator.stack.push(operand15);
                break;
            }
            case 96: {
                StackEvaluator.arithmetic("ADD", "int");
                break;
            }
            case 97: {
                StackEvaluator.arithmetic("ADD", "long");
                break;
            }
            case 98: {
                StackEvaluator.arithmetic("ADD", "float");
                break;
            }
            case 99: {
                StackEvaluator.arithmetic("ADD", "double");
                break;
            }
            case 100: {
                StackEvaluator.arithmetic("SUB", "int");
                break;
            }
            case 101: {
                StackEvaluator.arithmetic("SUB", "long");
                break;
            }
            case 102: {
                StackEvaluator.arithmetic("SUB", "float");
                break;
            }
            case 103: {
                StackEvaluator.arithmetic("SUB", "double");
                break;
            }
            case 104: {
                StackEvaluator.arithmetic("MUL", "int");
                break;
            }
            case 105: {
                StackEvaluator.arithmetic("MUL", "long");
                break;
            }
            case 106: {
                StackEvaluator.arithmetic("MUL", "float");
                break;
            }
            case 107: {
                StackEvaluator.arithmetic("MUL", "double");
                break;
            }
            case 108: {
                StackEvaluator.arithmetic("DIV", "int");
                break;
            }
            case 109: {
                StackEvaluator.arithmetic("DIV", "long");
                break;
            }
            case 110: {
                StackEvaluator.arithmetic("DIV", "float");
                break;
            }
            case 111: {
                StackEvaluator.arithmetic("DIV", "double");
                break;
            }
            case 112: {
                StackEvaluator.arithmetic("REM", "int");
                break;
            }
            case 113: {
                StackEvaluator.arithmetic("REM", "long");
                break;
            }
            case 114: {
                StackEvaluator.arithmetic("REM", "float");
                break;
            }
            case 115: {
                StackEvaluator.arithmetic("REM", "double");
                break;
            }
            case 116: {
                StackEvaluator.arithmetic("NEG", "int");
                break;
            }
            case 117: {
                StackEvaluator.arithmetic("NEG", "long");
                break;
            }
            case 118: {
                StackEvaluator.arithmetic("NEG", "float");
                break;
            }
            case 119: {
                StackEvaluator.arithmetic("NEG", "double");
                break;
            }
            case 120: {
                StackEvaluator.arithmetic("SHL", "int");
                break;
            }
            case 121: {
                StackEvaluator.arithmetic("SHL", "long");
                break;
            }
            case 122: {
                StackEvaluator.arithmetic("SHR", "int");
                break;
            }
            case 123: {
                StackEvaluator.arithmetic("SHR", "long");
                break;
            }
            case 124: {
                StackEvaluator.arithmetic("USR", "int");
                break;
            }
            case 125: {
                StackEvaluator.arithmetic("USR", "long");
                break;
            }
            case 126: {
                StackEvaluator.arithmetic("AND", "int");
                break;
            }
            case 127: {
                StackEvaluator.arithmetic("AND", "long");
                break;
            }
            case 128: {
                StackEvaluator.arithmetic("OR", "int");
                break;
            }
            case 129: {
                StackEvaluator.arithmetic("OR", "long");
                break;
            }
            case 130: {
                StackEvaluator.arithmetic("XOR", "int");
                break;
            }
            case 131: {
                StackEvaluator.arithmetic("XOR", "long");
                break;
            }
            case 132: {
                StackEvaluator.increment(bl2);
                break;
            }
            case 133: {
                StackEvaluator.conversionTo("int", "long");
                break;
            }
            case 134: {
                StackEvaluator.conversionTo("int", "float");
                break;
            }
            case 135: {
                StackEvaluator.conversionTo("int", "double");
                break;
            }
            case 136: {
                StackEvaluator.conversionTo("long", "int");
                break;
            }
            case 137: {
                StackEvaluator.conversionTo("long", "float");
                break;
            }
            case 138: {
                StackEvaluator.conversionTo("long", "double");
                break;
            }
            case 139: {
                StackEvaluator.conversionTo("float", "int");
                break;
            }
            case 140: {
                StackEvaluator.conversionTo("float", "long");
                break;
            }
            case 141: {
                StackEvaluator.conversionTo("float", "double");
                break;
            }
            case 142: {
                StackEvaluator.conversionTo("double", "int");
                break;
            }
            case 143: {
                StackEvaluator.conversionTo("double", "long");
                break;
            }
            case 144: {
                StackEvaluator.conversionTo("double", "float");
                break;
            }
            case 145: {
                StackEvaluator.conversionTo("int", "byte");
                break;
            }
            case 146: {
                StackEvaluator.conversionTo("int", "char");
                break;
            }
            case 147: {
                StackEvaluator.conversionTo("int", "short");
                break;
            }
            case 148: {
                StackEvaluator.arithmetic("CMP", "long");
                break;
            }
            case 149: 
            case 150: {
                StackEvaluator.arithmetic("CMP", "float");
                break;
            }
            case 151: 
            case 152: {
                StackEvaluator.arithmetic("CMP", "double");
                break;
            }
            case 153: {
                StackEvaluator.ifBranch("EQ");
                break;
            }
            case 154: {
                StackEvaluator.ifBranch("NE");
                break;
            }
            case 155: {
                StackEvaluator.ifBranch("LT");
                break;
            }
            case 156: {
                StackEvaluator.ifBranch("GE");
                break;
            }
            case 157: {
                StackEvaluator.ifBranch("GT");
                break;
            }
            case 158: {
                StackEvaluator.ifBranch("LE");
                break;
            }
            case 159: {
                StackEvaluator.ifBranchWithCompare("int", "EQ");
                break;
            }
            case 160: {
                StackEvaluator.ifBranchWithCompare("int", "NE");
                break;
            }
            case 161: {
                StackEvaluator.ifBranchWithCompare("int", "LT");
                break;
            }
            case 162: {
                StackEvaluator.ifBranchWithCompare("int", "GE");
                break;
            }
            case 163: {
                StackEvaluator.ifBranchWithCompare("int", "GT");
                break;
            }
            case 164: {
                StackEvaluator.ifBranchWithCompare("int", "LE");
                break;
            }
            case 165: {
                StackEvaluator.ifBranchWithCompare("Object", "EQ");
                break;
            }
            case 166: {
                StackEvaluator.ifBranchWithCompare("Object", "NE");
                break;
            }
            case 198: {
                StackEvaluator.ifBranchCompareNull("EQN");
                break;
            }
            case 199: {
                StackEvaluator.ifBranchCompareNull("NEN");
                break;
            }
            case 168: 
            case 201: {
                Statement statement = StackEvaluator.makeStatement("JSRCALL", null, null, "ALWAYS");
                break;
            }
            case 169: {
                StackEvaluator.makeStatement("JRETURN", null, null, "ALWAYS");
                break;
            }
            case 170: 
            case 171: {
                StackEvaluator.multiBranch();
                break;
            }
            case 172: {
                StackEvaluator.doReturn("int");
                break;
            }
            case 173: {
                StackEvaluator.doReturn("long");
                break;
            }
            case 174: {
                StackEvaluator.doReturn("float");
                break;
            }
            case 175: {
                StackEvaluator.doReturn("double");
                break;
            }
            case 176: {
                StackEvaluator.doReturn("Object");
                break;
            }
            case 177: {
                StackEvaluator.doReturn("void");
                break;
            }
            case 178: 
            case 180: {
                StackEvaluator.getField(n2 == 180);
                break;
            }
            case 179: 
            case 181: {
                StackEvaluator.putField(n2 == 181);
                break;
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                StackEvaluator.invoke(n2 != 184);
                break;
            }
            case 187: {
                StackEvaluator.__new();
                break;
            }
            case 188: {
                String string2 = String.valueOf(StackEvaluator.getStringType(StackEvaluator.iget1())) + "[]";
                StackEvaluator.newArray(string2, 1);
                break;
            }
            case 189: {
                String string3 = StackEvaluator.getConstName(StackEvaluator.iget2());
                if (string3.charAt(0) == '[') {
                    string3 = AnalyzerUtilities.getFieldType(string3);
                }
                if (string3.indexOf("unknown") >= 0) {
                    Decompiler.report("Field of unknown type found");
                }
                string3 = String.valueOf(string3) + "[]";
                StackEvaluator.newArray(string3, 1);
                break;
            }
            case 197: {
                String string4 = AnalyzerUtilities.getFieldType(StackEvaluator.getConstName(StackEvaluator.iget2()));
                StackEvaluator.newArray(string4, StackEvaluator.iget1_3());
                break;
            }
            case 190: {
                StackEvaluator.arrayLength();
                break;
            }
            case 191: {
                StackEvaluator.athrow();
                break;
            }
            case 192: {
                StackEvaluator.checkcast();
                break;
            }
            case 193: {
                StackEvaluator.__instanceof();
                break;
            }
            case 194: {
                StackEvaluator.monitor(true);
                break;
            }
            case 195: {
                StackEvaluator.monitor(false);
                break;
            }
            case 999: {
                StackEvaluator.infloop();
                break;
            }
            default: {
                Decompiler.report("Unexpected opcode encountered");
            }
            case 0: 
        }
        if (!firstPass && StackEvaluator.currentInstruction.saveLabel >= 0) {
            StackEvaluator.storeGeneratedLocalAndPush(StackEvaluator.currentInstruction.saveLabel);
        }
        UniqueVector uniqueVector = new UniqueVector();
        uniqueVector.addElement(StackEvaluator.stack);
        uniqueVector.addElement(locals);
        return uniqueVector;
    }

    private static void use(int n, String string, int n2, Instruction instruction) throws DecompilerException {
        if (Decompiler.isLocal(n)) {
            LocalDescriptor localDescriptor = StackEvaluator.getDescriptorInGenInsSlot(n, instruction);
            if (localDescriptor == null) {
                throw new DecompilerException(10103);
            }
            LocalVariableInfo.used(localDescriptor, instruction, null);
            localDescriptor.usedAs(string, n2);
        }
    }

    private static void useConstantOperand(String string, int n, Operand operand) throws DecompilerException {
    }

    private static void usedAs(Operand operand, String string, int n) throws DecompilerException {
        if (operand.oper == "GETLOCAL") {
            StackEvaluator.use((Integer)operand.constantOrName, string, n, operand.genInstruction);
        } else if (operand.oper == "CONSTANT") {
            StackEvaluator.useConstantOperand(string, n, operand);
        }
    }

    private static void verifyNames(Operand operand, String string) throws DecompilerException {
        String string2 = (String)operand.constantOrName;
        if (!DecompilerLibrary.removeMethodOrField(string).equals(string2)) {
            throw new DecompilerException(3201);
        }
    }
}

