/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.analyzer;

import org.apache.tools.analyzer.CodeBlock;
import org.apache.tools.analyzer.Decompiler;
import org.apache.tools.analyzer.DecompilerException;
import org.apache.tools.analyzer.DecompilerLibrary;
import org.apache.tools.analyzer.Instruction;
import org.apache.tools.analyzer.NameMgr;
import org.apache.tools.analyzer.Operand;
import org.apache.tools.analyzer.ProgramElement;
import org.apache.tools.analyzer.Type;
import org.apache.tools.analyzer.UniqueVector;
import org.apache.tools.analyzer.info.LocalVariableInfo;

public class Statement
extends ProgramElement {
    public String action = "UNSET";
    public String fieldType;
    public String fullMethodName;
    public CodeBlock containingBlock;
    public String initializer = null;

    public Statement(String string, Object object, Operand operand, Operand operand2, String string2, Instruction instruction) throws DecompilerException {
        this.oper = string;
        this.constantOrName = object;
        this.genInstruction = instruction;
        this.action = string2;
        this.operands = new UniqueVector(2, 2);
        if (operand != null) {
            this.operands.addElement(operand);
        }
        if (operand2 != null) {
            this.operands.addElement(operand2);
        }
    }

    public Statement(String string, Object object, UniqueVector uniqueVector, String string2, Instruction instruction) throws DecompilerException {
        this.oper = string;
        this.constantOrName = object;
        this.genInstruction = instruction;
        this.action = string2;
        this.operands = uniqueVector;
        if (this.operands == null) {
            this.operands = new UniqueVector(1, 1);
        }
    }

    private void arrayStore(UniqueVector uniqueVector) throws DecompilerException {
        String string;
        String string2;
        String string3;
        Operand operand = this.get(0);
        Operand operand2 = this.get(2);
        Type type = operand2.getMyType();
        if (type.isArrayType()) {
            string3 = operand2.output(null, null);
            string2 = type.arrayElementType().getResolvedType();
        } else {
            string = "java/lang/Object[]";
            string3 = operand2.output(null, string);
            string2 = this.arrayInstructionType;
        }
        string = operand.output(null, string2);
        String string4 = this.get(1).output(null, "int");
        uniqueVector.addElement(String.valueOf(string3) + "[" + string4 + "] = " + string + ";");
    }

    private void doReturn(UniqueVector uniqueVector) throws DecompilerException {
        if (Decompiler.isStaticInit()) {
            return;
        }
        String string = this.operandsSize() == 0 ? "return" : "return " + this.get(0).output(null, (String)this.constantOrName);
        uniqueVector.addElement(String.valueOf(string) + ";");
    }

    public Operand get(int n) throws DecompilerException {
        if (this.operands == null) {
            throw new DecompilerException(3503);
        }
        if (n < 0 || n >= this.operands.size()) {
            throw new DecompilerException(3507);
        }
        return (Operand)this.operands.elementAt(n);
    }

    private void ifBranch(UniqueVector uniqueVector) throws DecompilerException {
        Object var2_2 = null;
        uniqueVector.addElement("if ( " + this.get(0).output(null) + " )");
    }

    private void increment(UniqueVector uniqueVector) throws DecompilerException {
        int n = (Integer)this.constantOrName;
        String string = LocalVariableInfo.getLocalName(n, this.genInstruction);
        int n2 = (Integer)this.get((int)0).constantOrName;
        string = n2 < 0 ? (n2 == -1 ? String.valueOf(string) + "--" : String.valueOf(string) + " -= " + n2 * -1) : (n2 == 1 ? String.valueOf(string) + "++" : String.valueOf(string) + " += " + n2);
        uniqueVector.addElement(String.valueOf(string) + ";");
    }

    private void infloop(UniqueVector uniqueVector) {
        uniqueVector.addElement("while ( true )");
        uniqueVector.addElement("   ;");
    }

    private void initialize(UniqueVector uniqueVector) throws DecompilerException {
        Decompiler.report("Initialization of object without new of object");
    }

    private void invokeStatic(UniqueVector uniqueVector) throws DecompilerException {
        String string = ProgramElement.buildInvoke(false, this.operands, (String)this.constantOrName, this.fullMethodName, this.argTypeVector, true);
        uniqueVector.addElement(String.valueOf(string) + ";");
    }

    private void invokeVirtual(UniqueVector uniqueVector) throws DecompilerException {
        String string = ProgramElement.buildInvoke(true, this.operands, (String)this.constantOrName, this.fullMethodName, this.argTypeVector, true);
        uniqueVector.addElement(String.valueOf(string) + ";");
    }

    public UniqueVector makeStatement() throws DecompilerException {
        UniqueVector uniqueVector = new UniqueVector(1, 1);
        if (this.action != "NEVER") {
            if (this.oper.equals("PUTLOCAL")) {
                this.putLocal(uniqueVector);
            } else if (this.oper.equals("ARRAYSTORE")) {
                this.arrayStore(uniqueVector);
            } else if (this.oper.equals("INCREMENT")) {
                this.increment(uniqueVector);
            } else if (this.oper.equals("IF")) {
                this.ifBranch(uniqueVector);
            } else if (this.oper.equals("SWITCH")) {
                this.multiBranch(uniqueVector);
            } else if (this.oper.equals("PUTVIRTUAL")) {
                this.putVirtualField(uniqueVector);
            } else if (this.oper.equals("PUTSTATIC")) {
                this.putStaticField(uniqueVector);
            } else if (this.oper.equals("NEWINITIALIZE")) {
                this.newInitialize(uniqueVector);
            } else if (this.oper.equals("INVOKEVIRTUAL")) {
                this.invokeVirtual(uniqueVector);
            } else if (this.oper.equals("INVOKESTATIC")) {
                this.invokeStatic(uniqueVector);
            } else if (this.oper.equals("RETURN")) {
                this.doReturn(uniqueVector);
            } else {
                if (this.oper.equals("ARRAYLENGTH")) {
                    throw new DecompilerException(3727);
                }
                if (this.oper.equals("THROW")) {
                    this.throwException(uniqueVector);
                } else if (this.oper.equals("MONITOR")) {
                    this.monitor(uniqueVector);
                } else if (this.oper.equals("INFINITELOOP")) {
                    this.infloop(uniqueVector);
                } else if (this.oper.equals("INITIALIZE")) {
                    this.initialize(uniqueVector);
                } else if (this.oper.equals("NEWARRAY")) {
                    this.newArray(uniqueVector);
                } else if (!this.oper.equals("JSRCALL") && !this.oper.equals("JRETURN")) {
                    throw new DecompilerException(3729);
                }
            }
        }
        if (Decompiler.listDebug) {
            int n = uniqueVector.size();
            UniqueVector uniqueVector2 = new UniqueVector(n, n);
            int n2 = 0;
            while (n2 < n) {
                String string = (String)uniqueVector.elementAt(n2);
                if (this.genInstruction != null) {
                    string = String.valueOf(string) + " // " + this.genInstruction.location;
                }
                uniqueVector2.addElement(string);
                ++n2;
            }
            uniqueVector = uniqueVector2;
        }
        return uniqueVector;
    }

    public void markNever() throws DecompilerException {
        if (this.action == "ALWAYS") {
            throw new DecompilerException(8309);
        }
        this.action = "NEVER";
    }

    public void markOperandsNever() throws DecompilerException {
        if (this.operands == null) {
            throw new DecompilerException(8307);
        }
        int n = 0;
        while (n < this.operands.size()) {
            Operand operand = (Operand)this.operands.elementAt(n);
            operand.markNever();
            ++n;
        }
    }

    private void monitor(UniqueVector uniqueVector) throws DecompilerException {
        if (((Boolean)this.constantOrName).booleanValue()) {
            uniqueVector.addElement("synchronized ( " + this.get(0).output(null) + " )");
        }
    }

    private void multiBranch(UniqueVector uniqueVector) throws DecompilerException {
        String string = "switch ( " + this.get(0).output(null, "int") + " )";
        uniqueVector.addElement(string);
    }

    private void newArray(UniqueVector uniqueVector) throws DecompilerException {
        String string = NameMgr.useConvert((String)this.constantOrName, 1);
        uniqueVector.addElement(String.valueOf(ProgramElement.newArray(this.operands, string)) + ";");
    }

    private void newInitialize(UniqueVector uniqueVector) throws DecompilerException {
        if (this.argTypeVector == null) {
            throw new DecompilerException(3821);
        }
        String string = NameMgr.useConvert((String)this.constantOrName, 1);
        String string2 = ProgramElement.newInitialize(this.operands, this.argTypeVector, string);
        uniqueVector.addElement(String.valueOf(string2) + ";");
    }

    public int operandsSize() throws DecompilerException {
        if (this.operands == null) {
            throw new DecompilerException(3509);
        }
        return this.operands.size();
    }

    private void putLocal(UniqueVector uniqueVector) throws DecompilerException {
        int n = (Integer)this.constantOrName;
        Operand operand = this.get(0);
        Statement.putLocalStatic(uniqueVector, n, operand, this.genInstruction, this.initializer, "");
    }

    public static void putLocalStatic(UniqueVector uniqueVector, int n, Operand operand, Instruction instruction, String string, String string2) throws DecompilerException {
        String string3;
        if (operand.oper == "subroutineReturnAddress") {
            return;
        }
        Type type = LocalVariableInfo.getLocalType(n, instruction);
        String string4 = operand.output(null, type.getResolvedType());
        if (string4 != null) {
            string3 = "";
            if (string != null && !string.equals("")) {
                string3 = String.valueOf(string) + " ";
            }
        } else {
            throw new DecompilerException(1205);
        }
        string3 = String.valueOf(string3) + LocalVariableInfo.getLocalName(n, instruction) + " = " + string4 + ";";
        uniqueVector.addElement(String.valueOf(string2) + string3);
    }

    private void putStaticField(UniqueVector uniqueVector) throws DecompilerException {
        String string = ProgramElement.getStaticFieldName((String)this.constantOrName);
        uniqueVector.addElement(String.valueOf(string) + " = " + this.get(0).output(null, this.fieldType) + ";");
    }

    private void putVirtualField(UniqueVector uniqueVector) throws DecompilerException {
        String string = DecompilerLibrary.removeClass((String)this.constantOrName);
        String string2 = DecompilerLibrary.removeMethodOrField((String)this.constantOrName);
        String string3 = String.valueOf(ProgramElement.getFieldObjectReference(this.get(1), string2)) + string + " = " + this.get(0).output(null, this.fieldType);
        uniqueVector.addElement(String.valueOf(string3) + ";");
    }

    public void replaceOperand(Operand operand) throws DecompilerException {
        if (this.operands.size() != 1 || operand == null) {
            throw new DecompilerException(3501);
        }
        this.operands = new UniqueVector(2, 2);
        this.operands.addElement(operand);
    }

    public void setNewInitialize(UniqueVector uniqueVector, UniqueVector uniqueVector2) {
        this.oper = "NEWINITIALIZE";
        this.operands = uniqueVector;
        this.argTypeVector = uniqueVector2;
    }

    private void throwException(UniqueVector uniqueVector) throws DecompilerException {
        String string = "throw " + this.get(0).output(null);
        uniqueVector.addElement(String.valueOf(string) + ";");
    }

    public void touch(boolean bl) throws DecompilerException {
        if (this.operands == null) {
            throw new DecompilerException(3511);
        }
        int n = 0;
        while (n < this.operands.size()) {
            ((Operand)this.operands.elementAt(n)).touch(bl);
            ++n;
        }
    }
}

