package org.apache.tools.ant.taskdefs.optional.perforce;

import java.io.*;

import org.apache.tools.ant.*;

/** P4Change - grab a new changelist from Perforce.
 *
 * P4Change creates a new changelist in perforce. P4Change sets the property
 * ${p4.change} with the new changelist number. This should then be passed into
 * p4edit and p4submit.
 *
 * @see P4Edit
 * @see P4Submit
 * @author <A HREF="mailto:leslie.hughes@rubus.com">Les Hughes</A>
 *
 */
public class P4Change extends P4Base {

	protected String emptyChangeList = null;

    public void execute() throws BuildException {

        if(emptyChangeList == null) emptyChangeList = getEmptyChangeList();
        final Project myProj = project;
        execP4Command("change -i", emptyChangeList, new P4OutputHandler() {
            public void process(String line) {
                if (util.match("/Change/", line)) {
                    
                    //Remove any non-numerical chars - should leave the change number
   	        		line = util.substitute("s/[^0-9]//g", line);
   	        		
   			       	int changenumber = Integer.parseInt(line);
   			        log("Change Number is "+changenumber, Project.MSG_INFO);
				    myProj.setProperty("p4.change", ""+changenumber);

       			} else if(util.match("/error/", line)) {
   	    		    throw new BuildException("Perforce Error, check client settings and/or server");
       			}
   			        
   	        }});
    }


    public String getEmptyChangeList() throws BuildException {
        final StringBuffer stringbuf = new StringBuffer();
        
        execP4Command("change -o", new P4OutputHandler() {
            public void process(String line) {
        	    if(!util.match("/^#/",line)){
                    if(util.match("/error/", line)) {
	        		
   			            log("Client Error", Project.MSG_VERBOSE);
   			            throw new BuildException("Perforce Error, check client settings and/or server");
   			            
           			} else if(util.match("/<enter description here>/",line)) {

                        line = util.substitute("s/<enter description here>/AutoSubmit By Ant/", line);
			    		
			        } else if(util.match("/\\/\\//", line)) {
			            //Match "//" for begining of depot filespec
			    	    return;
				    }
				    
    				stringbuf.append(line);
	    			stringbuf.append("\n");
	    			
		    	}
    		}});
		
    	   	return stringbuf.toString();
    }


} //EoF
