package org.apache.tools.ant.gui.acs;

import java.beans.*;

import java.util.*;

import org.apache.tools.ant.gui.command.NewElementCmd;

import org.apache.tools.ant.gui.util.Collections;

import org.apache.tools.ant.gui.xml.DOMNode;
import org.apache.tools.ant.gui.xml.NamedDOMNodeMap;

import org.apache.tools.ant.gui.xml.dtd.DOMAttributes;
import org.apache.tools.ant.gui.xml.dtd.ANTDocumentType;

import org.w3c.dom.*;

/**
 * Element defined by the DTD.
 *
 * @version $Revision: 1.2 $
 * @author Nick Davis<a href="mailto:nick_home_account@yahoo.com">nick_home_account@yahoo.com</a>
 */
public class ACSDtdDefinedElement extends ACSTreeNodeElement
implements ACSInfoProvider {
        
    /** Property name for the task type. */
    public static final String TASK_TYPE = "taskType";
    /** Property name for attributes. It's called "namedValues" so
     *  it doesn't collide with the Node.getAttributes() method. */
    public static final String NAMED_VALUES = "namedValues";
    /** The ANT DTD */
    static ANTDocumentType docType = new ANTDocumentType();
    /** Our menu string */
    public String[] menuString = null;
    /** The DTD element we represent */
    private ANTDocumentType.DtdElement _dtdElement = null;
    
	/** 
	 * Default ctor.
	 * 
	 */
    public ACSDtdDefinedElement() {
        // Load the DTD
        docType.init();
    }

	/** 
	 * Get the task type.
	 * 
	 * @return Task type.
	 */
    public String getTaskType() {
        return getTagName();
    }

	/** 
	 * Get the display name of this.
	 * 
	 * @return Display name.
	 */
    public String getDisplayName() {
        String name = getTagName();

        // Is there only one attribute?
        if (getAttributes().getLength() == 1) {
            DOMNode onlyNode = getAttributes().item(0);

            // Display the only attribute
            name += ": " + onlyNode.getNodeValue();
        } else {
            
            // Display one of these attributes
            // if they are present.
            final String[] DISPLAY_ATTRIBUTES =
            {
                "name",
                "id",
                "property"
            };

            for(int i = 0; i < DISPLAY_ATTRIBUTES.length; i++) {
                DOMNode testNode =
                    getAttributes().getNamedItem(DISPLAY_ATTRIBUTES[i]);
                if (testNode != null) {
                    name += ": " + testNode.getNodeValue();
                    break;
                }
            }
        }
        
        return name;
    }
    
        /** 
         * Set the task type.
         * 
         * @param type Type name.
         */
    //public void setTaskType(String type) {
    //    setTag(type);
    //}

	/** 
	 * Get the attributes (named value mappings). This method is not named
         * getAttributes() because there is already a method of that name in
         * the Node interface.
	 * 
	 * @return Name-value mappings.
	 */
    public DOMAttributes getNamedValues() {
        DOMAttributes retval =
            new DOMAttributes(getDtdElement());

        NamedDOMNodeMap attribs = getAttributes();
        for(int i = 0, len = attribs.getLength(); i < len; i++) {
            DOMNode n = attribs.item(i);
            retval.setProperty(n.getNodeName(), n.getNodeValue());
        }
        return retval;
    }


	/** 
	 * Set the attributes. This method sets the Node attirbutes using 
         * the given Map containing name-value pairs.
	 * 
	 * @param attributes New attribute set.
	 */
    public void setNamedValues(DOMAttributes attributes) {
        // XXX this code really sucks. It is really annoying that the
        // DOM interfaces don't have a general "setAttributes()" or
        // "removeAllAttributes()" method, but instead make you
        // remove each attribute individually, or require you to figure
        // out what the differences are between the two.

        // Although this is very inefficient, I'm taking the conceptually
        // simplistic approach to this and brute force removing the existing
        // set and replacing it with a brand new set. If this becomes a
        // performance concern (which I doubt it will) it can be optimized
        // later.

        DOMAttributes old = (DOMAttributes) getNamedValues();

        Enumeration enum = old.propertyNames();
        while(enum.hasMoreElements()) {
            String name = (String) enum.nextElement();
            removeAttribute(name);
        }

        enum = attributes.propertyNames();
        while(enum.hasMoreElements()) {
            String key = (String) enum.nextElement();
            setAttribute(key, attributes.getProperty(key));
        }

        firePropertyChange(NAMED_VALUES, old, attributes);
    }
    
    /**
     * Returns the menu items which may be used for this element.
     */
    public String[] getMenuString() {
        
        // If it already exists, use it.
        if (menuString != null) {
            return menuString;
        }

        // Find the DtdElement
        String name = getTagName();
        
        // Are we the project element?
        boolean isProject = false;
        if (name.equals("project")) {
            isProject = true;
        }
        
        ANTDocumentType.DtdElement e =
            docType.findElement(ANTDocumentType.CORE_ELEMENT, name);
        if (e == null) {
            e = docType.findElement(ANTDocumentType.OPTIONAL_ELEMENT, name);
        }

        if (e != null) {
            // Use the content model (all the possible
            // sub-elements) to create the menu.
            String[] temp = e.getContentModel();
            
            // Sort the items
            List list = Collections.fill(null, temp);
            java.util.Collections.sort(list);
            list.toArray(temp);
            
            int size = (temp.length > 5) ? 5 : temp.length;

            // The project doesn't need a delete menu
            if (isProject) {
                menuString = new String[size+1];
            } else {
                menuString = new String[size+2];
            }
            System.arraycopy(temp, 0, menuString, 0, size);
            
        } else {
            // This is for elements not in the DTD
            menuString = new String[2];
        }
        
        if (isProject) {
            menuString[menuString.length-1] = "newElement";
        } else {
            // Add the delete and generic create commands
            menuString[menuString.length-1] = "deleteElement";
            menuString[menuString.length-2] = "newElement";
        }
        
        return menuString;
    }
    
    /**
     * Returns the string to use if an action ID is not found.
     * In our case, the newElement command is used.
     */
    public String getDefaultActionID() {
        return "newElement";
    }
    
    /**
     * Returns a string array which contains this elements
     * possible children.
     * 
     * @param childType ANTDocumentType.CORE_ELEMENT or
     * ANTDocumentType.OPTIONAL_ELEMENT
     */
    public String[] getPossibleChildren(int childType) {
        String name = getTagName();
        
        ANTDocumentType.DtdElement e =
            docType.findElement(childType, name);
        if (e != null) {
            return e.getContentModel();
        }
        return null;
    }
    
    /**
     * Adds the attributes which are required by this node.
     */
    public void addRequiredAttributes() {
        ANTDocumentType.DtdElement e = getDtdElement();
        if (e == null) {
            return;
        }
        String[] attributes = e.getAttributes().getRequiredAttributes();
        if (attributes == null) {
            return;
        }
        for(int i = 0; i < attributes.length; i++) {
            if ( getAttributes().getNamedItem(attributes[i]) == null) {
                // XXX should set to default?
                setAttribute(attributes[i], "");
            }
        }
    }
    
    /**
     * Returns the DTD element we represent
     */
    private ANTDocumentType.DtdElement getDtdElement() {
        if (_dtdElement != null) {
            return _dtdElement;
        }

        String name = getNodeName();
        
        _dtdElement = docType.findElement(ANTDocumentType.CORE_ELEMENT, name);
        if (_dtdElement == null) {
            _dtdElement = docType.findElement(
                ANTDocumentType.OPTIONAL_ELEMENT, name);
        }
        
        return _dtdElement;
    }
}

