package org.apache.tools.ant.gui.acs;

import java.beans.*;

import org.apache.tools.ant.gui.customizer.DynamicCustomizer;

import org.apache.tools.ant.gui.modules.edit.DtdAttributePropertyEditor;

import org.apache.tools.ant.gui.xml.dtd.DOMAttributes;

/**
 * BeanInfo for the ACSDtdDefinedElement class.
 * 
 * @version $Revision: 1.1 $
 * @author Nick Davis<a href="mailto:nick_home_account@yahoo.com">nick_home_account@yahoo.com</a>
 */
public class ACSDtdDefinedElementBeanInfo extends BaseBeanInfo {
	/** 
	 * Default ctor.
	 * 
	 */
    public ACSDtdDefinedElementBeanInfo() {
    }

	/** 
	 * Get the type that this BeanInfo represents.
	 * 
	 * @return Type.
	 */
    public Class getType() {
        return ACSDtdDefinedElement.class;
    }

	/** 
	 * Get the customizer type.
	 * 
	 * @return Customizer type.
	 */
    public Class getCustomizerType() {
        return Customizer.class;
    }

	/** 
	 * Get the property descriptors.
	 * 
         * @return Property descriptors.
	 */
    public PropertyDescriptor[] getPropertyDescriptors() {
        PropertyDescriptor[] retval = null;

        try {
            retval = new PropertyDescriptor[] {
                new PropertyDescriptor(ACSDtdDefinedElement.TASK_TYPE, 
                                       ACSDtdDefinedElement.class,
                                       "getTaskType", null),
                new PropertyDescriptor(ACSDtdDefinedElement.NAMED_VALUES, 
                    ACSDtdDefinedElement.class),
                new PropertyDescriptor(ACSDtdDefinedElement.XML_STRING, 
                    ACSDtdDefinedElement.class,
                    "getXMLString", null)
            };
            int pos = 0;
            retval[pos++].setDisplayName(getResources().getString(
                getClass(),ACSDtdDefinedElement.TASK_TYPE));
            retval[pos++].setDisplayName(getResources().getString(
                getClass(),ACSDtdDefinedElement.NAMED_VALUES));
            retval[pos++].setDisplayName(getResources().getString(
                getClass(),ACSDtdDefinedElement.XML_STRING));
            
            setSortingOrder(retval);
        } catch(IntrospectionException ex) { 
            ex.printStackTrace();
            throw new Error(ex.toString());
        }
            
        return retval;
    }

    /** Customizer for this bean info. */
    public static class Customizer extends DynamicCustomizer {
        static {
            PropertyEditorManager.registerEditor(
		DOMAttributes.class, DtdAttributePropertyEditor.class);
        }
        
        public Customizer() {
            super(ACSDtdDefinedElement.class);
        }
    }
}

