package org.apache.tools.ant.gui.acs;

import java.io.File;

import java.net.URL;

/**
 * Class representing a project element in the build file.
 * 
 * @version $Revision: 1.1 $ 
 * @author Simeon Fitch 
 */
public class ACSProjectElement extends ACSNamedElement {
    /** The 'default' property name. */
    public static final String DEFAULT = "default";
    /** The 'basdir' property name. */
    public static final String BASEDIR = "basedir";
    /** Property name of the persistence location. */
    public static final String LOCATION = "location";
    /** The location where this project is persisted. */
    private URL _location = null;
    
	/** 
	 * Default ctor.
	 * 
	 */
    public ACSProjectElement() {
    }

	/** 
	 * Get the type that this BeanInfo represents.
	 * 
	 * @return Type.
	 */
    public Class getType() {
        return ACSProjectElement.class;
    }

	/** 
	 * Get the name of the default target.
	 * 
	 * @return Default target name.
	 */
    public String getDefault() {
        return getAttribute(DEFAULT);
    }

	/** 
	 * Set the name of the default target.
	 * 
	 * @param def Name of the default target.
	 */
    public void setDefault(String def) {
        String old = getDefault();
        setAttribute(DEFAULT, def);
        firePropertyChange(DEFAULT, old, def);
    }

	/** 
	 * Get the specified base directory for the build.
	 * 
	 * @return Base directory
	 */
    public String getBasedir() {
        return getAttribute(BASEDIR);
    }

	/** 
	 * Set the base directory for builds.
	 * 
	 * @param baseDir Build base directory.
	 */
    public void setBasedir(String baseDir) {
        String old = getBasedir();
        setAttribute(BASEDIR, baseDir);
        firePropertyChange(BASEDIR, old, baseDir);
    }

    /** 
     * Get the location where this project is persisted.
     * 
     * @return Saved location, or null if not persisted.
     */
    public URL getLocation() {
        return _location;
    }

    /** 
     * Set the loction where the project is persisted.
     * 
     * @param location Location of project.
     */
    public void setLocation(URL location) {
        URL old = _location;
        _location = location;
        firePropertyChange(LOCATION, old, _location);
    }

    /** 
     * Set the loction where the project is persisted.
     * 
     * @param location Location of project as a file.
     */
    public void setLocation(File location) {
        try {
            setLocation(new URL("file", null, location.getAbsolutePath()));
        }
        catch(java.net.MalformedURLException ex) {
            // No reason why this should happen.
            // xxx Log me.
            ex.printStackTrace();
        }
    }
}
