
package org.apache.tools.ant.gui.xml;

import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DOMDocument {

    /** Creates new DOMDocument */
    public DOMDocument() {
    }
    
    private Document _impl;
    private DOMNodeFactory _factory;
    private DOMNodeContainer _container;

    public DOMNodeFactory getFactory() {
        return _factory;
    }
    void setFactory(DOMNodeFactory factory) {
        _factory = factory;
    }
    public DOMNodeContainer getContainer() {
        return _container;
    }
    void setContainer(DOMNodeContainer container) {
        _container = container;
    }
    public void setImpl(Document impl) {
        _impl = impl;
    }

    //
    //
    //
    
    public DocumentType getDoctype() {
        return _impl.getDoctype();
    }
    public ProcessingInstruction createProcessingInstruction(String p1,String p2)
            throws DOMException {
        return _impl.createProcessingInstruction(p1, p2);
    }
    public EntityReference createEntityReference(String p1)
            throws DOMException {
        return _impl.createEntityReference(p1);
    }
    public Text createTextNode(String p1) {
        return _impl.createTextNode(p1);
    }
    public CDATASection createCDATASection(String p1) throws DOMException {
        return _impl.createCDATASection(p1);
    }
    public DOMElement getDocumentElement() {
        return (DOMElement) _factory.createDOMNode(_impl.getDocumentElement());
    }
    public DOMImplementation getImplementation() {
        return _impl.getImplementation();
    }
    public Attr createAttribute(String p1) throws DOMException {
        return _impl.createAttribute(p1);
    }
    public Comment createComment(String p1) {
        return _impl.createComment(p1);
    }
    public DocumentFragment createDocumentFragment() {
        return _impl.createDocumentFragment();
    }
    public DOMNodeList getElementsByTagName(String p1) {
        return new DOMNodeList(_factory, _impl.getElementsByTagName(p1));
    }
    public DOMElement createElement(String p1) throws DOMException {
        return (DOMElement) _factory.createDOMNode(_impl.createElement(p1));
    }
    public DOMNode getPreviousSibling() {
        return _factory.createDOMNode(_impl.getPreviousSibling());
    }
    public void setNodeValue(String p1) throws DOMException {
        _impl.setNodeValue(p1);
    }
    public String getNodeValue() throws DOMException {
        return _impl.getNodeValue();
    }
    public DOMNode insertBefore(DOMNode p1, DOMNode p2) throws DOMException {
        return _factory.createDOMNode(
            _impl.insertBefore(p1.getImpl(), p2.getImpl()));
    }
    public DOMNode getParentNode() {
        return _factory.createDOMNode(_impl.getParentNode());
    }
    public boolean hasChildNodes() {
        return _impl.hasChildNodes();
    }
    public String getNodeName() {
        return _impl.getNodeName();
    }
    public NamedDOMNodeMap getAttributes() {
        return new NamedDOMNodeMap (_factory, _impl.getAttributes());
    }
    public short getNodeType() {
        return _impl.getNodeType();
    }
    public DOMNode removeChild(DOMNode p1) throws DOMException {
        return _factory.createDOMNode(
            _impl.removeChild(p1.getImpl()));
    }
    public DOMNode appendChild(DOMNode p1) throws DOMException {
        return _factory.createDOMNode(
            _impl.appendChild(p1.getImpl()));
    }
    public DOMNode getNextSibling() {
        return _factory.createDOMNode(_impl.getNextSibling());
    }
    public DOMNode getLastChild() {
        return _factory.createDOMNode(_impl.getLastChild());
    }
    public DOMNodeList getChildNodes() {
        return new DOMNodeList (_factory, _impl.getChildNodes());
    }
    public DOMNode getFirstChild() {
        return _factory.createDOMNode(_impl.getFirstChild());
    }
    public DOMNode cloneNode(boolean p1) {
        return _factory.createDOMNode(_impl.cloneNode(p1));
    }
    public Document getOwnerDocument() {
        return _impl.getOwnerDocument();
    }
    public DOMNode replaceChild(DOMNode p1, DOMNode p2) throws DOMException {
        return _factory.createDOMNode(
            _impl.replaceChild(p1.getImpl(), p2.getImpl()));
    }
}
