
package org.apache.tools.ant.gui.xml;

import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMElement extends DOMNode {

    /** Creates new DefaultElement */
    public DOMElement() {
    }
    public Element getElementImpl() {
        return (Element) getImpl();
    }
    public String getAttribute(String str) {
        return getElementImpl().getAttribute(str);
    }
    public Attr getAttributeNode(String str) {
        return getElementImpl().getAttributeNode(str);
    }
    public String getTagName() {
        return getElementImpl().getTagName();
    }
    public void normalize() {
        getElementImpl().normalize();
    }
    public void removeAttribute(String str) throws DOMException {
        getElementImpl().removeAttribute(str);
    }
    public Attr removeAttributeNode(Attr attr) throws DOMException {
        return getElementImpl().removeAttributeNode(attr);
    }
    public void setAttribute(String str, String str1) throws DOMException {
        getElementImpl().setAttribute(str, str1);
    }
    public Attr setAttributeNode(Attr attr) throws DOMException {
        return getElementImpl().setAttributeNode(attr);
    }
    public NodeList getElementsByTagName(String str) {
        return getElementImpl().getElementsByTagName(str);
    }
    public String getAttributeNS(String namespaceURI, String localName) {
        return getElementImpl().getAttributeNS(namespaceURI, localName);
    }
    public void setAttributeNS(String namespaceURI, String qualifiedName,
            String value) throws DOMException {
        getElementImpl().setAttributeNS(namespaceURI, qualifiedName, value);
    }
    public void removeAttributeNS(String namespaceURI, String localName)
            throws DOMException {
        getElementImpl().removeAttributeNS(namespaceURI, localName);
    }
    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        return getElementImpl().getAttributeNodeNS(namespaceURI, localName);
    }
    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        return getElementImpl().setAttributeNodeNS(newAttr);
    }
    public DOMNodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        NodeList list = getElementImpl().getElementsByTagNameNS(
            namespaceURI, localName);
        return new DOMNodeList( getFactory(), list );
    }
    public boolean hasAttribute(String name) {
        return getElementImpl().hasAttribute(name);
    }
    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return getElementImpl().hasAttributeNS(namespaceURI, localName);
    }
}
