
package org.apache.tools.ant.gui.xml;

import java.io.Writer;
import java.util.Stack;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class DataWriter extends XMLWriter
{
    private final static Object SEEN_NOTHING = new Object();
    private final static Object SEEN_ELEMENT = new Object();
    private final static Object SEEN_DATA = new Object();

    private Object state = SEEN_NOTHING;
    private Stack stateStack = new Stack();

    private int indentStep = 0;
    private int depth = 0;

    public DataWriter ()
    {
        super();
    }


    public DataWriter (XMLReader xmlreader)
    {
        super(xmlreader);
    }


    public DataWriter (Writer writer)
    {
        super(writer);
    }

    public DataWriter (XMLReader xmlreader, Writer writer)
    {
        super(xmlreader, writer);
    }

    public int getIndentStep ()
    {
        return indentStep;
    }

    public void setIndentStep (int indentStep)
    {
        this.indentStep = indentStep;
    }

    public void reset ()
    {
        depth = 0;
        state = SEEN_NOTHING;
        stateStack = new Stack();
        super.reset();
    }

    public void startElement (String uri, String localName,
                              String qName, Attributes atts)
        throws SAXException
    {
        stateStack.push(SEEN_ELEMENT);
        state = SEEN_NOTHING;
        if (depth > 0) {
            super.characters("\n");
        }
        doIndent();
        super.startElement(uri, localName, qName, atts);
        depth++;
    }

    public void endElement (String uri, String localName, String qName)
        throws SAXException
    {
        depth--;
        if (state == SEEN_ELEMENT) {
            super.characters("\n");
            doIndent();
        }
        super.endElement(uri, localName, qName);
        state = stateStack.pop();
    }

    public void emptyElement (String uri, String localName,
                              String qName, Attributes atts)
        throws SAXException
    {
        stateStack.push(SEEN_ELEMENT);
        state = SEEN_NOTHING;
        if (depth > 0) {
            super.characters("\n");
        }
        doIndent();
        super.emptyElement(uri, localName, qName, atts);
        state = stateStack.pop();
    }

    public void characters (char ch[], int start, int length)
        throws SAXException
    {
        state = SEEN_DATA;
        super.characters(ch, start, length);
    }

    public void comment (String data)
        throws SAXException
    {
        stateStack.push(SEEN_ELEMENT);
        state = SEEN_NOTHING;
        if (depth > 0) {
            super.characters("\n");
        }
        doIndent();
        super.comment(data);
        state = stateStack.pop();
    }

    private void doIndent ()
        throws SAXException
    {
        if (indentStep > 0 && depth > 0) {
            int n = indentStep * depth;
            char ch[] = new char[n];
            for (int i = 0; i < n; i++) {
                ch[i] = ' ';
            }
            characters(ch, 0, n);
        }
    }
}
