
package org.apache.tools.ant.gui.xml;

import org.w3c.dom.Node;

public class TreeWalker
{
    private Node	startPoint;
    private Node	current;

    public TreeWalker (Node initial)
    {
        startPoint = current = initial;
    }

    public Node getCurrent ()
    {
        return current;
    }

    public Node getNext ()
    {
        Node	next;

        if (current == null)
            return null;

        next = current.getFirstChild ();
        if (next != null) {
            current = next;
            return next;
        }

        Node here = current;
        while(true) {

            if (here != null) {
                if (here == startPoint) {
                    current = null;
                    return null;
                }
                next = here.getNextSibling ();
            }

            if (next != null) {
                current = next;
                return next;
            }
            here = here.getParentNode();
        }
    }

    public void reset ()
    {
        current = startPoint;
    }
}

