package org.apache.tools.ant.gui.xml.dtd;

import java.util.Properties;

/**
 * Represents the attributes defined by the DTD.
 *
 * @version $Revision: 1.1 $
 * @author Nick Davis<a href="mailto:nick_home_account@yahoo.com">Nick Davis</a>
 */
public class DOMAttributes extends Properties {

    ANTDocumentType.DtdElement _element = null;

    /**
     * Default constructor
     */
    public DOMAttributes() {
        this(null);
    }

    /**
     * Constructor
     *
     * @param element provides information about possible attributes.
     */
    public DOMAttributes(ANTDocumentType.DtdElement element) {
        _element = element;
    }

    /**
     * Return the required attributes or null.
     */
    public String[] getRequiredAttributes() {
        if (_element == null) {
            return null;
        }
        return _element.getAttributes().getRequiredAttributes();
    }
    /**
     * Return the optional attributes or null.
     */
    public String[] getOptionalAttributes() {
        if (_element == null) {
            return null;
        }
        return _element.getAttributes().getOptionalAttributes();
    }
}
