/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.loader;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class MainClassLoader
extends ClassLoader {
    private static final int BUFFER_SIZE = 8192;
    Vector pathComponents = new Vector();
    private boolean parentFirst = true;
    private Vector systemPackages = new Vector();
    private Vector loaderPackages = new Vector();
    private boolean ignoreBase = false;
    private ClassLoader parent = null;
    boolean debug = false;
    PrintStream logger = System.out;
    private Hashtable zipFiles = new Hashtable();
    private ClassLoader savedContextLoader = null;
    private boolean isContextLoaderSaved = false;
    private static Method getProtectionDomain = null;
    private static Method defineClassProtectionDomain = null;
    private static Method getContextClassLoader = null;
    private static Method setContextClassLoader = null;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$java$lang$Thread;

    public MainClassLoader(File[] fileArray) {
        this(fileArray, true);
    }

    public MainClassLoader(ClassLoader classLoader, File[] fileArray, boolean bl) {
        this(fileArray, bl);
        this.parent = classLoader;
    }

    public MainClassLoader(File[] fileArray, boolean bl) {
        this.parentFirst = bl;
        if (fileArray != null) {
            int n = 0;
            while (n < fileArray.length) {
                this.addPathElement(fileArray[n]);
                ++n;
            }
        }
        this.addSystemPackageRoot("java");
        this.addSystemPackageRoot("javax");
        this.parent = this.getClass().getClassLoader();
    }

    public MainClassLoader(ClassLoader classLoader, boolean bl) {
        this(classLoader, null, bl);
    }

    protected RuntimeException loaderException(String string) {
        return new LoaderException(string);
    }

    protected void log(String string) {
        if (this.debug) {
            this.logger.println(string);
        }
    }

    public void setThreadContextLoader() {
        if (this.isContextLoaderSaved) {
            throw this.loaderException("Context loader has not been reset");
        }
        if (getContextClassLoader != null && setContextClassLoader != null) {
            try {
                this.savedContextLoader = (ClassLoader)getContextClassLoader.invoke((Object)Thread.currentThread(), new Object[0]);
                Object[] objectArray = new Object[]{this};
                setContextClassLoader.invoke((Object)Thread.currentThread(), objectArray);
                this.isContextLoaderSaved = true;
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                throw this.loaderException(throwable.toString());
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw this.loaderException(exception.toString());
            }
        }
    }

    public void resetThreadContextLoader() {
        if (this.isContextLoaderSaved && getContextClassLoader != null && setContextClassLoader != null) {
            try {
                Object[] objectArray = new Object[]{this.savedContextLoader};
                setContextClassLoader.invoke((Object)Thread.currentThread(), objectArray);
                this.savedContextLoader = null;
                this.isContextLoaderSaved = false;
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                throw this.loaderException(throwable.toString());
            }
            catch (Exception exception) {
                throw this.loaderException(exception.toString());
            }
        }
    }

    public void addPathElement(File file) {
        if (this.pathComponents.contains(file)) {
            return;
        }
        this.log("Adding to path: " + file);
        this.pathComponents.addElement(file);
    }

    public String getClassPath() {
        String string = "";
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.pathComponents.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(File.pathSeparator);
            stringBuffer.append(((File)enumeration.nextElement()).getAbsolutePath());
        }
        if (!this.ignoreBase) {
            string = this.parent != null && this.parent instanceof MainClassLoader ? ((MainClassLoader)this.parent).getClassPath() : System.getProperty("java.class.path", "");
        } else {
            return stringBuffer.substring(1);
        }
        if (this.parentFirst) {
            return stringBuffer.insert(0, string).toString();
        }
        stringBuffer.append(File.pathSeparator).append(string);
        return stringBuffer.substring(1);
    }

    public void setIsolated(boolean bl) {
        this.ignoreBase = bl;
    }

    public void addSystemPackageRoot(String string) {
        this.systemPackages.addElement(string + ".");
    }

    public void addLoaderPackageRoot(String string) {
        this.loaderPackages.addElement(string + ".");
    }

    public Class forceLoadClass(String string) throws ClassNotFoundException {
        this.log("force loading " + string);
        Class clazz = this.findLoadedClass(string);
        if (clazz == null) {
            clazz = this.findClass(string);
        }
        return clazz;
    }

    public Class forceLoadSystemClass(String string) throws ClassNotFoundException {
        this.log("force system loading " + string);
        Class clazz = this.findLoadedClass(string);
        if (clazz == null) {
            clazz = this.findBaseClass(string);
        }
        return clazz;
    }

    public InputStream getResourceAsStream(String string) {
        InputStream inputStream = null;
        if (this.isParentFirst(string)) {
            inputStream = this.loadBaseResource(string);
            if (inputStream != null) {
                this.log("ResourceStream for " + string + " loaded from parent loader");
            } else {
                inputStream = this.loadResource(string);
                if (inputStream != null) {
                    this.log("ResourceStream for " + string + " loaded from ant loader");
                }
            }
        } else {
            inputStream = this.loadResource(string);
            if (inputStream != null) {
                this.log("ResourceStream for " + string + " loaded from ant loader");
            } else {
                inputStream = this.loadBaseResource(string);
                if (inputStream != null) {
                    this.log("ResourceStream for " + string + " loaded from parent loader");
                }
            }
        }
        if (inputStream == null) {
            this.log("Couldn't load ResourceStream for " + string);
        }
        return inputStream;
    }

    private InputStream loadResource(String string) {
        InputStream inputStream = null;
        int n = 0;
        while (n < this.pathComponents.size() && inputStream == null) {
            File file = (File)this.pathComponents.elementAt(n);
            inputStream = this.getResourceStream(file, string);
            ++n;
        }
        return inputStream;
    }

    private InputStream loadBaseResource(String string) {
        if (this.parent == null) {
            return ClassLoader.getSystemResourceAsStream(string);
        }
        return this.parent.getResourceAsStream(string);
    }

    private InputStream getResourceStream(File file, String string) {
        try {
            if (!file.exists()) {
                return null;
            }
            if (file.isDirectory()) {
                File file2 = new File(file, string);
                if (file2.exists()) {
                    return new FileInputStream(file2);
                }
            } else {
                ZipEntry zipEntry;
                this.log("Looking in: " + file);
                ZipFile zipFile = (ZipFile)this.zipFiles.get(file);
                if (zipFile == null) {
                    zipFile = new ZipFile(file);
                    this.zipFiles.put(file, zipFile);
                    this.applyManifest(file, zipFile);
                }
                if ((zipEntry = zipFile.getEntry(string)) != null) {
                    return zipFile.getInputStream(zipEntry);
                }
            }
        }
        catch (Exception exception) {
            this.log("Ignoring Exception " + exception.getClass().getName() + ": " + exception.getMessage() + " reading resource " + string + " from " + file);
        }
        return null;
    }

    private boolean isParentFirst(String string) {
        Object object;
        if (this.parentFirst) {
            return true;
        }
        Enumeration enumeration = this.systemPackages.elements();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (!string.startsWith((String)object)) continue;
            return true;
        }
        object = this.loaderPackages.elements();
        while (object.hasMoreElements()) {
            String string2 = (String)object.nextElement();
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return this.parentFirst;
    }

    public URL getResource(String string) {
        URL uRL = null;
        boolean bl = this.isParentFirst(string);
        if (bl) {
            URL uRL2 = uRL = this.parent == null ? super.getResource(string) : this.parent.getResource(string);
        }
        if (uRL != null) {
            this.log("Resource " + string + " loaded from parent loader");
        } else {
            int n = 0;
            while (n < this.pathComponents.size() && uRL == null) {
                File file = (File)this.pathComponents.elementAt(n);
                uRL = this.getResourceURL(file, string);
                if (uRL != null) {
                    this.log("Resource " + string + " loaded from ant loader");
                }
                ++n;
            }
        }
        if (uRL == null && !bl) {
            URL uRL3 = uRL = this.parent == null ? super.getResource(string) : this.parent.getResource(string);
            if (uRL != null) {
                this.log("Resource " + string + " loaded from parent loader");
            }
        }
        if (uRL == null) {
            this.log("Couldn't load Resource " + string);
        }
        return uRL;
    }

    protected Enumeration findResources(String string) throws IOException {
        return new ResourceEnumeration(string);
    }

    private URL getResourceURL(File file, String string) {
        try {
            if (!file.exists()) {
                return null;
            }
            if (file.isDirectory()) {
                File file2 = new File(file, string);
                if (file2.exists()) {
                    try {
                        return new URL("file:" + file2.toString());
                    }
                    catch (MalformedURLException malformedURLException) {
                        return null;
                    }
                }
            } else {
                ZipEntry zipEntry;
                this.log("Looking in: " + file);
                ZipFile zipFile = (ZipFile)this.zipFiles.get(file);
                if (zipFile == null) {
                    zipFile = new ZipFile(file);
                    this.zipFiles.put(file, zipFile);
                    this.applyManifest(file, zipFile);
                }
                if ((zipEntry = zipFile.getEntry(string)) != null) {
                    try {
                        return new URL("jar:file:" + file.toString() + "!/" + zipEntry);
                    }
                    catch (MalformedURLException malformedURLException) {
                        return null;
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void applyManifest(File var1_1, ZipFile var2_2) {
        block15: {
            block14: {
                var3_3 = null;
                try {
                    try {
                        var4_4 = var2_2.getEntry("META-INF/MANIFEST.MF");
                        if (var4_4 == null) {
                            var8_6 = null;
                            if (var3_3 == null) return;
                            break block14;
                        }
                        var3_3 = new BufferedReader(new InputStreamReader(var2_2.getInputStream(var4_4)));
                        var5_14 = null;
                        var5_14 = var3_3.readLine();
                        block9: while (var5_14 != null && !var5_14.equals("")) {
                            var6_15 = var5_14;
                            while (true) {
                                if ((var5_14 = var3_3.readLine()) == null || !var5_14.startsWith(" ")) {
                                    this.applyManifestGlobalEntry(var1_1, var6_15);
                                    continue block9;
                                }
                                var6_15 = var6_15 + var5_14.substring(1);
                            }
                        }
                        break block15;
                    }
                    catch (IOException var4_5) {
                        var8_8 = null;
                        if (var3_3 == null) return;
                        try {
                            var3_3.close();
                            return;
                        }
                        catch (IOException var9_12) {
                            return;
                        }
                    }
                }
                catch (Throwable var7_16) {
                    var8_9 = null;
                    if (var3_3 == null) throw var7_16;
                    ** try [egrp 2[TRYBLOCK] [2 : 155->162)] { 
lbl36:
                    // 1 sources

                    var3_3.close();
                    throw var7_16;
lbl38:
                    // 1 sources

                    catch (IOException var9_13) {
                        // empty catch block
                    }
                    throw var7_16;
                }
            }
            ** try [egrp 2[TRYBLOCK] [2 : 155->162)] { 
lbl43:
            // 1 sources

            var3_3.close();
            return;
lbl45:
            // 1 sources

            catch (IOException var9_10) {
                // empty catch block
            }
            return;
        }
        var8_7 = null;
        if (var3_3 == null) return;
        try {}
        catch (IOException var9_11) {}
        var3_3.close();
        return;
    }

    protected void applyManifestGlobalEntry(File file, String string) {
        if (!string.startsWith("Class-Path:")) {
            return;
        }
        this.log("On file " + file + " found Manifest entry:");
        this.log(string);
        File file2 = new File(file.getParent());
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(string.indexOf(":") + 1), " ");
        while (stringTokenizer.hasMoreElements()) {
            File file3 = new File(file2, (String)stringTokenizer.nextElement());
            if (!file3.exists()) continue;
            this.addPathElement(file3);
        }
    }

    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class clazz = this.findLoadedClass(string);
        if (clazz != null) {
            return clazz;
        }
        if (this.isParentFirst(string)) {
            try {
                clazz = this.findBaseClass(string);
                this.log("Class " + string + " loaded from parent loader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = this.findClass(string);
                this.log("Class " + string + " loaded from ant loader");
            }
        } else {
            try {
                clazz = this.findClass(string);
                this.log("Class " + string + " loaded from ant loader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (this.ignoreBase) {
                    throw classNotFoundException;
                }
                clazz = this.findBaseClass(string);
                this.log("Class " + string + " loaded from parent loader");
            }
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    private String getClassFilename(String string) {
        return string.replace('.', '/') + ".class";
    }

    private Class getClassFromStream(InputStream inputStream, String string) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = -1;
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray, 0, 8192)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        if (defineClassProtectionDomain != null) {
            try {
                Object[] objectArray = new Object[]{string, byArray2, new Integer(0), new Integer(byArray2.length), this.getProtectionDomain()};
                return (Class)defineClassProtectionDomain.invoke((Object)this, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof ClassFormatError) {
                    throw (ClassFormatError)throwable;
                }
                if (throwable instanceof NoClassDefFoundError) {
                    throw (NoClassDefFoundError)throwable;
                }
                throw new IOException(throwable.toString());
            }
            catch (Exception exception) {
                throw new IOException(exception.toString());
            }
        }
        return this.defineClass(string, byArray2, 0, byArray2.length);
    }

    protected Object getProtectionDomain() throws Exception {
        return getProtectionDomain.invoke(this.getClass(), new Object[0]);
    }

    public Class findClass(String string) throws ClassNotFoundException {
        this.log("Finding class " + string);
        return this.findClassInComponents(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Class findClassInComponents(String string) throws ClassNotFoundException {
        InputStream inputStream = null;
        String string2 = this.getClassFilename(string);
        try {
            try {
                inputStream = this.loadResource(string2);
                if (inputStream == null) throw new ClassNotFoundException(string);
                Class clazz = this.getClassFromStream(inputStream, string);
                Object var6_6 = null;
                try {
                    if (inputStream == null) return clazz;
                    inputStream.close();
                    return clazz;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return clazz;
            }
            catch (IOException iOException) {
                this.log("Exception reading a component");
                throw new ClassNotFoundException(string);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {}
            catch (IOException iOException) {
                throw throwable;
            }
            if (inputStream == null) throw throwable;
            inputStream.close();
            throw throwable;
        }
    }

    private Class findBaseClass(String string) throws ClassNotFoundException {
        if (this.parent == null) {
            return this.findSystemClass(string);
        }
        return this.parent.loadClass(string);
    }

    public void cleanup() {
        this.pathComponents = null;
        Enumeration enumeration = this.zipFiles.elements();
        while (enumeration.hasMoreElements()) {
            ZipFile zipFile = (ZipFile)enumeration.nextElement();
            try {
                zipFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.zipFiles = new Hashtable();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            getProtectionDomain = (class$java$lang$Class == null ? (class$java$lang$Class = MainClassLoader.class$("java.lang.Class")) : class$java$lang$Class).getMethod("getProtectionDomain", new Class[0]);
            Class<?> clazz = Class.forName("java.security.ProtectionDomain");
            Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = MainClassLoader.class$("java.lang.String")) : class$java$lang$String, array$B == null ? (array$B = MainClassLoader.class$("[B")) : array$B, Integer.TYPE, Integer.TYPE, clazz};
            defineClassProtectionDomain = (class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = MainClassLoader.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).getDeclaredMethod("defineClass", classArray);
            getContextClassLoader = (class$java$lang$Thread == null ? (class$java$lang$Thread = MainClassLoader.class$("java.lang.Thread")) : class$java$lang$Thread).getMethod("getContextClassLoader", new Class[0]);
            classArray = new Class[]{class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = MainClassLoader.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader};
            setContextClassLoader = (class$java$lang$Thread == null ? (class$java$lang$Thread = MainClassLoader.class$("java.lang.Thread")) : class$java$lang$Thread).getMethod("setContextClassLoader", classArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class ResourceEnumeration
    implements Enumeration {
        private String resourceName;
        private int pathElementsIndex;
        private URL nextResource;

        ResourceEnumeration(String string) {
            this.resourceName = string;
            this.pathElementsIndex = 0;
            this.findNextResource();
        }

        public boolean hasMoreElements() {
            return this.nextResource != null;
        }

        public Object nextElement() {
            URL uRL = this.nextResource;
            this.findNextResource();
            return uRL;
        }

        private void findNextResource() {
            URL uRL = null;
            while (this.pathElementsIndex < MainClassLoader.this.pathComponents.size() && uRL == null) {
                try {
                    File file = (File)MainClassLoader.this.pathComponents.elementAt(this.pathElementsIndex);
                    uRL = MainClassLoader.this.getResourceURL(file, this.resourceName);
                    ++this.pathElementsIndex;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.nextResource = uRL;
        }
    }

    public static class LoaderException
    extends RuntimeException {
        private LoaderException(String string) {
            super(string);
        }
    }
}

