/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.classfile;

public abstract class AccessFlags {
    protected int access_flags;

    public AccessFlags() {
    }

    public AccessFlags(int n) {
        this.access_flags = n;
    }

    public final int getAccessFlags() {
        return this.access_flags;
    }

    public final void setAccessFlags(int n) {
        this.access_flags = n;
    }

    private final void setFlag(int n, boolean bl) {
        if ((this.access_flags & n) != 0) {
            if (!bl) {
                this.access_flags ^= n;
            }
        } else if (bl) {
            this.access_flags |= n;
        }
    }

    public final void isPublic(boolean bl) {
        this.setFlag(1, bl);
    }

    public final boolean isPublic() {
        return (this.access_flags & 1) != 0;
    }

    public final void isPrivate(boolean bl) {
        this.setFlag(2, bl);
    }

    public final boolean isPrivate() {
        return (this.access_flags & 2) != 0;
    }

    public final void isProtected(boolean bl) {
        this.setFlag(4, bl);
    }

    public final boolean isProtected() {
        return (this.access_flags & 4) != 0;
    }

    public final void isStatic(boolean bl) {
        this.setFlag(8, bl);
    }

    public final boolean isStatic() {
        return (this.access_flags & 8) != 0;
    }

    public final void isFinal(boolean bl) {
        this.setFlag(16, bl);
    }

    public final boolean isFinal() {
        return (this.access_flags & 0x10) != 0;
    }

    public final void isSynchronized(boolean bl) {
        this.setFlag(32, bl);
    }

    public final boolean isSynchronized() {
        return (this.access_flags & 0x20) != 0;
    }

    public final void isVolatile(boolean bl) {
        this.setFlag(64, bl);
    }

    public final boolean isVolatile() {
        return (this.access_flags & 0x40) != 0;
    }

    public final void isTransient(boolean bl) {
        this.setFlag(128, bl);
    }

    public final boolean isTransient() {
        return (this.access_flags & 0x80) != 0;
    }

    public final void isNative(boolean bl) {
        this.setFlag(256, bl);
    }

    public final boolean isNative() {
        return (this.access_flags & 0x100) != 0;
    }

    public final void isInterface(boolean bl) {
        this.setFlag(512, bl);
    }

    public final boolean isInterface() {
        return (this.access_flags & 0x200) != 0;
    }

    public final void isAbstract(boolean bl) {
        this.setFlag(1024, bl);
    }

    public final boolean isAbstract() {
        return (this.access_flags & 0x400) != 0;
    }

    public final void isStrictfp(boolean bl) {
        this.setFlag(2048, bl);
    }

    public final boolean isStrictfp() {
        return (this.access_flags & 0x800) != 0;
    }
}

