/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.classfile;

import de.fub.bytecode.Constants;
import de.fub.bytecode.classfile.Code;
import de.fub.bytecode.classfile.ConstantPool;
import de.fub.bytecode.classfile.ConstantUtf8;
import de.fub.bytecode.classfile.ConstantValue;
import de.fub.bytecode.classfile.Deprecated;
import de.fub.bytecode.classfile.ExceptionTable;
import de.fub.bytecode.classfile.InnerClasses;
import de.fub.bytecode.classfile.LineNumberTable;
import de.fub.bytecode.classfile.LocalVariableTable;
import de.fub.bytecode.classfile.Node;
import de.fub.bytecode.classfile.PMGClass;
import de.fub.bytecode.classfile.Signature;
import de.fub.bytecode.classfile.SourceFile;
import de.fub.bytecode.classfile.StackMap;
import de.fub.bytecode.classfile.Synthetic;
import de.fub.bytecode.classfile.Unknown;
import de.fub.bytecode.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class Attribute
implements Cloneable,
Node {
    protected int name_index;
    protected int length;
    protected byte tag;
    protected ConstantPool constant_pool;

    Attribute(byte by, int n, int n2, ConstantPool constantPool) {
        this.tag = by;
        this.name_index = n;
        this.length = n2;
        this.constant_pool = constantPool;
    }

    public abstract void accept(Visitor var1);

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.name_index);
        dataOutputStream.writeInt(this.length);
    }

    static final Attribute readAttribute(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException, ClassFormatError, InternalError {
        int n = -1;
        int n2 = dataInputStream.readUnsignedShort();
        ConstantUtf8 constantUtf8 = (ConstantUtf8)constantPool.getConstant(n2, (byte)1);
        String string = constantUtf8.getBytes();
        int n3 = dataInputStream.readInt();
        int n4 = 0;
        while (n4 < 12) {
            if (string.equals(Constants.ATTRIBUTE_NAMES[n4])) {
                n = n4;
                break;
            }
            n4 = (byte)(n4 + 1);
        }
        switch (n) {
            case -1: {
                return new Unknown(n2, n3, dataInputStream, constantPool);
            }
            case 1: {
                return new ConstantValue(n2, n3, dataInputStream, constantPool);
            }
            case 0: {
                return new SourceFile(n2, n3, dataInputStream, constantPool);
            }
            case 2: {
                return new Code(n2, n3, dataInputStream, constantPool);
            }
            case 3: {
                return new ExceptionTable(n2, n3, dataInputStream, constantPool);
            }
            case 4: {
                return new LineNumberTable(n2, n3, dataInputStream, constantPool);
            }
            case 5: {
                return new LocalVariableTable(n2, n3, dataInputStream, constantPool);
            }
            case 6: {
                return new InnerClasses(n2, n3, dataInputStream, constantPool);
            }
            case 7: {
                return new Synthetic(n2, n3, dataInputStream, constantPool);
            }
            case 8: {
                return new Deprecated(n2, n3, dataInputStream, constantPool);
            }
            case 9: {
                return new PMGClass(n2, n3, dataInputStream, constantPool);
            }
            case 10: {
                return new Signature(n2, n3, dataInputStream, constantPool);
            }
            case 11: {
                return new StackMap(n2, n3, dataInputStream, constantPool);
            }
        }
        throw new InternalError("Ooops! default case reached.");
    }

    public final int getLength() {
        return this.length;
    }

    public final void setLength(int n) {
        this.length = n;
    }

    public final void setNameIndex(int n) {
        this.name_index = n;
    }

    public final int getNameIndex() {
        return this.name_index;
    }

    public final byte getTag() {
        return this.tag;
    }

    public final ConstantPool getConstantPool() {
        return this.constant_pool;
    }

    public final void setConstantPool(ConstantPool constantPool) {
        this.constant_pool = constantPool;
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        return object;
    }

    public abstract Attribute copy(ConstantPool var1);

    public String toString() {
        return Constants.ATTRIBUTE_NAMES[this.tag];
    }
}

