/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.classfile;

import de.fub.bytecode.classfile.Attribute;
import de.fub.bytecode.classfile.CodeException;
import de.fub.bytecode.classfile.ConstantPool;
import de.fub.bytecode.classfile.LineNumberTable;
import de.fub.bytecode.classfile.LocalVariableTable;
import de.fub.bytecode.classfile.Utility;
import de.fub.bytecode.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class Code
extends Attribute {
    private int max_stack;
    private int max_locals;
    private int code_length;
    private byte[] code;
    private int exception_table_length;
    private CodeException[] exception_table;
    private int attributes_count;
    private Attribute[] attributes;

    public Code(Code code) {
        this(code.getNameIndex(), code.getLength(), code.getMaxStack(), code.getMaxLocals(), code.getCode(), code.getExceptionTable(), code.getAttributes(), code.getConstantPool());
    }

    Code(int n, int n2, DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this(n, n2, dataInputStream.readUnsignedShort(), dataInputStream.readUnsignedShort(), null, null, null, constantPool);
        this.code_length = dataInputStream.readInt();
        this.code = new byte[this.code_length];
        dataInputStream.readFully(this.code);
        this.exception_table_length = dataInputStream.readUnsignedShort();
        this.exception_table = new CodeException[this.exception_table_length];
        int n3 = 0;
        while (n3 < this.exception_table_length) {
            this.exception_table[n3] = new CodeException(dataInputStream);
            ++n3;
        }
        this.attributes_count = dataInputStream.readUnsignedShort();
        this.attributes = new Attribute[this.attributes_count];
        int n4 = 0;
        while (n4 < this.attributes_count) {
            this.attributes[n4] = Attribute.readAttribute(dataInputStream, constantPool);
            ++n4;
        }
        this.length = n2;
    }

    public Code(int n, int n2, int n3, int n4, byte[] byArray, CodeException[] codeExceptionArray, Attribute[] attributeArray, ConstantPool constantPool) {
        super((byte)2, n, n2, constantPool);
        this.max_stack = n3;
        this.max_locals = n4;
        this.setCode(byArray);
        this.setExceptionTable(codeExceptionArray);
        this.setAttributes(attributeArray);
    }

    public void accept(Visitor visitor) {
        visitor.visitCode(this);
    }

    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.max_stack);
        dataOutputStream.writeShort(this.max_locals);
        dataOutputStream.writeInt(this.code_length);
        dataOutputStream.write(this.code, 0, this.code_length);
        dataOutputStream.writeShort(this.exception_table_length);
        int n = 0;
        while (n < this.exception_table_length) {
            this.exception_table[n].dump(dataOutputStream);
            ++n;
        }
        dataOutputStream.writeShort(this.attributes_count);
        int n2 = 0;
        while (n2 < this.attributes_count) {
            this.attributes[n2].dump(dataOutputStream);
            ++n2;
        }
    }

    public final Attribute[] getAttributes() {
        return this.attributes;
    }

    public LineNumberTable getLineNumberTable() {
        int n = 0;
        while (n < this.attributes_count) {
            if (this.attributes[n] instanceof LineNumberTable) {
                return (LineNumberTable)this.attributes[n];
            }
            ++n;
        }
        return null;
    }

    public LocalVariableTable getLocalVariableTable() {
        int n = 0;
        while (n < this.attributes_count) {
            if (this.attributes[n] instanceof LocalVariableTable) {
                return (LocalVariableTable)this.attributes[n];
            }
            ++n;
        }
        return null;
    }

    public final byte[] getCode() {
        return this.code;
    }

    public final CodeException[] getExceptionTable() {
        return this.exception_table;
    }

    public final int getMaxLocals() {
        return this.max_locals;
    }

    public final int getMaxStack() {
        return this.max_stack;
    }

    private final int getInternalLength() {
        return 8 + this.code_length + 2 + 8 * this.exception_table_length + 2;
    }

    private final int calculateLength() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.attributes_count) {
            n += this.attributes[n2].length + 6;
            ++n2;
        }
        return n + this.getInternalLength();
    }

    public final void setAttributes(Attribute[] attributeArray) {
        this.attributes = attributeArray;
        this.attributes_count = attributeArray == null ? 0 : attributeArray.length;
        this.length = this.calculateLength();
    }

    public final void setCode(byte[] byArray) {
        this.code = byArray;
        this.code_length = byArray == null ? 0 : byArray.length;
    }

    public final void setExceptionTable(CodeException[] codeExceptionArray) {
        this.exception_table = codeExceptionArray;
        this.exception_table_length = codeExceptionArray == null ? 0 : codeExceptionArray.length;
    }

    public final void setMaxLocals(int n) {
        this.max_locals = n;
    }

    public final void setMaxStack(int n) {
        this.max_stack = n;
    }

    public final String toString(boolean bl) {
        int n;
        StringBuffer stringBuffer = new StringBuffer("Code(max_stack = " + this.max_stack + ", max_locals = " + this.max_locals + ", code_length = " + this.code_length + ")\n" + Utility.codeToString(this.code, this.constant_pool, 0, -1, bl));
        if (this.exception_table_length > 0) {
            stringBuffer.append("\nException handler(s) = \nFrom\tTo\tHandler\tType\n");
            n = 0;
            while (n < this.exception_table_length) {
                stringBuffer.append(this.exception_table[n].toString(this.constant_pool, bl) + "\n");
                ++n;
            }
        }
        if (this.attributes_count > 0) {
            stringBuffer.append("\nAttribute(s) = \n");
            n = 0;
            while (n < this.attributes_count) {
                stringBuffer.append(this.attributes[n].toString() + "\n");
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public final String toString() {
        return this.toString(true);
    }

    public Attribute copy(ConstantPool constantPool) {
        Code code = (Code)this.clone();
        code.code = (byte[])this.code.clone();
        code.constant_pool = constantPool;
        code.exception_table = new CodeException[this.exception_table_length];
        int n = 0;
        while (n < this.exception_table_length) {
            code.exception_table[n] = this.exception_table[n].copy();
            ++n;
        }
        code.attributes = new Attribute[this.attributes_count];
        int n2 = 0;
        while (n2 < this.attributes_count) {
            code.attributes[n2] = this.attributes[n2].copy(constantPool);
            ++n2;
        }
        return code;
    }
}

