/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.classfile;

import de.fub.bytecode.classfile.Constant;
import de.fub.bytecode.classfile.ConstantObject;
import de.fub.bytecode.classfile.ConstantPool;
import de.fub.bytecode.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ConstantDouble
extends Constant
implements ConstantObject {
    private double bytes;

    public ConstantDouble(double d) {
        super((byte)6);
        this.bytes = d;
    }

    public ConstantDouble(ConstantDouble constantDouble) {
        this(constantDouble.getBytes());
    }

    ConstantDouble(DataInputStream dataInputStream) throws IOException {
        this(dataInputStream.readDouble());
    }

    public void accept(Visitor visitor) {
        visitor.visitConstantDouble(this);
    }

    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.tag);
        dataOutputStream.writeDouble(this.bytes);
    }

    public final double getBytes() {
        return this.bytes;
    }

    public final void setBytes(double d) {
        this.bytes = d;
    }

    public final String toString() {
        return super.toString() + "(bytes = " + this.bytes + ")";
    }

    public Object getConstantValue(ConstantPool constantPool) {
        return new Double(this.bytes);
    }
}

