/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.classfile;

import de.fub.bytecode.classfile.Constant;
import de.fub.bytecode.classfile.ConstantObject;
import de.fub.bytecode.classfile.ConstantPool;
import de.fub.bytecode.classfile.ConstantUtf8;
import de.fub.bytecode.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ConstantString
extends Constant
implements ConstantObject {
    private int string_index;

    public ConstantString(ConstantString constantString) {
        this(constantString.getStringIndex());
    }

    ConstantString(DataInputStream dataInputStream) throws IOException {
        this(dataInputStream.readUnsignedShort());
    }

    public ConstantString(int n) {
        super((byte)8);
        this.string_index = n;
    }

    public void accept(Visitor visitor) {
        visitor.visitConstantString(this);
    }

    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.tag);
        dataOutputStream.writeShort(this.string_index);
    }

    public final int getStringIndex() {
        return this.string_index;
    }

    public final void setStringIndex(int n) {
        this.string_index = n;
    }

    public final String toString() {
        return super.toString() + "(string_index = " + this.string_index + ")";
    }

    public Object getConstantValue(ConstantPool constantPool) {
        Constant constant = constantPool.getConstant(this.string_index, (byte)1);
        return ((ConstantUtf8)constant).getBytes();
    }

    public String getBytes(ConstantPool constantPool) {
        return (String)this.getConstantValue(constantPool);
    }
}

