/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.classfile;

import de.fub.bytecode.classfile.Attribute;
import de.fub.bytecode.classfile.Code;
import de.fub.bytecode.classfile.CodeException;
import de.fub.bytecode.classfile.Constant;
import de.fub.bytecode.classfile.ConstantClass;
import de.fub.bytecode.classfile.ConstantDouble;
import de.fub.bytecode.classfile.ConstantFieldref;
import de.fub.bytecode.classfile.ConstantFloat;
import de.fub.bytecode.classfile.ConstantInteger;
import de.fub.bytecode.classfile.ConstantInterfaceMethodref;
import de.fub.bytecode.classfile.ConstantLong;
import de.fub.bytecode.classfile.ConstantMethodref;
import de.fub.bytecode.classfile.ConstantNameAndType;
import de.fub.bytecode.classfile.ConstantPool;
import de.fub.bytecode.classfile.ConstantString;
import de.fub.bytecode.classfile.ConstantUtf8;
import de.fub.bytecode.classfile.ConstantValue;
import de.fub.bytecode.classfile.Deprecated;
import de.fub.bytecode.classfile.ExceptionTable;
import de.fub.bytecode.classfile.Field;
import de.fub.bytecode.classfile.InnerClass;
import de.fub.bytecode.classfile.InnerClasses;
import de.fub.bytecode.classfile.JavaClass;
import de.fub.bytecode.classfile.LineNumber;
import de.fub.bytecode.classfile.LineNumberTable;
import de.fub.bytecode.classfile.LocalVariable;
import de.fub.bytecode.classfile.LocalVariableTable;
import de.fub.bytecode.classfile.Method;
import de.fub.bytecode.classfile.SourceFile;
import de.fub.bytecode.classfile.StackMap;
import de.fub.bytecode.classfile.StackMapEntry;
import de.fub.bytecode.classfile.Synthetic;
import de.fub.bytecode.classfile.Unknown;
import de.fub.bytecode.classfile.Visitor;
import java.util.Stack;

public class DescendingVisitor
implements Visitor {
    private JavaClass clazz;
    private Visitor visitor;
    private Stack stack = new Stack();

    public Object predecessor() {
        return this.predecessor(0);
    }

    public Object predecessor(int n) {
        int n2 = this.stack.size();
        if (n2 < 2 || n < 0) {
            return null;
        }
        return this.stack.elementAt(n2 - (n + 2));
    }

    public Object current() {
        return this.stack.peek();
    }

    public DescendingVisitor(JavaClass javaClass, Visitor visitor) {
        this.clazz = javaClass;
        this.visitor = visitor;
    }

    public void visit() {
        this.clazz.accept(this);
    }

    public void visitJavaClass(JavaClass javaClass) {
        this.stack.push(javaClass);
        javaClass.accept(this.visitor);
        Field[] fieldArray = javaClass.getFields();
        int n = 0;
        while (n < fieldArray.length) {
            fieldArray[n].accept(this);
            ++n;
        }
        Method[] methodArray = javaClass.getMethods();
        int n2 = 0;
        while (n2 < methodArray.length) {
            methodArray[n2].accept(this);
            ++n2;
        }
        Attribute[] attributeArray = javaClass.getAttributes();
        int n3 = 0;
        while (n3 < attributeArray.length) {
            attributeArray[n3].accept(this);
            ++n3;
        }
        javaClass.getConstantPool().accept(this);
        this.stack.pop();
    }

    public void visitField(Field field) {
        this.stack.push(field);
        field.accept(this.visitor);
        Attribute[] attributeArray = field.getAttributes();
        int n = 0;
        while (n < attributeArray.length) {
            attributeArray[n].accept(this);
            ++n;
        }
        this.stack.pop();
    }

    public void visitConstantValue(ConstantValue constantValue) {
        this.stack.push(constantValue);
        constantValue.accept(this.visitor);
        this.stack.pop();
    }

    public void visitMethod(Method method) {
        this.stack.push(method);
        method.accept(this.visitor);
        Attribute[] attributeArray = method.getAttributes();
        int n = 0;
        while (n < attributeArray.length) {
            attributeArray[n].accept(this);
            ++n;
        }
        this.stack.pop();
    }

    public void visitExceptionTable(ExceptionTable exceptionTable) {
        this.stack.push(exceptionTable);
        exceptionTable.accept(this.visitor);
        this.stack.pop();
    }

    public void visitCode(Code code) {
        this.stack.push(code);
        code.accept(this.visitor);
        CodeException[] codeExceptionArray = code.getExceptionTable();
        int n = 0;
        while (n < codeExceptionArray.length) {
            codeExceptionArray[n].accept(this);
            ++n;
        }
        Attribute[] attributeArray = code.getAttributes();
        int n2 = 0;
        while (n2 < attributeArray.length) {
            attributeArray[n2].accept(this);
            ++n2;
        }
        this.stack.pop();
    }

    public void visitCodeException(CodeException codeException) {
        this.stack.push(codeException);
        codeException.accept(this.visitor);
        this.stack.pop();
    }

    public void visitLineNumberTable(LineNumberTable lineNumberTable) {
        this.stack.push(lineNumberTable);
        lineNumberTable.accept(this.visitor);
        LineNumber[] lineNumberArray = lineNumberTable.getLineNumberTable();
        int n = 0;
        while (n < lineNumberArray.length) {
            lineNumberArray[n].accept(this);
            ++n;
        }
        this.stack.pop();
    }

    public void visitLineNumber(LineNumber lineNumber) {
        this.stack.push(lineNumber);
        lineNumber.accept(this.visitor);
        this.stack.pop();
    }

    public void visitLocalVariableTable(LocalVariableTable localVariableTable) {
        this.stack.push(localVariableTable);
        localVariableTable.accept(this.visitor);
        LocalVariable[] localVariableArray = localVariableTable.getLocalVariableTable();
        int n = 0;
        while (n < localVariableArray.length) {
            localVariableArray[n].accept(this);
            ++n;
        }
        this.stack.pop();
    }

    public void visitStackMap(StackMap stackMap) {
        this.stack.push(stackMap);
        stackMap.accept(this.visitor);
        StackMapEntry[] stackMapEntryArray = stackMap.getStackMap();
        int n = 0;
        while (n < stackMapEntryArray.length) {
            stackMapEntryArray[n].accept(this);
            ++n;
        }
        this.stack.pop();
    }

    public void visitStackMapEntry(StackMapEntry stackMapEntry) {
        this.stack.push(stackMapEntry);
        stackMapEntry.accept(this.visitor);
        this.stack.pop();
    }

    public void visitLocalVariable(LocalVariable localVariable) {
        this.stack.push(localVariable);
        localVariable.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantPool(ConstantPool constantPool) {
        this.stack.push(constantPool);
        constantPool.accept(this.visitor);
        Constant[] constantArray = constantPool.getConstantPool();
        int n = 1;
        while (n < constantArray.length) {
            if (constantArray[n] != null) {
                constantArray[n].accept(this);
            }
            ++n;
        }
        this.stack.pop();
    }

    public void visitConstantClass(ConstantClass constantClass) {
        this.stack.push(constantClass);
        constantClass.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantDouble(ConstantDouble constantDouble) {
        this.stack.push(constantDouble);
        constantDouble.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantFieldref(ConstantFieldref constantFieldref) {
        this.stack.push(constantFieldref);
        constantFieldref.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantFloat(ConstantFloat constantFloat) {
        this.stack.push(constantFloat);
        constantFloat.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantInteger(ConstantInteger constantInteger) {
        this.stack.push(constantInteger);
        constantInteger.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantInterfaceMethodref(ConstantInterfaceMethodref constantInterfaceMethodref) {
        this.stack.push(constantInterfaceMethodref);
        constantInterfaceMethodref.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantLong(ConstantLong constantLong) {
        this.stack.push(constantLong);
        constantLong.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantMethodref(ConstantMethodref constantMethodref) {
        this.stack.push(constantMethodref);
        constantMethodref.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantNameAndType(ConstantNameAndType constantNameAndType) {
        this.stack.push(constantNameAndType);
        constantNameAndType.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantString(ConstantString constantString) {
        this.stack.push(constantString);
        constantString.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantUtf8(ConstantUtf8 constantUtf8) {
        this.stack.push(constantUtf8);
        constantUtf8.accept(this.visitor);
        this.stack.pop();
    }

    public void visitInnerClasses(InnerClasses innerClasses) {
        this.stack.push(innerClasses);
        innerClasses.accept(this.visitor);
        InnerClass[] innerClassArray = innerClasses.getInnerClasses();
        int n = 0;
        while (n < innerClassArray.length) {
            innerClassArray[n].accept(this);
            ++n;
        }
        this.stack.pop();
    }

    public void visitInnerClass(InnerClass innerClass) {
        this.stack.push(innerClass);
        innerClass.accept(this.visitor);
        this.stack.pop();
    }

    public void visitDeprecated(Deprecated deprecated) {
        this.stack.push(deprecated);
        deprecated.accept(this.visitor);
        this.stack.pop();
    }

    public void visitSourceFile(SourceFile sourceFile) {
        this.stack.push(sourceFile);
        sourceFile.accept(this.visitor);
        this.stack.pop();
    }

    public void visitSynthetic(Synthetic synthetic) {
        this.stack.push(synthetic);
        synthetic.accept(this.visitor);
        this.stack.pop();
    }

    public void visitUnknown(Unknown unknown) {
        this.stack.push(unknown);
        unknown.accept(this.visitor);
        this.stack.pop();
    }
}

