/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.classfile;

import de.fub.bytecode.classfile.Attribute;
import de.fub.bytecode.classfile.ConstantPool;
import de.fub.bytecode.classfile.Utility;
import de.fub.bytecode.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ExceptionTable
extends Attribute {
    private int number_of_exceptions;
    private int[] exception_index_table;

    public ExceptionTable(ExceptionTable exceptionTable) {
        this(exceptionTable.getNameIndex(), exceptionTable.getLength(), exceptionTable.getExceptionIndexTable(), exceptionTable.getConstantPool());
    }

    public ExceptionTable(int n, int n2, int[] nArray, ConstantPool constantPool) {
        super((byte)3, n, n2, constantPool);
        this.setExceptionIndexTable(nArray);
    }

    ExceptionTable(int n, int n2, DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this(n, n2, (int[])null, constantPool);
        this.number_of_exceptions = dataInputStream.readUnsignedShort();
        this.exception_index_table = new int[this.number_of_exceptions];
        int n3 = 0;
        while (n3 < this.number_of_exceptions) {
            this.exception_index_table[n3] = dataInputStream.readUnsignedShort();
            ++n3;
        }
    }

    public void accept(Visitor visitor) {
        visitor.visitExceptionTable(this);
    }

    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.number_of_exceptions);
        int n = 0;
        while (n < this.number_of_exceptions) {
            dataOutputStream.writeShort(this.exception_index_table[n]);
            ++n;
        }
    }

    public final int[] getExceptionIndexTable() {
        return this.exception_index_table;
    }

    public final int getNumberOfExceptions() {
        return this.number_of_exceptions;
    }

    public final String[] getExceptionNames() {
        String[] stringArray = new String[this.number_of_exceptions];
        int n = 0;
        while (n < this.number_of_exceptions) {
            stringArray[n] = this.constant_pool.getConstantString(this.exception_index_table[n], (byte)7).replace('/', '.');
            ++n;
        }
        return stringArray;
    }

    public final void setExceptionIndexTable(int[] nArray) {
        this.exception_index_table = nArray;
        this.number_of_exceptions = nArray == null ? 0 : nArray.length;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        while (n < this.number_of_exceptions) {
            String string = this.constant_pool.getConstantString(this.exception_index_table[n], (byte)7);
            stringBuffer.append(Utility.compactClassName(string, false));
            if (n < this.number_of_exceptions - 1) {
                stringBuffer.append(", ");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public Attribute copy(ConstantPool constantPool) {
        ExceptionTable exceptionTable = (ExceptionTable)this.clone();
        exceptionTable.exception_index_table = (int[])this.exception_index_table.clone();
        exceptionTable.constant_pool = constantPool;
        return exceptionTable;
    }
}

