/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.classfile;

import de.fub.bytecode.classfile.Attribute;
import de.fub.bytecode.classfile.ConstantPool;
import de.fub.bytecode.classfile.InnerClass;
import de.fub.bytecode.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class InnerClasses
extends Attribute {
    private InnerClass[] inner_classes;
    private int number_of_classes;

    public InnerClasses(InnerClasses innerClasses) {
        this(innerClasses.getNameIndex(), innerClasses.getLength(), innerClasses.getInnerClasses(), innerClasses.getConstantPool());
    }

    public InnerClasses(int n, int n2, InnerClass[] innerClassArray, ConstantPool constantPool) {
        super((byte)6, n, n2, constantPool);
        this.setInnerClasses(innerClassArray);
    }

    InnerClasses(int n, int n2, DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this(n, n2, (InnerClass[])null, constantPool);
        this.number_of_classes = dataInputStream.readUnsignedShort();
        this.inner_classes = new InnerClass[this.number_of_classes];
        int n3 = 0;
        while (n3 < this.number_of_classes) {
            this.inner_classes[n3] = new InnerClass(dataInputStream);
            ++n3;
        }
    }

    public void accept(Visitor visitor) {
        visitor.visitInnerClasses(this);
    }

    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.number_of_classes);
        int n = 0;
        while (n < this.number_of_classes) {
            this.inner_classes[n].dump(dataOutputStream);
            ++n;
        }
    }

    public final InnerClass[] getInnerClasses() {
        return this.inner_classes;
    }

    public final void setInnerClasses(InnerClass[] innerClassArray) {
        this.inner_classes = innerClassArray;
        this.number_of_classes = innerClassArray == null ? 0 : innerClassArray.length;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.number_of_classes) {
            stringBuffer.append(this.inner_classes[n].toString(this.constant_pool) + "\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    public Attribute copy(ConstantPool constantPool) {
        InnerClasses innerClasses = (InnerClasses)this.clone();
        innerClasses.inner_classes = new InnerClass[this.number_of_classes];
        int n = 0;
        while (n < this.number_of_classes) {
            innerClasses.inner_classes[n] = this.inner_classes[n].copy();
            ++n;
        }
        innerClasses.constant_pool = constantPool;
        return innerClasses;
    }
}

