/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.classfile;

import de.fub.bytecode.Repository;
import de.fub.bytecode.classfile.AccessFlags;
import de.fub.bytecode.classfile.Attribute;
import de.fub.bytecode.classfile.ConstantPool;
import de.fub.bytecode.classfile.Field;
import de.fub.bytecode.classfile.Method;
import de.fub.bytecode.classfile.Node;
import de.fub.bytecode.classfile.SourceFile;
import de.fub.bytecode.classfile.Utility;
import de.fub.bytecode.classfile.Visitor;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.StringTokenizer;

public class JavaClass
extends AccessFlags
implements Cloneable,
Node {
    private String file_name;
    private String package_name;
    private String source_file_name = "<Unknown>";
    private int class_name_index;
    private int superclass_name_index;
    private String class_name;
    private String superclass_name;
    private int major;
    private int minor;
    private ConstantPool constant_pool;
    private int[] interfaces;
    private String[] interface_names;
    private Field[] fields;
    private Method[] methods;
    private Attribute[] attributes;
    private byte source = 1;
    public static final byte HEAP = 1;
    public static final byte FILE = 2;
    public static final byte ZIP = 3;
    static boolean debug;
    static char sep;

    public JavaClass(int n, int n2, String string, int n3, int n4, int n5, ConstantPool constantPool, int[] nArray, Field[] fieldArray, Method[] methodArray, Attribute[] attributeArray, byte by) {
        if (nArray == null) {
            nArray = new int[]{};
        }
        if (attributeArray == null) {
            this.attributes = new Attribute[0];
        }
        if (fieldArray == null) {
            fieldArray = new Field[]{};
        }
        if (methodArray == null) {
            methodArray = new Method[]{};
        }
        this.class_name_index = n;
        this.superclass_name_index = n2;
        this.file_name = string;
        this.major = n3;
        this.minor = n4;
        this.access_flags = n5;
        this.constant_pool = constantPool;
        this.interfaces = nArray;
        this.fields = fieldArray;
        this.methods = methodArray;
        this.attributes = attributeArray;
        this.source = by;
        int n6 = 0;
        while (n6 < attributeArray.length) {
            if (attributeArray[n6] instanceof SourceFile) {
                this.source_file_name = ((SourceFile)attributeArray[n6]).getSourceFileName();
                break;
            }
            ++n6;
        }
        this.class_name = constantPool.getConstantString(n, (byte)7);
        this.class_name = Utility.compactClassName(this.class_name, false);
        int n7 = this.class_name.lastIndexOf(46);
        this.package_name = n7 < 0 ? "" : this.class_name.substring(0, n7);
        if (n2 > 0) {
            this.superclass_name = constantPool.getConstantString(n2, (byte)7);
            this.superclass_name = Utility.compactClassName(this.superclass_name, false);
        } else {
            this.superclass_name = "java.lang.Object";
        }
        this.interface_names = new String[nArray.length];
        int n8 = 0;
        while (n8 < nArray.length) {
            String string2 = constantPool.getConstantString(nArray[n8], (byte)7);
            this.interface_names[n8] = Utility.compactClassName(string2, false);
            ++n8;
        }
    }

    public JavaClass(int n, int n2, String string, int n3, int n4, int n5, ConstantPool constantPool, int[] nArray, Field[] fieldArray, Method[] methodArray, Attribute[] attributeArray) {
        this(n, n2, string, n3, n4, n5, constantPool, nArray, fieldArray, methodArray, attributeArray, 1);
    }

    public void accept(Visitor visitor) {
        visitor.visitJavaClass(this);
    }

    static final void Debug(String string) {
        if (debug) {
            System.out.println(string);
        }
    }

    public void dump(File file) throws IOException {
        File file2;
        String string = file.getParent();
        if (string != null && (file2 = new File(string)) != null) {
            file2.mkdirs();
        }
        this.dump(new DataOutputStream(new FileOutputStream(file)));
    }

    public void dump(String string) throws IOException {
        this.dump(new File(string));
    }

    public byte[] getBytes() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            this.dump(dataOutputStream);
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void dump(OutputStream outputStream) throws IOException {
        this.dump(new DataOutputStream(outputStream));
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(-889275714);
        dataOutputStream.writeShort(this.minor);
        dataOutputStream.writeShort(this.major);
        this.constant_pool.dump(dataOutputStream);
        dataOutputStream.writeShort(this.access_flags);
        dataOutputStream.writeShort(this.class_name_index);
        dataOutputStream.writeShort(this.superclass_name_index);
        dataOutputStream.writeShort(this.interfaces.length);
        int n = 0;
        while (n < this.interfaces.length) {
            dataOutputStream.writeShort(this.interfaces[n]);
            ++n;
        }
        dataOutputStream.writeShort(this.fields.length);
        int n2 = 0;
        while (n2 < this.fields.length) {
            this.fields[n2].dump(dataOutputStream);
            ++n2;
        }
        dataOutputStream.writeShort(this.methods.length);
        int n3 = 0;
        while (n3 < this.methods.length) {
            this.methods[n3].dump(dataOutputStream);
            ++n3;
        }
        if (this.attributes != null) {
            dataOutputStream.writeShort(this.attributes.length);
            int n4 = 0;
            while (n4 < this.attributes.length) {
                this.attributes[n4].dump(dataOutputStream);
                ++n4;
            }
        } else {
            dataOutputStream.writeShort(0);
        }
        dataOutputStream.close();
    }

    public Attribute[] getAttributes() {
        return this.attributes;
    }

    public String getClassName() {
        return this.class_name;
    }

    public String getPackageName() {
        return this.package_name;
    }

    public int getClassNameIndex() {
        return this.class_name_index;
    }

    public ConstantPool getConstantPool() {
        return this.constant_pool;
    }

    public Field[] getFields() {
        return this.fields;
    }

    public String getFileName() {
        return this.file_name;
    }

    public String[] getInterfaceNames() {
        return this.interface_names;
    }

    public int[] getInterfaces() {
        return this.interfaces;
    }

    public int getMajor() {
        return this.major;
    }

    public Method[] getMethods() {
        return this.methods;
    }

    public int getMinor() {
        return this.minor;
    }

    public String getSourceFileName() {
        return this.source_file_name;
    }

    public String getSuperclassName() {
        return this.superclass_name;
    }

    public int getSuperclassNameIndex() {
        return this.superclass_name_index;
    }

    public void setAttributes(Attribute[] attributeArray) {
        this.attributes = attributeArray;
    }

    public void setClassName(String string) {
        this.class_name = string;
    }

    public void setClassNameIndex(int n) {
        this.class_name_index = n;
    }

    public void setConstantPool(ConstantPool constantPool) {
        this.constant_pool = constantPool;
    }

    public void setFields(Field[] fieldArray) {
        this.fields = fieldArray;
    }

    public void setFileName(String string) {
        this.file_name = string;
    }

    public void setInterfaceNames(String[] stringArray) {
        this.interface_names = stringArray;
    }

    public void setInterfaces(int[] nArray) {
        this.interfaces = nArray;
    }

    public void setMajor(int n) {
        this.major = n;
    }

    public void setMethods(Method[] methodArray) {
        this.methods = methodArray;
    }

    public void setMinor(int n) {
        this.minor = n;
    }

    public void setSourceFileName(String string) {
        this.source_file_name = string;
    }

    public void setSuperclassName(String string) {
        this.superclass_name = string;
    }

    public void setSuperclassNameIndex(int n) {
        this.superclass_name_index = n;
    }

    public String toString() {
        int n;
        String string = Utility.accessToString(this.access_flags, true);
        string = string.equals("") ? "" : string + " ";
        StringBuffer stringBuffer = new StringBuffer(string + Utility.classOrInterface(this.access_flags) + " " + this.class_name + " extends " + Utility.compactClassName(this.superclass_name, false) + '\n');
        int n2 = this.interfaces.length;
        if (n2 > 0) {
            stringBuffer.append("implements\t\t");
            n = 0;
            while (n < n2) {
                stringBuffer.append(this.interface_names[n]);
                if (n < n2 - 1) {
                    stringBuffer.append(", ");
                }
                ++n;
            }
            stringBuffer.append('\n');
        }
        stringBuffer.append("filename\t\t" + this.file_name + '\n');
        stringBuffer.append("compiled from\t\t" + this.source_file_name + '\n');
        stringBuffer.append("compiler version\t" + this.major + "." + this.minor + '\n');
        stringBuffer.append("access flags\t\t" + this.access_flags + '\n');
        stringBuffer.append("constant pool\t\t" + this.constant_pool.getLength() + " entries\n");
        stringBuffer.append("ACC_SUPER flag\t\t" + this.isSuper() + "\n");
        if (this.attributes.length > 0) {
            stringBuffer.append("\nAttribute(s):\n");
            n = 0;
            while (n < this.attributes.length) {
                stringBuffer.append(JavaClass.indent(this.attributes[n]));
                ++n;
            }
        }
        if (this.fields.length > 0) {
            stringBuffer.append("\n" + this.fields.length + " fields:\n");
            n = 0;
            while (n < this.fields.length) {
                stringBuffer.append("\t" + this.fields[n] + '\n');
                ++n;
            }
        }
        if (this.methods.length > 0) {
            stringBuffer.append("\n" + this.methods.length + " methods:\n");
            n = 0;
            while (n < this.methods.length) {
                stringBuffer.append("\t" + this.methods[n] + '\n');
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    private static final String indent(Object object) {
        StringTokenizer stringTokenizer = new StringTokenizer(object.toString(), "\n");
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append("\t" + stringTokenizer.nextToken() + "\n");
        }
        return stringBuffer.toString();
    }

    public JavaClass copy() {
        JavaClass javaClass = null;
        try {
            javaClass = (JavaClass)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        javaClass.constant_pool = this.constant_pool.copy();
        javaClass.interfaces = (int[])this.interfaces.clone();
        javaClass.interface_names = (String[])this.interface_names.clone();
        javaClass.fields = new Field[this.fields.length];
        int n = 0;
        while (n < this.fields.length) {
            javaClass.fields[n] = this.fields[n].copy(javaClass.constant_pool);
            ++n;
        }
        javaClass.methods = new Method[this.methods.length];
        int n2 = 0;
        while (n2 < this.methods.length) {
            javaClass.methods[n2] = this.methods[n2].copy(javaClass.constant_pool);
            ++n2;
        }
        javaClass.attributes = new Attribute[this.attributes.length];
        int n3 = 0;
        while (n3 < this.attributes.length) {
            javaClass.attributes[n3] = this.attributes[n3].copy(javaClass.constant_pool);
            ++n3;
        }
        return javaClass;
    }

    public final boolean instanceOf(JavaClass javaClass) {
        return Repository.instanceOf(this, javaClass);
    }

    public final boolean isSuper() {
        return (this.access_flags & 0x20) != 0;
    }

    public final boolean isClass() {
        return (this.access_flags & 0x200) == 0;
    }

    public final byte getSource() {
        return this.source;
    }

    static {
        String string;
        debug = false;
        sep = (char)47;
        String string2 = System.getProperty("JavaClass.debug");
        if (string2 != null) {
            debug = new Boolean(string2);
        }
        if ((string = System.getProperty("file.separator")) != null) {
            try {
                sep = string.charAt(0);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
        }
    }
}

