/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.classfile;

import de.fub.bytecode.classfile.Attribute;
import de.fub.bytecode.classfile.ConstantPool;
import de.fub.bytecode.classfile.ConstantUtf8;
import de.fub.bytecode.classfile.Visitor;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class Signature
extends Attribute {
    private int signature_index;

    public Signature(Signature signature) {
        this(signature.getNameIndex(), signature.getLength(), signature.getSignatureIndex(), signature.getConstantPool());
    }

    Signature(int n, int n2, DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this(n, n2, dataInputStream.readUnsignedShort(), constantPool);
    }

    public Signature(int n, int n2, int n3, ConstantPool constantPool) {
        super((byte)10, n, n2, constantPool);
        this.signature_index = n3;
    }

    public void accept(Visitor visitor) {
        System.err.println("Visiting non-standard Signature object");
    }

    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.signature_index);
    }

    public final int getSignatureIndex() {
        return this.signature_index;
    }

    public final void setSignatureIndex(int n) {
        this.signature_index = n;
    }

    public final String getSignature() {
        ConstantUtf8 constantUtf8 = (ConstantUtf8)this.constant_pool.getConstant(this.signature_index, (byte)1);
        return constantUtf8.getBytes();
    }

    private static boolean identStart(int n) {
        return n == 84 || n == 76;
    }

    private static boolean identPart(int n) {
        return n == 47 || n == 59;
    }

    private static final void matchIdent(MyByteArrayInputStream myByteArrayInputStream, StringBuffer stringBuffer) {
        int n = myByteArrayInputStream.read();
        if (n == -1) {
            throw new RuntimeException("Illegal signature: " + myByteArrayInputStream.getData() + " no ident, reaching EOF");
        }
        if (!Signature.identStart(n)) {
            StringBuffer stringBuffer2 = new StringBuffer();
            int n2 = 1;
            while (Character.isJavaIdentifierPart((char)n)) {
                stringBuffer2.append((char)n);
                ++n2;
                n = myByteArrayInputStream.read();
            }
            if (n == 58) {
                myByteArrayInputStream.skip("Ljava/lang/Object".length());
                stringBuffer.append((Object)stringBuffer2);
                n = myByteArrayInputStream.read();
                myByteArrayInputStream.unread();
            } else {
                int n3 = 0;
                while (n3 < n2) {
                    myByteArrayInputStream.unread();
                    ++n3;
                }
            }
            return;
        }
        StringBuffer stringBuffer3 = new StringBuffer();
        n = myByteArrayInputStream.read();
        do {
            stringBuffer3.append((char)n);
        } while ((n = myByteArrayInputStream.read()) != -1 && (Character.isJavaIdentifierPart((char)n) || n == 47));
        stringBuffer.append(stringBuffer3.toString().replace('/', '.'));
        if (n != -1) {
            myByteArrayInputStream.unread();
        }
    }

    private static final void matchGJIdent(MyByteArrayInputStream myByteArrayInputStream, StringBuffer stringBuffer) {
        Signature.matchIdent(myByteArrayInputStream, stringBuffer);
        int n = myByteArrayInputStream.read();
        if (n == 60 || n == 40) {
            stringBuffer.append((char)n);
            Signature.matchGJIdent(myByteArrayInputStream, stringBuffer);
            while ((n = myByteArrayInputStream.read()) != 62 && n != 41) {
                if (n == -1) {
                    throw new RuntimeException("Illegal signature: " + myByteArrayInputStream.getData() + " reaching EOF");
                }
                stringBuffer.append(", ");
                myByteArrayInputStream.unread();
                Signature.matchGJIdent(myByteArrayInputStream, stringBuffer);
            }
            stringBuffer.append((char)n);
        } else {
            myByteArrayInputStream.unread();
        }
        n = myByteArrayInputStream.read();
        if (Signature.identStart(n)) {
            myByteArrayInputStream.unread();
            Signature.matchGJIdent(myByteArrayInputStream, stringBuffer);
        } else {
            if (n == 41) {
                myByteArrayInputStream.unread();
                return;
            }
            if (n != 59) {
                throw new RuntimeException("Illegal signature: " + myByteArrayInputStream.getData() + " read " + (char)n);
            }
        }
    }

    public static String translate(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Signature.matchGJIdent(new MyByteArrayInputStream(string), stringBuffer);
        return stringBuffer.toString();
    }

    public static final boolean isFormalParameterList(String string) {
        return string.startsWith("<") && string.indexOf(58) > 0;
    }

    public static final boolean isActualParameterList(String string) {
        return string.startsWith("L") && string.endsWith(">;");
    }

    public final String toString() {
        String string = this.getSignature();
        return "Signature(" + string + ")";
    }

    public Attribute copy(ConstantPool constantPool) {
        return (Signature)this.clone();
    }

    private static final class MyByteArrayInputStream
    extends ByteArrayInputStream {
        MyByteArrayInputStream(String string) {
            super(string.getBytes());
        }

        final int mark() {
            return this.pos;
        }

        final String getData() {
            return new String(this.buf);
        }

        final void reset(int n) {
            this.pos = n;
        }

        final void unread() {
            if (this.pos > 0) {
                --this.pos;
            }
        }
    }
}

