/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.classfile;

import de.fub.bytecode.Constants;
import de.fub.bytecode.classfile.ConstantPool;
import de.fub.bytecode.classfile.LocalVariable;
import de.fub.bytecode.classfile.LocalVariableTable;
import de.fub.bytecode.util.ByteSequence;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.FilterReader;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Vector;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public abstract class Utility {
    private static int consumed_chars;
    private static boolean wide;
    private static final int FREE_CHARS = 48;
    private static int[] CHAR_MAP;
    private static int[] MAP_CHAR;
    private static final char ESCAPE_CHAR = '$';

    public static final String accessToString(int n) {
        return Utility.accessToString(n, false);
    }

    public static final String accessToString(int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = 0;
        while (n2 < 1024) {
            n2 = Utility.pow2(n3);
            if ((n & n2) != 0 && (!bl || n2 != 32 && n2 != 512)) {
                stringBuffer.append(Constants.ACCESS_NAMES[n3] + " ");
            }
            ++n3;
        }
        return stringBuffer.toString().trim();
    }

    public static final String classOrInterface(int n) {
        return (n & 0x200) != 0 ? "interface" : "class";
    }

    public static final String codeToString(byte[] byArray, ConstantPool constantPool, int n, int n2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 20);
        ByteSequence byteSequence = new ByteSequence(byArray);
        try {
            int n3 = 0;
            while (n3 < n) {
                Utility.codeToString(byteSequence, constantPool, bl);
                ++n3;
            }
            int n4 = 0;
            while (byteSequence.available() > 0) {
                if (n2 < 0 || n4 < n2) {
                    String string = Utility.fillup(byteSequence.getIndex() + ":", 6, true, ' ');
                    stringBuffer.append(string + Utility.codeToString(byteSequence, constantPool, bl) + '\n');
                }
                ++n4;
            }
        }
        catch (IOException iOException) {
            System.out.println(stringBuffer.toString());
            iOException.printStackTrace();
            throw new ClassFormatError("Byte code error: " + iOException);
        }
        return stringBuffer.toString();
    }

    public static final String codeToString(byte[] byArray, ConstantPool constantPool, int n, int n2) {
        return Utility.codeToString(byArray, constantPool, n, n2, true);
    }

    public static final String codeToString(ByteSequence byteSequence, ConstantPool constantPool, boolean bl) throws IOException {
        int n;
        int n2;
        int n3;
        short s = (short)byteSequence.readUnsignedByte();
        int n4 = 0;
        int n5 = 0;
        StringBuffer stringBuffer = new StringBuffer(Constants.OPCODE_NAMES[s]);
        if (s == 170 || s == 171) {
            n3 = byteSequence.getIndex() % 4;
            n5 = n3 == 0 ? 0 : 4 - n3;
            n2 = 0;
            while (n2 < n5) {
                byte by = byteSequence.readByte();
                n = by;
                if (by != 0) {
                    System.err.println("Warning: Padding byte != 0 in " + Constants.OPCODE_NAMES[s] + ":" + n);
                }
                ++n2;
            }
            n4 = byteSequence.readInt();
        }
        switch (s) {
            case 170: {
                int n6 = byteSequence.readInt();
                int n7 = byteSequence.readInt();
                int n8 = byteSequence.getIndex() - 12 - n5 - 1;
                stringBuffer.append("\tdefault = " + (n4 += n8) + ", low = " + n6 + ", high = " + n7 + "(");
                int[] nArray = new int[n7 - n6 + 1];
                n3 = 0;
                while (n3 < nArray.length) {
                    nArray[n3] = n8 + byteSequence.readInt();
                    stringBuffer.append(nArray[n3]);
                    if (n3 < nArray.length - 1) {
                        stringBuffer.append(", ");
                    }
                    ++n3;
                }
                stringBuffer.append(")");
                break;
            }
            case 171: {
                int n9 = byteSequence.readInt();
                int n10 = byteSequence.getIndex() - 8 - n5 - 1;
                int[] nArray = new int[n9];
                int[] nArray2 = new int[n9];
                stringBuffer.append("\tdefault = " + (n4 += n10) + ", npairs = " + n9 + " (");
                n2 = 0;
                while (n2 < n9) {
                    nArray[n2] = byteSequence.readInt();
                    nArray2[n2] = n10 + byteSequence.readInt();
                    stringBuffer.append("(" + nArray[n2] + ", " + nArray2[n2] + ")");
                    if (n2 < n9 - 1) {
                        stringBuffer.append(", ");
                    }
                    ++n2;
                }
                stringBuffer.append(")");
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: {
                stringBuffer.append("\t\t#" + (byteSequence.getIndex() - 1 + byteSequence.readShort()));
                break;
            }
            case 200: 
            case 201: {
                stringBuffer.append("\t\t#" + (byteSequence.getIndex() - 1 + byteSequence.readInt()));
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 169: {
                int n11;
                if (wide) {
                    n11 = byteSequence.readUnsignedShort();
                    wide = false;
                } else {
                    n11 = byteSequence.readUnsignedByte();
                }
                stringBuffer.append("\t\t%" + n11);
                break;
            }
            case 196: {
                wide = true;
                stringBuffer.append("\t(wide)");
                break;
            }
            case 188: {
                stringBuffer.append("\t\t<" + Constants.TYPE_NAMES[byteSequence.readByte()] + ">");
                break;
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: {
                int n12 = byteSequence.readUnsignedShort();
                stringBuffer.append("\t\t" + constantPool.constantToString(n12, (byte)9) + (bl ? " (" + n12 + ")" : ""));
                break;
            }
            case 187: 
            case 192: {
                stringBuffer.append("\t");
            }
            case 193: {
                int n13 = byteSequence.readUnsignedShort();
                stringBuffer.append("\t<" + constantPool.constantToString(n13, (byte)7) + ">" + (bl ? " (" + n13 + ")" : ""));
                break;
            }
            case 182: 
            case 183: 
            case 184: {
                int n14 = byteSequence.readUnsignedShort();
                stringBuffer.append("\t" + constantPool.constantToString(n14, (byte)10) + (bl ? " (" + n14 + ")" : ""));
                break;
            }
            case 185: {
                int n15 = byteSequence.readUnsignedShort();
                n2 = byteSequence.readUnsignedByte();
                stringBuffer.append("\t" + constantPool.constantToString(n15, (byte)11) + (bl ? " (" + n15 + ")\t" : "") + n2 + "\t" + byteSequence.readUnsignedByte());
                break;
            }
            case 19: 
            case 20: {
                int n16 = byteSequence.readUnsignedShort();
                stringBuffer.append("\t\t" + constantPool.constantToString(n16, constantPool.getConstant(n16).getTag()) + (bl ? " (" + n16 + ")" : ""));
                break;
            }
            case 18: {
                int n17 = byteSequence.readUnsignedByte();
                stringBuffer.append("\t\t" + constantPool.constantToString(n17, constantPool.getConstant(n17).getTag()) + (bl ? " (" + n17 + ")" : ""));
                break;
            }
            case 189: {
                int n18 = byteSequence.readUnsignedShort();
                stringBuffer.append("\t\t<" + Utility.compactClassName(constantPool.getConstantString(n18, (byte)7), false) + ">" + (bl ? " (" + n18 + ")" : ""));
                break;
            }
            case 197: {
                int n19 = byteSequence.readUnsignedShort();
                n = byteSequence.readUnsignedByte();
                stringBuffer.append("\t<" + Utility.compactClassName(constantPool.getConstantString(n19, (byte)7), false) + ">\t" + n + (bl ? " (" + n19 + ")" : ""));
                break;
            }
            case 132: {
                short s2;
                int n20;
                if (wide) {
                    n20 = byteSequence.readUnsignedShort();
                    s2 = byteSequence.readShort();
                    wide = false;
                } else {
                    n20 = byteSequence.readUnsignedByte();
                    s2 = byteSequence.readByte();
                }
                stringBuffer.append("\t\t%" + n20 + "\t" + s2);
                break;
            }
            default: {
                if (Constants.NO_OF_OPERANDS[s] <= 0) break;
                n = 0;
                while (n < Constants.TYPE_OF_OPERANDS[s].length) {
                    stringBuffer.append("\t\t");
                    switch (Constants.TYPE_OF_OPERANDS[s][n]) {
                        case 8: {
                            stringBuffer.append(byteSequence.readByte());
                            break;
                        }
                        case 9: {
                            stringBuffer.append(byteSequence.readShort());
                            break;
                        }
                        case 10: {
                            stringBuffer.append(byteSequence.readInt());
                            break;
                        }
                        default: {
                            System.err.println("Unreachable default case reached!");
                            System.exit(-1);
                        }
                    }
                    ++n;
                }
                break block0;
            }
        }
        return stringBuffer.toString();
    }

    public static final String codeToString(ByteSequence byteSequence, ConstantPool constantPool) throws IOException {
        return Utility.codeToString(byteSequence, constantPool, true);
    }

    public static final String compactClassName(String string) {
        return Utility.compactClassName(string, true);
    }

    public static final String compactClassName(String string, String string2, boolean bl) {
        int n = string2.length();
        string = string.replace('/', '.');
        if (bl && string.startsWith(string2) && string.substring(n).indexOf(46) == -1) {
            string = string.substring(n);
        }
        return string;
    }

    public static final String compactClassName(String string, boolean bl) {
        return Utility.compactClassName(string, "java.lang.", bl);
    }

    private static final boolean is_digit(char c) {
        return c >= '0' && c <= '9';
    }

    private static final boolean is_space(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n';
    }

    public static final int setBit(int n, int n2) {
        return n | Utility.pow2(n2);
    }

    public static final int clearBit(int n, int n2) {
        int n3 = Utility.pow2(n2);
        return (n & n3) == 0 ? n : n ^ n3;
    }

    public static final boolean isSet(int n, int n2) {
        return (n & Utility.pow2(n2)) != 0;
    }

    public static final String methodTypeToSignature(String string, String[] stringArray) throws ClassFormatError {
        String string2;
        StringBuffer stringBuffer = new StringBuffer("(");
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                string2 = Utility.typeToSignature(stringArray[n]);
                if (string2.endsWith("V")) {
                    throw new ClassFormatError("Invalid type: " + stringArray[n]);
                }
                stringBuffer.append(string2);
                ++n;
            }
        }
        string2 = Utility.typeToSignature(string);
        stringBuffer.append(")" + string2);
        return stringBuffer.toString();
    }

    public static final String[] methodSignatureArgumentTypes(String string) throws ClassFormatError {
        return Utility.methodSignatureArgumentTypes(string, true);
    }

    public static final String[] methodSignatureArgumentTypes(String string, boolean bl) throws ClassFormatError {
        Vector<String> vector = new Vector<String>();
        try {
            if (string.charAt(0) != '(') {
                throw new ClassFormatError("Invalid method signature: " + string);
            }
            int n = 1;
            while (string.charAt(n) != ')') {
                vector.addElement(Utility.signatureToString(string.substring(n), bl));
                n += consumed_chars;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatError("Invalid method signature: " + string);
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static final String methodSignatureReturnType(String string) throws ClassFormatError {
        return Utility.methodSignatureReturnType(string, true);
    }

    public static final String methodSignatureReturnType(String string, boolean bl) throws ClassFormatError {
        String string2;
        try {
            int n = string.lastIndexOf(41) + 1;
            string2 = Utility.signatureToString(string.substring(n), bl);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatError("Invalid method signature: " + string);
        }
        return string2;
    }

    public static final String methodSignatureToString(String string, String string2, String string3) {
        return Utility.methodSignatureToString(string, string2, string3, true);
    }

    public static final String methodSignatureToString(String string, String string2, String string3, boolean bl) {
        return Utility.methodSignatureToString(string, string2, string3, bl, null);
    }

    public static final String methodSignatureToString(String string, String string2, String string3, boolean bl, LocalVariableTable localVariableTable) throws ClassFormatError {
        String string4;
        StringBuffer stringBuffer = new StringBuffer("(");
        int n = string3.indexOf("static") >= 0 ? 0 : 1;
        try {
            if (string.charAt(0) != '(') {
                throw new ClassFormatError("Invalid method signature: " + string);
            }
            int n2 = 1;
            while (string.charAt(n2) != ')') {
                stringBuffer.append(Utility.signatureToString(string.substring(n2), bl));
                if (localVariableTable != null) {
                    LocalVariable localVariable = localVariableTable.getLocalVariable(n);
                    if (localVariable != null) {
                        stringBuffer.append(" " + localVariable.getName());
                    }
                } else {
                    stringBuffer.append(" arg" + n);
                }
                ++n;
                stringBuffer.append(", ");
                n2 += consumed_chars;
            }
            string4 = Utility.signatureToString(string.substring(++n2), bl);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatError("Invalid method signature: " + string);
        }
        if (stringBuffer.length() > 1) {
            stringBuffer.setLength(stringBuffer.length() - 2);
        }
        stringBuffer.append(")");
        return string3 + (string3.length() > 0 ? " " : "") + string4 + " " + string2 + stringBuffer.toString();
    }

    private static final int pow2(int n) {
        return 1 << n;
    }

    public static final String replace(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n = string.indexOf(string2);
            if (n != -1) {
                int n2 = 0;
                while ((n = string.indexOf(string2, n2)) != -1) {
                    stringBuffer.append(string.substring(n2, n));
                    stringBuffer.append(string3);
                    n2 = n + string2.length();
                }
                stringBuffer.append(string.substring(n2));
                string = stringBuffer.toString();
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            System.err.println(stringIndexOutOfBoundsException);
        }
        return string;
    }

    public static final String signatureToString(String string) {
        return Utility.signatureToString(string, true);
    }

    public static final String signatureToString(String string, boolean bl) {
        consumed_chars = 1;
        try {
            switch (string.charAt(0)) {
                case 'B': {
                    return "byte";
                }
                case 'C': {
                    return "char";
                }
                case 'D': {
                    return "double";
                }
                case 'F': {
                    return "float";
                }
                case 'I': {
                    return "int";
                }
                case 'J': {
                    return "long";
                }
                case 'L': {
                    int n = string.indexOf(59);
                    if (n < 0) {
                        throw new ClassFormatError("Invalid signature: " + string);
                    }
                    consumed_chars = n + 1;
                    return Utility.compactClassName(string.substring(1, n), bl);
                }
                case 'S': {
                    return "short";
                }
                case 'Z': {
                    return "boolean";
                }
                case '[': {
                    StringBuffer stringBuffer = new StringBuffer();
                    int n = 0;
                    while (string.charAt(n) == '[') {
                        stringBuffer.append("[]");
                        ++n;
                    }
                    int n2 = n;
                    String string2 = Utility.signatureToString(string.substring(n), bl);
                    consumed_chars += n2;
                    return string2 + stringBuffer.toString();
                }
                case 'V': {
                    return "void";
                }
            }
            throw new ClassFormatError("Invalid signature: `" + string + "'");
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatError("Invalid signature: " + stringIndexOutOfBoundsException + ":" + string);
        }
    }

    public static final String typeToSignature(String string) {
        return Utility.getSignature(string);
    }

    public static String getSignature(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        boolean bl = false;
        boolean bl2 = false;
        int n = -1;
        int n2 = 0;
        block4: while (n2 < cArray.length) {
            switch (cArray[n2]) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (!bl) break;
                    bl2 = true;
                    break;
                }
                case '[': {
                    if (!bl) {
                        throw new RuntimeException("Illegal type: " + string);
                    }
                    n = n2;
                    break block4;
                }
                default: {
                    bl = true;
                    if (bl2) break;
                    stringBuffer.append(cArray[n2]);
                }
            }
            ++n2;
        }
        int n3 = 0;
        if (n > 0) {
            n3 = Utility.countBrackets(string.substring(n));
        }
        string = stringBuffer.toString();
        stringBuffer.setLength(0);
        int n4 = 0;
        while (n4 < n3) {
            stringBuffer.append('[');
            ++n4;
        }
        boolean bl3 = false;
        int n5 = 4;
        while (n5 <= 12 && !bl3) {
            if (Constants.TYPE_NAMES[n5].equals(string)) {
                bl3 = true;
                stringBuffer.append(Constants.SHORT_TYPE_NAMES[n5]);
            }
            ++n5;
        }
        if (!bl3) {
            stringBuffer.append('L' + string.replace('.', '/') + ';');
        }
        return stringBuffer.toString();
    }

    private static int countBrackets(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        while (n2 < cArray.length) {
            switch (cArray[n2]) {
                case '[': {
                    if (bl) {
                        throw new RuntimeException("Illegally nested brackets:" + string);
                    }
                    bl = true;
                    break;
                }
                case ']': {
                    if (!bl) {
                        throw new RuntimeException("Illegally nested brackets:" + string);
                    }
                    bl = false;
                    ++n;
                    break;
                }
            }
            ++n2;
        }
        if (bl) {
            throw new RuntimeException("Illegally nested brackets:" + string);
        }
        return n;
    }

    public static final byte typeOfMethodSignature(String string) throws ClassFormatError {
        try {
            if (string.charAt(0) != '(') {
                throw new ClassFormatError("Invalid method signature: " + string);
            }
            int n = string.lastIndexOf(41) + 1;
            return Utility.typeOfSignature(string.substring(n));
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatError("Invalid method signature: " + string);
        }
    }

    public static final byte typeOfSignature(String string) throws ClassFormatError {
        try {
            switch (string.charAt(0)) {
                case 'B': {
                    return 8;
                }
                case 'C': {
                    return 5;
                }
                case 'D': {
                    return 7;
                }
                case 'F': {
                    return 6;
                }
                case 'I': {
                    return 10;
                }
                case 'J': {
                    return 11;
                }
                case 'L': {
                    return 14;
                }
                case '[': {
                    return 13;
                }
                case 'V': {
                    return 12;
                }
                case 'Z': {
                    return 4;
                }
                case 'S': {
                    return 9;
                }
            }
            throw new ClassFormatError("Invalid method signature: " + string);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatError("Invalid method signature: " + string);
        }
    }

    public static short searchOpcode(String string) {
        string = string.toLowerCase();
        short s = 0;
        while (s < Constants.OPCODE_NAMES.length) {
            if (Constants.OPCODE_NAMES[s].equals(string)) {
                return s;
            }
            s = (short)(s + 1);
        }
        return -1;
    }

    private static final short byteToShort(byte by) {
        return by < 0 ? (short)(256 + by) : (short)by;
    }

    public static final String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            short s = Utility.byteToShort(byArray[n]);
            String string = Integer.toString(s, 16);
            if (s < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
            if (n < byArray.length - 1) {
                stringBuffer.append(' ');
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static final String format(int n, int n2, boolean bl, char c) {
        return Utility.fillup(Integer.toString(n), n2, bl, c);
    }

    public static final String fillup(String string, int n, boolean bl, char c) {
        int n2 = n - string.length();
        char[] cArray = new char[n2 < 0 ? 0 : n2];
        int n3 = 0;
        while (n3 < cArray.length) {
            cArray[n3] = c;
            ++n3;
        }
        if (bl) {
            return string + new String(cArray);
        }
        return new String(cArray) + string;
    }

    static final boolean equals(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        if (n != byArray2.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (byArray[n2] != byArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static final void printArray(PrintStream printStream, Object[] objectArray) {
        printStream.println(Utility.printArray(objectArray, true));
    }

    public static final void printArray(PrintWriter printWriter, Object[] objectArray) {
        printWriter.println(Utility.printArray(objectArray, true));
    }

    public static final String printArray(Object[] objectArray) {
        return Utility.printArray(objectArray, true);
    }

    public static final String printArray(Object[] objectArray, boolean bl) {
        if (objectArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append('{');
        }
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] != null) {
                stringBuffer.append(objectArray[n].toString());
            } else {
                stringBuffer.append("null");
            }
            if (n < objectArray.length - 1) {
                stringBuffer.append(", ");
            }
            ++n;
        }
        if (bl) {
            stringBuffer.append('}');
        }
        return stringBuffer.toString();
    }

    public static boolean isJavaIdentifierPart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_';
    }

    public static String encode(byte[] byArray, boolean bl) throws IOException {
        Closeable closeable;
        Closeable closeable2;
        if (bl) {
            closeable2 = new ByteArrayOutputStream();
            closeable = new GZIPOutputStream((OutputStream)closeable2);
            ((GZIPOutputStream)closeable).write(byArray, 0, byArray.length);
            ((DeflaterOutputStream)closeable).close();
            ((ByteArrayOutputStream)closeable2).close();
            byArray = ((ByteArrayOutputStream)closeable2).toByteArray();
        }
        closeable2 = new CharArrayWriter();
        closeable = new JavaWriter((Writer)closeable2);
        int n = 0;
        while (n < byArray.length) {
            int n2 = byArray[n] & 0xFF;
            ((JavaWriter)closeable).write(n2);
            ++n;
        }
        return ((CharArrayWriter)closeable2).toString();
    }

    public static byte[] decode(String string, boolean bl) throws IOException {
        int n;
        char[] cArray = string.toCharArray();
        CharArrayReader charArrayReader = new CharArrayReader(cArray);
        JavaReader javaReader = new JavaReader(charArrayReader);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = javaReader.read()) >= 0) {
            byteArrayOutputStream.write(n);
        }
        byteArrayOutputStream.close();
        charArrayReader.close();
        javaReader.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if (bl) {
            int n2;
            GZIPInputStream gZIPInputStream = new GZIPInputStream(new ByteArrayInputStream(byArray));
            byte[] byArray2 = new byte[byArray.length * 3];
            int n3 = 0;
            while ((n2 = gZIPInputStream.read()) >= 0) {
                byArray2[n3++] = (byte)n2;
            }
            byArray = new byte[n3];
            System.arraycopy(byArray2, 0, byArray, 0, n3);
        }
        return byArray;
    }

    static {
        wide = false;
        CHAR_MAP = new int[48];
        MAP_CHAR = new int[256];
        int n = 0;
        boolean bl = false;
        int n2 = 65;
        while (n2 <= 90) {
            Utility.CHAR_MAP[n] = n2;
            Utility.MAP_CHAR[n2] = n++;
            ++n2;
        }
        int n3 = 103;
        while (n3 <= 122) {
            Utility.CHAR_MAP[n] = n3;
            Utility.MAP_CHAR[n3] = n++;
            ++n3;
        }
        Utility.CHAR_MAP[n] = 36;
        Utility.MAP_CHAR[36] = n++;
        Utility.CHAR_MAP[n] = 95;
        Utility.MAP_CHAR[95] = n;
    }

    private static class JavaWriter
    extends FilterWriter {
        public JavaWriter(Writer writer) {
            super(writer);
        }

        public void write(int n) throws IOException {
            if (Utility.isJavaIdentifierPart((char)n) && n != 36) {
                this.out.write(n);
            } else {
                this.out.write(36);
                if (n >= 0 && n < 48) {
                    this.out.write(CHAR_MAP[n]);
                } else {
                    char[] cArray = Integer.toHexString(n).toCharArray();
                    if (cArray.length == 1) {
                        this.out.write(48);
                        this.out.write(cArray[0]);
                    } else {
                        this.out.write(cArray[0]);
                        this.out.write(cArray[1]);
                    }
                }
            }
        }

        public void write(char[] cArray, int n, int n2) throws IOException {
            int n3 = 0;
            while (n3 < n2) {
                this.write(cArray[n + n3]);
                ++n3;
            }
        }

        public void write(String string, int n, int n2) throws IOException {
            this.write(string.toCharArray(), n, n2);
        }
    }

    private static class JavaReader
    extends FilterReader {
        public JavaReader(Reader reader) {
            super(reader);
        }

        public int read() throws IOException {
            int n = this.in.read();
            if (n != 36) {
                return n;
            }
            int n2 = this.in.read();
            if (n2 < 0) {
                return -1;
            }
            if (n2 >= 48 && n2 <= 57 || n2 >= 97 && n2 <= 102) {
                int n3 = this.in.read();
                if (n3 < 0) {
                    return -1;
                }
                char[] cArray = new char[]{(char)n2, (char)n3};
                int n4 = Integer.parseInt(new String(cArray), 16);
                return n4;
            }
            return MAP_CHAR[n2];
        }

        public int read(char[] cArray, int n, int n2) throws IOException {
            int n3 = 0;
            while (n3 < n2) {
                cArray[n + n3] = (char)this.read();
                ++n3;
            }
            return n2;
        }
    }
}

