/*
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2002 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Ant", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */
package org.apache.tools.ant.taskdefs.optional.dotnet;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

/**
 * Calls NAnt with a build script. NAnt is an Ant
 * port to .NET.
 * @author      Brian Felder bfelder@providence.org
 * @version     0.1
 * @ant.task    name="nant" category="dotnet"
 * @since       Ant 1.6
 */

public class NAntCall extends Task  {

    /**
     * Space-separated list of tasks to run.
     */
    private String targets = null;

    /**
     * Name of the NAnt buildFile to use.
     */
    private File buildFile = null;

    /**
     *  flag to control action on execution trouble
     */
    private boolean failOnError = true;

    /**
     * Name of the NAnt buildFile to use.
     * @param The name of the NAnt buildFile.
     */
    public void setBuildFile(File buildFile) {
        this.buildFile = buildFile;
    }
    
    protected String getBuildFileParameter() {
        if (buildFile != null) {
            return ("-buildfile:" + buildFile.toString());
        } else {
            return null;
        }
    }

    /**
     * Set the targets to run.
     * @param targets The targets to run.
     */

    public void setTargets(String targets) {
        this.targets = targets;
    }

    /**
     * If true, fail on compilation errors.
     *
     *@param  b  The new FailOnError value
     */
    public void setFailOnError(boolean b) {
        failOnError = b;
    }

    /**
     * validation code
     * @throws  BuildException  if validation failed
     */
    protected void validate()
            throws BuildException {
        if (buildFile == null) {
            throw new BuildException("build file must be specified");
        }
        if (buildFile.isDirectory()) {
            throw new BuildException(
                "build file is a directory");
        }
        if (buildFile != null) {
            if (!buildFile.exists()) {
                throw new BuildException(
                    "build file does not exist");
            }
            if (buildFile.isDirectory()) {
                throw new BuildException(
                    "build file is a directory");
            }
        }

    }

    /**
     *  Call the command line with the appropriate args.
     *
     *@throws  BuildException  if validation or execution failed
     */
    public void execute()
             throws BuildException {
        validate();
        NetCommand command = new NetCommand(this, "NAntCall", "NAnt");
        command.setFailOnError(failOnError);
        //DEBUG helper
        command.setTraceCommandLine(true);
        //fill in args
        command.addArgument(getBuildFileParameter());
        command.addArgument(targets);

        command.runCommand();
    }
}

