#!/usr/bin/ruby -Ku
# -*- coding: utf-8 -*-

###############################
# Author: vagus <vagus.xyz@gmail.com>
# LastUpdate: 2010-6-15
# 無保証、無制限(改変、再配布 etc)
###############################
#
# ken_all.csv から各種 IME 用郵便番号辞書の基となる zipcode.base を作成する
# (事前に ken_all.lzh を落として伸張しておくこと)
# $ wget http://www.post.japanpost.jp/zipcode/dl/kogaki/lzh/ken_all.lzh
# $ lha ptq ken_all.lzh > ken_all.csv
#
###############################
# 既知の問題:
# ・文字列でソートするから数字部分の並びがおかしい
#
# (JIGYOSYO.CSV は一部、第3水準の漢字を使っていて、EUC-JP に変換できないので
# 入れない。)
#
###############################

require 'kconv'
require 'iconv'

IN_FILE = "./ken_all.csv"
OUT_FILE = "./zipcode_base.txt"

#********************************************
# 数字の全角/半角を相互に置換する関数
#********************************************
def num_tr(str, to_full_or_half)
  fw = %w[ ０ １ ２ ３ ４ ５ ６ ７ ８ ９ ]
  hw = %w[ 0 1 2 3 4 5 6 7 8 9 ]

  case to_full_or_half
  when "half"
    tr_tbl = Hash[*fw.zip(hw).flatten]
    str.gsub(/[#{fw.join}]/u){ tr_tbl[$&] }
  when "full"
    tr_tbl = Hash[*hw.zip(fw).flatten]
    str.gsub(/[#{hw.join}]/u){ tr_tbl[$&] }
  else
    $stderr.puts "#{to_full_or_half}"': Invalid value. Only "full" or "half" are available.'
    exit(1)
  end
end

#********************************************
# 「種市第４６地割～第４９地割」みたいなのを
# ["種市第４６地割", "種市第４７地割", "種市第４８地割", "種市第４９地割"]
# に展開する関数
#********************************************
def expand_range(str)
  str = num_tr(str, "half")

  str.match(/^([^0-9]+)([0-9]+)[^0-9]+([0-9]+)([^0-9]+)/u)

  ($2.to_i..$3.to_i).map{|x|
    "#{$1}#{num_tr(x.to_s, "full")}#{$4}"
  }
end

#--------------------------------------------
# ken_all.csv を読んで必要な field を抜き出す
#--------------------------------------------
ken_all_src = []
open(IN_FILE, "r"){|f|
#  f_utf8 = NKF.nkf("-Sw -x", f.read).gsub('"','')
  f_utf8 = Iconv.conv("UTF-8", "SHIFT_JIS", f.read).gsub('"','')
  ken_all_src = f_utf8.each_line.map{|line|
                   e =line.chomp.split(",")
                  [e[2], e[6], e[7], e[8]]
                }
}

#-----------------------------------------
# 複数行にまたがっている奴を一行にまとめる
#-----------------------------------------
ken_all = []
zipcode = ken_all_src[0][0]
adr     = ken_all_src[0][3]
hold    = ken_all_src[0..2]

ken_all_src.each{|item|
  # （ ）内が複数行にまたがっているものがあるので、それを1行にまとめ、
  # （ ）の部分を削除する(除く: "（？階）" )
  if item[3] =~ /（[^）]+$/u
    zipcode = item[0]
    adr     = item[3]
    hold    = item[0..2]
  elsif item[0] == zipcode && item[3] !~ /[（）]/u
    adr += item[3]
  elsif item[0] == zipcode && item[3] =~ /）/u
    # 丸括弧内の記述は自由すぎるので削除
    adr_tmp = "#{adr}#{item[3]}".sub(/（.+）$/u,"")
    ken_all << [hold[0], hold[1], hold[2], adr_tmp]
  else
    # 複数行にまたがっていない場合。

    # 丸括弧内の記述は自由すぎるので、"（？階）"以外削除
    # その前に複数丸括弧は一つにしておく
    # 「名駅ミッドランドスクエア（高層棟）（？階）」のみだから
    item[3] = item[3].sub("）（","")
    if item[3] =~ /（/u
        item[3] = item[3].sub(/（.+）$/u,"") if item[3] !~ /階）$/u
    elsif item[3] =~ /[いる]場合|一円$/u
      # 住所として無意味なものを削除
      # (「以下に掲載がない場合」「の次に番地がくる場合」
      # 「新庄村一円」)
      item[3] = ""
    end

    #-----------------------------------
    # item[3](町域)が複数に分かれる場合の対応
    #-----------------------------------
    if item[3] =~ /、/u
      # 「穴明２２地割、穴明２３地割」のような場合
      item_tmp = item[3].split("、")
    elsif item[3] =~ /[～〜]/u
      # 「越中畑６４地割～越中畑６６地割」のような場合は展開する
      item_tmp = expand_range(item[3])
    else
      item_tmp = [item[3]]
    end

    # ken_all にまとめる
    item_tmp.each{|y|
      ken_all << [item[0], item[1], item[2], y]
    }
  end
}
# 「江田島町国有無番地」はどうするか


#-----------------------------
# 英数記号を半角にした候補を追加
#-----------------------------
hankaku = []
ken_all.each{|item|
  hw_item = NKF.nkf("-Ww -Z", num_tr(item[3], "half"))

  if hw_item =~ /[[:alnum:]()]/u
    hankaku << [item[0], item[1], item[2], hw_item]
  end
}

ken_all += hankaku

#-----------------------------
# sort, uniq して成形して出力
#-----------------------------
open(OUT_FILE, "w"){|f|
  ken_all.uniq.sort_by{|x|
    x
  }.each{|item|
#    f.puts NKF.nkf("-We", item.join(" "))
    f.puts Iconv.conv("EUC-JP", "UTF-8", item.join(" "))
  }
}









