#@@@SCRIPTSTART@@@
python
class DumpAsteriskCommand(gdb.Command):

    def __init__(self):
        super(DumpAsteriskCommand, self).__init__ ("dump-asterisk",
            gdb.COMMAND_OBSCURE, gdb.COMPLETE_COMMAND)

    def invoke(self, arg, from_tty):
        try:
            gdb.execute("interrupt", from_tty)
        except:
            pass
        print("!@!@!@! thread1.txt !@!@!@!\n")
        try:
            gdb.execute("p $_siginfo", from_tty)
            gdb.execute("info signal $_siginfo.si_signo")
        except:
            pass
        try:
            gdb.execute("thread apply 1 bt full", from_tty)
        except:
            pass
        print("!@!@!@! brief.txt !@!@!@!\n")
        try:
            gdb.execute("p $_siginfo", from_tty)
            gdb.execute("info signal $_siginfo.si_signo")
        except:
            pass
        try:
            gdb.execute("thread apply all bt", from_tty)
        except:
            pass
        print("!@!@!@! full.txt !@!@!@!\n")
        try:
            gdb.execute("p $_siginfo", from_tty)
            gdb.execute("info signal $_siginfo.si_signo")
        except:
            pass
        try:
            gdb.execute("thread apply all bt full", from_tty)
        except:
            pass
        print("!@!@!@! locks.txt !@!@!@!\n")
        try:
            gdb.execute("p $_siginfo", from_tty)
            gdb.execute("info signal $_siginfo.si_signo")
        except:
            pass
        try:
            gdb.execute("show_locks", from_tty)
        except:
            pass
        try:
            gdb.execute("continue", from_tty)
        except:
            pass

DumpAsteriskCommand ()
end

define show_locks
   set $n = lock_infos.first

   if $argc == 0
      printf "                                                                                                                    where_held count-|\n"
      printf "                                                                                                                         suspended-| |\n"
      printf "                                                                                                        type- |     times locked-| | |\n"
      printf "thread         status   file                   line function                             lock name            | lock addr        | | |\n"
   else
      printf "thread,status,file,line,function,lock_name,lock_type,lock_addr,times_locked,suspended,where_held_count,where_held_file,where_held_line,where_held_function,there_held_thread\n"
   end

   while $n
      if $n->num_locks > 0
      set $i = 0
      while $i < $n->num_locks
         if $n->locks[$i]->suspended == 0
            if ((ast_mutex_t *)$n->locks[$i]->lock_addr)->tracking
               if $n->locks[$i]->type > 0
                  set $track = ((ast_rwlock_t *)$n->locks[$i]->lock_addr)->track
               else
                  set $track = ((ast_mutex_t *)$n->locks[$i]->lock_addr)->track
               end
            end
            set $reentrancy = $track->reentrancy
            set $pending = $n->locks[$i]->pending
            if $argc > 0
               printf "%p,%d,%s,%d,%s,%s,%d,%p,%d,%d,%d",\
                  $n->thread_id, $n->locks[$i]->pending, $n->locks[$i]->file, $n->locks[$i]->line_num, $n->locks[$i]->func,\
                  $n->locks[$i]->lock_name, $n->locks[$i]->type, $n->locks[$i]->lock_addr, $n->locks[$i]->times_locked,\
                  $n->locks[$i]->suspended, $track->reentrancy
               if $reentrancy
                  if $pending
                     printf ",%s,%d,%s,%p", $track->file[0], $track->lineno[0], $track->func[0], $track->thread[0]
                  end
               end
            else
               if $n->locks[$i]->pending < 0
                  printf "%p failed   %-20s %6d %-36s %-20s %d %14p %3d %d %d",\
                     $n->thread_id,\
                     $n->locks[$i]->file, $n->locks[$i]->line_num, $n->locks[$i]->func,\
                     $n->locks[$i]->lock_name, $n->locks[$i]->type, $n->locks[$i]->lock_addr, $n->locks[$i]->times_locked,\
                     $n->locks[$i]->suspended, $track->reentrancy
               end
               if $n->locks[$i]->pending == 0
                  printf "%p holding  %-20s %6d %-36s %-20s %d %14p %3d %d %d",\
                     $n->thread_id,\
                     $n->locks[$i]->file, $n->locks[$i]->line_num, $n->locks[$i]->func,\
                     $n->locks[$i]->lock_name, $n->locks[$i]->type, $n->locks[$i]->lock_addr, $n->locks[$i]->times_locked,\
                     $n->locks[$i]->suspended, $track->reentrancy
               end
               if $n->locks[$i]->pending > 0
                  printf "%p waiting  %-20s %6d %-36s %-20s %d %14p %3d %d %d",\
                     $n->thread_id,\
                     $n->locks[$i]->file, $n->locks[$i]->line_num, $n->locks[$i]->func,\
                     $n->locks[$i]->lock_name, $n->locks[$i]->type, $n->locks[$i]->lock_addr, $n->locks[$i]->times_locked,\
                     $n->locks[$i]->suspended, $track->reentrancy
               end
               if $reentrancy
                  if $pending
                     printf "\n               held at: %-20s %6d %-36s by 0x%08lx", $track->file[0], $track->lineno[0], $track->func[0], $track->thread_id[0]
                  end
               end
            end
            printf "\n"
         end
         set $i = $i + 1
      end
    end
    set $n = $n->entry->next
  end
end

dump-asterisk
