/*
 * libss7: An implementation of Signalling System 7
 *
 * Written by Paul Bagyenda <bagyenda@dsmagic.com>
 *
 * SIGTRAN M3UA over SCTP implementation
 *
 * Copyright (C) 2009-, Digital Solutions
 * All Rights Reserved.
 */

/*
 * See http://www.asterisk.org for more information about
 * the Asterisk project. Please do not directly contact
 * any of the maintainers of this project for assistance;
 * the project provides a web site, mailing lists and IRC
 * channels for your use.
 *
 * This program is free software, distributed under the terms of
 * the GNU General Public License Version 2 as published by the
 * Free Software Foundation. See the LICENSE file included with
 * this program for more details.
 *
 * In addition, when this program is distributed with Asterisk in
 * any form that would qualify as a 'combined work' or as a
 * 'derivative work' (but not mere aggregation), you can redistribute
 * and/or modify the combination under the terms of the license
 * provided with that copy of Asterisk, instead of the license
 * terms granted here.
 */
#ifndef _M3UA_H
#define _M3UA_H

/* Message classes */
#define M3UA_MGMT_CLASS     0x00
#define M3UA_TRANSFER_CLASS 0x01
#define M3UA_SSNM_CLASS     0x02 
#define M3UA_ASPSM_CLASS    0x03
#define M3UA_ASPTM_CLASS    0x04
#define M3UA_RKM_CLASS      0x09

#define M3UA_MSG(cls,code) (((cls)<<8)|(code))
#define M3UA_MSG_CODE(msg) ((msg) & 0xFF)
#define M3UA_MSG_CLASS(msg) (((msg)>>8) & 0xFF)
/* Messages */
#define M3UA_ERR_MSG M3UA_MSG(M3UA_MGMT_CLASS,0x00)
#define M3UA_NTY_MSG M3UA_MSG(M3UA_MGMT_CLASS,0x01)


#define M3UA_DATA_MSG M3UA_MSG(M3UA_TRANSFER_CLASS,0x01)

#define M3UA_DUNA_MSG M3UA_MSG(M3UA_SSNM_CLASS,0x01)
#define M3UA_DAVA_MSG M3UA_MSG(M3UA_SSNM_CLASS,0x02)
#define M3UA_DAUD_MSG M3UA_MSG(M3UA_SSNM_CLASS,0x03)
#define M3UA_SCON_MSG M3UA_MSG(M3UA_SSNM_CLASS,0x04)
#define M3UA_DUPU_MSG M3UA_MSG(M3UA_SSNM_CLASS,0x05)
#define M3UA_DRST_MSG M3UA_MSG(M3UA_SSNM_CLASS,0x06)

#define M3UA_ASPUP_MSG M3UA_MSG(M3UA_ASPSM_CLASS,0x01)
#define M3UA_ASPDN_MSG M3UA_MSG(M3UA_ASPSM_CLASS,0x02)
#define M3UA_BEAT_MSG M3UA_MSG(M3UA_ASPSM_CLASS,0x03)
#define M3UA_ASPUP_ACK_MSG M3UA_MSG(M3UA_ASPSM_CLASS,0x04)
#define M3UA_ASPDN_ACK_MSG M3UA_MSG(M3UA_ASPSM_CLASS,0x05)
#define M3UA_BEAT_ACK_MSG M3UA_MSG(M3UA_ASPSM_CLASS,0x06)

#define M3UA_ASPAC_MSG M3UA_MSG(M3UA_ASPTM_CLASS,0x01)
#define M3UA_ASPIA_MSG M3UA_MSG(M3UA_ASPTM_CLASS,0x02)
#define M3UA_ASPAC_ACK_MSG M3UA_MSG(M3UA_ASPTM_CLASS,0x03)
#define M3UA_ASPIA_ACK_MSG M3UA_MSG(M3UA_ASPTM_CLASS,0x04)

#define M3UA_RKM_REG_REQ_MSG M3UA_MSG(M3UA_RKM_CLASS, 1)
#define M3UA_RKM_REG_RSP_MSG M3UA_MSG(M3UA_RKM_CLASS, 2)
#define M3UA_RKM_DEREG_REQ_MSG M3UA_MSG(M3UA_RKM_CLASS, 3)
#define M3UA_RKM_DEREG_RSP_MSG M3UA_MSG(M3UA_RKM_CLASS, 4)

 /* Header length for DATA packet: We assume no routing context and no NA params (RFC 3332, pg 32 */
#define M3UA_COMMON_HLEN 8 
#define M3UA_DATA_HLEN   4
 

#define M3UA_MAX_LEN 10

struct m3ua_route {
	unsigned int  pc; /* The referenced destination point code */
	unsigned int mask;   /* Affected bits in dpc: inverse mask as ~((1<<num_bits) - 1) because of XOR usage! */
	u_int8_t avail;   /* Set to 1 if available, 0 otherwise. */
	struct m3ua_route *next; 
};

struct m3ua_congestion {
	unsigned int pc;     /* destination */
	unsigned int mask;   /* affected bits (as above) */
	u_int8_t con;        /* congestion value */
	struct m3ua_congestion *next;
};

struct m3ua_routing_key_req { /* Any value that should be unused should be set to -1 */
	int traffic_mode;
	int net_app;                /* Network appearance */
	u_int32_t  rki;             /* will be filled in with local reference */
	struct {
		int n;
		u_int8_t si[M3UA_MAX_LEN];
	} si_list;
	struct {
		int n;
		u_int32_t pc[M3UA_MAX_LEN];
	} opc_list;
	struct {
		int n;
		struct {  /* order matters */
			u_int32_t opc;
			u_int16_t lower; 
			u_int16_t upper;
		} range[M3UA_MAX_LEN];
	} cic_list;
};

struct m3ua_routing_key {
	int active;                 /* Set to true when active */
	int sent;                   /* Set to true when key reg request sent */
	u_int32_t rc;               /* routing context */
	struct m3ua_routing_key_req rk;
       	struct m3ua_routing_key *next;
};

#define M3UA_MAX_NAME 128
struct m3ua {
	char name[M3UA_MAX_NAME];
	struct ss7 *master;
	enum { 
		M3UA_ASP_UP_SENT,
		M3UA_ASP_UP,
		M3UA_ASP_AC_SENT,
		M3UA_ASP_ACTIVE,
		M3UA_ASP_IA_SENT,
		M3UA_ASP_INACTIVE,
		M3UA_ASP_DOWN_SENT,
		M3UA_ASP_DOWN,
	} state;     /* Current state of link: Order above matters */	
	int fd;                  /* Must be sctp, and have at least one association active.*/	
	
	int t1, t2, t3;                  /* asp up, asp active, down timers */
	int down_ctr;                    /* Count how many times DOWN has been sent. */
	unsigned int adjpc;
	unsigned int slc;
	int net_app;                     /* Network appearance value */        
	struct m3ua_route *routes;       /* List of available/unavailable destinations */
	struct m3ua_congestion *con;     /* Congestion status by route */
	
	struct m3ua_routing_key *keys;   /* Routing keys */
};

struct m3ua *m3ua_new(char *name, unsigned int adjpc);
void m3ua_free(struct m3ua *m);

int m3ua_set_routinglabel(unsigned char *sif, struct routing_label *rl);
/* Bring each link into ACTIVE state */
void m3ua_start(struct ss7 *ss7);
int m3ua_set_sockopts(int fd);
int m3ua_rl_to_link(struct ss7 *, struct routing_label rl, int userpart, int has_sls, struct ss7_route *rt);

int m3ua_transmit_ex(struct ss7 *ss7, struct ss7_route rt, unsigned int userpart, int priority, int corrid, struct ss7_msg *m);
#define m3ua_transmit(ss7,rt,userpart,prio,m) m3ua_transmit_ex((ss7),(rt),(userpart),(prio),-1,(m))

int m3ua_receive(struct m3ua *);

/* Returns the local identifier */
int m3ua_rkm_reg(struct ss7 *ss7, struct routing_label rl, struct m3ua_routing_key_req rk[], int num_keys);
int m3ua_rkm_dereg(struct ss7 *ss7, struct routing_label rl, u_int32_t rki[], int num_keys);

void m3ua_down_link(struct ss7 *ss7, int fd); /* Kill a link (gracefully) */
int m3ua_daud(struct ss7 *ss7, struct routing_label rl, int na, int rc, int dpc, char *info);
#endif
