/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.tools.xdoclet;

import java.io.File;
import xdoclet.TemplateSubTask;
import xdoclet.XDocletException;

public class ManifestSubTask
extends TemplateSubTask {
    public static final String SUBTASK_NAME = "manifest";
    protected static String mClassPattern;
    private String mTemplatePath = null;
    private String mManifestFile = null;
    private static String GENERATED_FILE_NAME;
    protected static String DEFAULT_TEMPLATE_FILE;

    public ManifestSubTask() {
        this.setTemplateFile(new File(DEFAULT_TEMPLATE_FILE));
        this.setDestinationFile(GENERATED_FILE_NAME);
        this.setHavingClassTag("phoenix:service");
        TemplateSubTask.ExtentTypes extentTypes = new TemplateSubTask.ExtentTypes();
        extentTypes.setValue("hierarchy");
        this.setExtent(extentTypes);
        this.setOfType("org.apache.avalon.phoenix.Block");
    }

    public void setTemplatePath(String string) {
        this.mTemplatePath = string;
        this.setTemplateFile(new File(string));
    }

    public void setManifestFile(String string) {
        this.mManifestFile = string;
        this.setDestinationFile(this.mManifestFile);
    }

    public static String getClassPattern() {
        return mClassPattern;
    }

    public String getSubTaskName() {
        return SUBTASK_NAME;
    }

    public void setPattern(String string) {
        mClassPattern = string;
    }

    public void validateOptions() throws XDocletException {
        super.validateOptions();
        if (this.mManifestFile == null) {
            throw new XDocletException("'manifestFile' attribute is missing .");
        }
        if (this.getDestinationFile() == null || this.getDestinationFile().trim().equals("")) {
            throw new XDocletException("Error with the 'manifestFile' attribute.");
        }
        if (ManifestSubTask.getClassPattern() == null || ManifestSubTask.getClassPattern().trim().equals("")) {
            throw new XDocletException("'pattern' parameter missing or empty.");
        }
        if (ManifestSubTask.getClassPattern().indexOf("{0}") == -1) {
            throw new XDocletException("'pattern' parameter does not have a '{0}' in it. ");
        }
    }

    static {
        GENERATED_FILE_NAME = "{0}.mf";
        DEFAULT_TEMPLATE_FILE = "/src/manifest/manifest.j";
    }
}

