/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */
package org.apache.excalibur.fortress;

/**
 * Provides constants used to access the Context object for containers.
 * A container should allow these values to propagate down to child containers,
 * so that they may create child containers in turn.
 *
 * @author <a href="mailto:bloritsch@apache.org">Berin Loritsch</a>
 * @version CVS $Revision: 1.5 $ $Date: 2002/04/04 16:04:28 $
 */
public interface ContainerConstants
{
    String CONTEXT_CLASSLOADER = "container.classloader";
    String CONTEXT_DIRECTORY = "context-root";
    String WORK_DIRECTORY = "container.workDir";

    String LOGGER_MANAGER = "container.logManager";

    String COMMAND_QUEUE = "container.commandQueue";

    String POOL_MANAGER = "container.poolManager";

    String INSTRUMENT_MANAGER = "container.instrumentManager";

    String ROLE_MANAGER = "container.roleManager";

    String THREADS_CPU = "container.threadsPerCPU";
    String THREAD_TIMEOUT = "container.threadTimeout";

    String COMPONENT_CONFIGURATION = "container.configuration";
    String COMPONENT_MANAGER = "container.componentManager";
}
