/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */
package org.apache.excalibur.fortress;

/**
 * Provides constants used to access the Context object for container managers.
 * A container manager can assume that all these elements are present in
 * the initial context.
 *
 * @author <a href="mailto:leo.sutic@inspireinfrastructure.com">Leo Sutic</a>
 * @version CVS $Revision: 1.5 $ $Date: 2002/04/04 16:04:28 $
 */
public interface ContainerManagerConstants extends ContainerConstants
{
    /**
     * Class: The class of the container.
     */
    String CONTAINER_CLASS = "container.class";

    /**
     * ComponentManager: The component manager to give to the container.
     */
    String COMPONENT_MANAGER = "container.componentManager";

    /**
     * Configuration: The configuration to give to the container.
     */
    String CONFIGURATION = "container.configuration";

    /**
     * Parameters: The Parameters object to give to the container.
     */
    String PARAMETERS = "container.parameters";
}
