/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */
package org.apache.excalibur.fortress;

import org.apache.avalon.framework.CascadingException;

/**
 * This exception is used to indicate something went horribly wrong in the
 * ContainerManager, and it is unable to create a new instance of your Container.
 *
 * @author <a href="mailto:bloritsch@apache.org">Berin Loritsch</a>
 * @version CVS $Revision: 1.4 $ $Date: 2002/04/04 16:04:28 $
 */
public class InitializationException extends CascadingException
{
    public InitializationException( final String message )
    {
        super( message );
    }

    public InitializationException( final String message, final Throwable source )
    {
        super( message, source );
    }
}

