/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */
package org.apache.excalibur.fortress.markers;

import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;

/**
 * <code>ComponentMarker</code> interface. This interface defines the methods that
 * a <code>MarkerManager</code> can call on a particular concrete
 * <code>ComponentMarker</code> class.
 *
 * @author <a href="mailto:crafterm@apache.org">Marcus Crafter</a>
 * @version 1.0
 */
public interface ComponentMarker
{
	/**
	 * Create, called when the given component is being 
	 * instantiated.
	 *
	 * @param component a <code>Component</code> instance
	 * @param context a <code>Context</code> instance
	 * @exception Exception if an error occurs
	 */
	void create(Component component, Context context)
		throws Exception;

	/**
	 * Destroy, called when the given component is being
	 * decomissioned.
	 *
	 * @param component a <code>Component</code> instance
	 * @param context a <code>Context</code> instance
	 * @exception Exception if an error occurs
	 */
	void destroy(Component component, Context context)
		throws Exception;

	/**
	 * Access, called when the given component is being
	 * accessed (ie. via lookup() or select()).
	 *
	 * @param component a <code>Component</code> instance
	 * @param context a <code>Context</code> instance
	 * @exception Exception if an error occurs
	 */
	void access(Component component, Context context)
		throws Exception;

	/**
	 * Release, called when the given component is being
	 * released (ie. by a CM or CS).
	 *
	 * @param component a <code>Component</code> instance
	 * @param context a <code>Context</code> instance
	 * @exception Exception if an error occurs
	 */
	void release(Component component, Context context)
		throws Exception;
}
