/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */
package org.apache.excalibur.fortress.markers;

import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;

/**
 * <code>MarkerManager</code> class. Defines the marker operations that
 * can be executed on a particular component. See <i>markers.xml</i> for
 * more information defining the markers being executed and their 
 * applicable phases.
 *
 * @author <a href="mailto:crafterm@apache.org">Marcus Crafter</a>
 * @version 1.0
 */
public class MarkerManager extends AbstractMarkerManager
{
	public MarkerManager() throws Exception { super(); }

	/**
	 * <code>executeAccessMarkers</code> method, executes all <i>access</i>
	 * level markers on the given component.
	 *
	 * @param component a <code>Component</code> instance
	 * @param context a <code>Context</code> instance
	 * @exception Exception if an error occurs
	 */
	public void executeAccessMarkers(Component component, Context context)
		throws Exception
	{
		executeMarkers(m_accessMarkers, component, context, ACCESS);
	}

	/**
	 * <code>executeReleaseMarkers</code> method, executes all <i>release</i>
	 * level markers on the given component.
	 *
	 * @param component a <code>Component</code> instance
	 * @param context a <code>Context</code> instance
	 * @exception Exception if an error occurs
	 */
	public void executeReleaseMarkers(Component component, Context context)
		throws Exception
	{
		executeMarkers(m_releaseMarkers, component, context, RELEASE);
	}

	/**
	 * <code>executeCreationMarkers</code> method, executes all <i>creation</i>
	 * level markers on the given component.
	 *
	 * @param component a <code>Component</code> instance
	 * @param context a <code>Context</code> instance
	 * @exception Exception if an error occurs
	 */
	public void executeCreationMarkers(Component component, Context context)
		throws Exception
	{
		executeMarkers(m_creationMarkers, component, context, CREATION);
	}

	/**
	 * <code>executeDestructionMarkers</code> method, executes all <i>destruction</i>
	 * level markers on the given component.
	 *
	 * @param component a <code>Component</code> instance
	 * @param context a <code>Context</code> instance
	 * @exception Exception if an error occurs
	 */
	public void executeDestructionMarkers(Component component, Context context)
		throws Exception
	{
		executeMarkers(m_destructionMarkers, component, context, DESTRUCTION);
	}
}
