/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */
package org.apache.excalibur.fortress.markers.impl;

import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.excalibur.fortress.ContainerConstants;
import org.apache.excalibur.fortress.markers.ComponentMarker;

/**
 * <code>AbstractMarker</code> class. This class acts as a helper
 * class for those wishing to implement <code>ComponentMarker</code>,
 * but not wanting to implement each method in its interface.
 *
 * @author <a href="mailto:crafterm@apache.org">Marcus Crafter</a>
 * @version 1.0
 */
public abstract class AbstractMarker extends AbstractLogEnabled
	implements ComponentMarker, ContainerConstants
{
	/**
	 * Empty implementation of <code>create</code>, called
	 * when the given component is being instantiated.
	 *
	 * @param component a <code>Component</code> instance
	 * @param context a <code>Context</code> instance
	 * @exception Exception if an error occurs
	 */
	public void create(Component component, Context context)
		throws Exception { }

	/**
	 * Empty implementation of <code>destroy</code>, called
	 * when the given component is being decomissioned.
	 *
	 * @param component a <code>Component</code> instance
	 * @param context a <code>Context</code> instance
	 * @exception Exception if an error occurs
	 */
	public void destroy(Component component, Context context)
		throws Exception { }

	/**
	 * Empty implementation of <code>access</code>, called
	 * when the given component is being accessed (ie. by
	 * lookup() or select()).
	 *
	 * @param component a <code>Component</code> instance
	 * @param context a <code>Context</code> instance
	 * @exception Exception if an error occurs
	 */
	public void access(Component component, Context context)
		throws Exception { }

	/**
	 * Empty implementation of <code>release</code>, called
	 * when the given component is being released (ie. by
	 * a CM or CS).
	 *
	 * @param component a <code>Component</code> instance
	 * @param context a <code>Context</code> instance
	 * @exception Exception if an error occurs
	 */
	public void release(Component component, Context context)
		throws Exception { }
}
