/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */
package org.apache.excalibur.fortress.markers.impl;

import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.context.Context;

/**
 * <code>InitializableMarkerImpl</code> class, implements the standard
 * avalon <code>Initializable</code> interface.
 *
 * @author <a href="mailto:crafterm@apache.org">Marcus Crafter</a>
 * @version 1.0
 */
public class InitializableMarkerImpl extends AbstractMarker
{
	/**
	 * <code>create</code> method, initializes the given component
	 *
	 * @param component a <code>Component</code> instance
	 * @param context a <code>Context</code> instance
	 * @exception Exception if an error occurs
	 */
	public void create(Component component, Context context)
		throws Exception
	{
		ContainerUtil.initialize(component);
	}
}
